/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model;

import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.internal.core.editor.palette.model.entry.BundleLibraryInfo;
import org.eclipse.wb.internal.core.editor.palette.model.entry.LibraryInfo;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.tests.designer.core.AbstractJavaProjectTest;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class LibraryInfoTest
extends AbstractJavaProjectTest {
    private static final String SYMBOLIC_NAME = "com.miglayout.swing";
    private IConfigurationElement libraryElement;
    private LibraryInfo libraryInfo;
    private IFile libraryFile;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            LibraryInfoTest.do_projectCreate();
        }
        this.libraryElement = LibraryInfoTest.findBundleLibrary(SYMBOLIC_NAME);
        this.libraryInfo = new BundleLibraryInfo(this.libraryElement);
        this.libraryFile = this.getBundleFile(SYMBOLIC_NAME);
    }

    @Test
    public void test_addBundleLibrary() throws Exception {
        LibraryInfoTest.assertFalse((boolean)this.libraryFile.exists());
        this.libraryInfo.ensure(m_javaProject);
        LibraryInfoTest.assertTrue((boolean)this.libraryFile.exists());
    }

    @Test
    public void test_updateBundle() throws Exception {
        ProjectUtils.addPluginLibraries((IJavaProject)m_javaProject, (String)SYMBOLIC_NAME);
        LibraryInfoTest.assertTrue((boolean)this.libraryFile.exists());
        this.libraryFile.setPersistentProperty(BundleLibraryInfo.VERSION, "0.0.1");
        LibraryInfoTest.assertEquals((Object)this.libraryFile.getPersistentProperty(BundleLibraryInfo.VERSION), (Object)"0.0.1");
        this.libraryInfo.ensure(m_javaProject);
        LibraryInfoTest.assertNotEquals((Object)this.libraryFile.getPersistentProperty(BundleLibraryInfo.VERSION), (Object)"0.0.1");
    }

    private IFile getBundleFile(String symbolicName) {
        Bundle bundle = Platform.getBundle((String)symbolicName);
        LibraryInfoTest.assertNotNull((String)("Bundle not found: " + symbolicName), (Object)bundle);
        File bundleFile = FileLocator.getBundleFileLocation((Bundle)bundle).orElse(null);
        LibraryInfoTest.assertNotNull((Object)("Bundle file not found: " + symbolicName));
        return ((IProject)m_javaProject.getAdapter(IProject.class)).getFile(bundleFile.getName());
    }

    private static IConfigurationElement findBundleLibrary(String symbolicName) {
        List toolkitElements = DescriptionHelper.getToolkitElements();
        IConfigurationElement libraryElement = toolkitElements.stream().flatMap(element -> Stream.of(element.getChildren("palette"))).flatMap(element -> Stream.of(element.getChildren("component"))).flatMap(element -> Stream.of(element.getChildren("bundle-library"))).filter(element -> symbolicName.equals(element.getAttribute("symbolicName"))).findFirst().orElse(null);
        LibraryInfoTest.assertNotNull((String)"bundle-library extension point not found: com.miglayout.swing", (Object)libraryElement);
        return libraryElement;
    }
}

