/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.eval;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ProjectClassLoader;
import org.eclipse.wb.tests.designer.core.eval.AbstractEngineTest;
import org.junit.Before;
import org.junit.Test;

public class EngineTest
extends AbstractEngineTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            EngineTest.do_projectCreate();
        }
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_fail() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tint foo(int value) {\n\t\treturn value;\n\t}\n}");
        try {
            this.evaluateSingleMethod(typeDeclaration, "foo(int)");
            EngineTest.fail();
        }
        catch (Throwable e_) {
            DesignerException e = DesignerExceptionUtils.getDesignerException((Throwable)e_);
            EngineTest.assertEquals((long)304L, (long)e.getCode());
        }
    }

    @Test
    public void test_EvaluationContext_evaluationFailed_noResult() throws Exception {
        EngineTest.setFileContentSrc("test/MyObject.java", EngineTest.getSource("package test;", "public class MyObject {", "  public static int getValue() {", "    throw new IllegalStateException();", "  }", "}"));
        EngineTest.waitForAutoBuild();
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic void root() {\n\t\tMyObject.getValue();\n\t}\n}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        Expression expression = (Expression)this.m_lastEditor.getEnclosingNode("MyObject.getValue()").getParent();
        final AtomicBoolean evaluationFailed = new AtomicBoolean();
        ProjectClassLoader projectClassLoader = CodeUtils.getProjectClassLoader((IJavaProject)this.m_lastEditor.getModelUnit().getJavaProject());
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{methodDeclaration});
        EvaluationContext context = new EvaluationContext((ClassLoader)projectClassLoader, flowDescription){

            public Object evaluationFailed(Expression expression_, Throwable e) throws Exception {
                evaluationFailed.set(true);
                return AstEvaluationEngine.UNKNOWN;
            }
        };
        try {
            AstEvaluationEngine.evaluate((EvaluationContext)context, (Expression)expression);
            EngineTest.fail();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EngineTest.assertTrue((boolean)evaluationFailed.get());
    }

    @Test
    public void test_EvaluationContext_evaluationFailed_returnResult() throws Exception {
        EngineTest.setFileContentSrc("test/MyObject.java", EngineTest.getSource("package test;", "public class MyObject {", "  public static int getValue() {", "    throw new IllegalStateException();", "  }", "}"));
        EngineTest.waitForAutoBuild();
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic void root() {\n\t\tMyObject.getValue();\n\t}\n}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        Expression expression = (Expression)this.m_lastEditor.getEnclosingNode("MyObject.getValue()").getParent();
        ProjectClassLoader projectClassLoader = CodeUtils.getProjectClassLoader((IJavaProject)this.m_lastEditor.getModelUnit().getJavaProject());
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{methodDeclaration});
        EvaluationContext context = new EvaluationContext((ClassLoader)projectClassLoader, flowDescription){

            public Object evaluationFailed(Expression expression_, Throwable e) throws Exception {
                return 123;
            }
        };
        EngineTest.assertEquals((Object)123, (Object)AstEvaluationEngine.evaluate((EvaluationContext)context, (Expression)expression));
    }

    @Test
    public void test_null() throws Exception {
        EngineTest.assertEquals(null, (Object)this.evaluateExpression("null", "java.lang.Object"));
    }

    @Test
    public void test_parenthesis() throws Exception {
        EngineTest.assertEquals(null, (Object)this.evaluateExpression("(null)", "java.lang.Object"));
    }

    @Test
    public void test_SimpleName_notFound() throws Exception {
        this.createTypeDeclaration("test", "BaseClass.java", EngineTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class BaseClass {", "  protected int m_value;", "}"));
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "BaseSubClass.java", EngineTest.getSourceDQ("package test;", "public class BaseSubClass extends BaseClass {", "  public int getValue() {", "    return m_value;", "  }", "}"));
        EngineTest.waitForAutoBuild();
        try {
            this.evaluateSingleMethod(typeDeclaration, "getValue()");
            EngineTest.fail();
        }
        catch (Throwable e_) {
            DesignerException e = DesignerExceptionUtils.getDesignerException((Throwable)e_);
            EngineTest.assertEquals((long)303L, (long)e.getCode());
        }
    }

    @Test
    public void test_SimpleName_local() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", EngineTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "  public String use_simpleName_local() {", "    String s = '12345';", "    return s;", "  }", "}"));
        Object actual = this.evaluateSingleMethod(typeDeclaration, "use_simpleName_local()");
        EngineTest.assertEquals((Object)"12345", (Object)actual);
    }

    @Test
    public void test_SimpleName_field() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", EngineTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "  private final String m_fieldString = '12345';", "  public String use_simpleName_field() {", "    return m_fieldString;", "  }", "}"));
        Object actual = this.evaluateSingleMethod(typeDeclaration, "use_simpleName_field()");
        EngineTest.assertEquals((Object)"12345", (Object)actual);
    }

    @Test
    public void test_SimpleName_assignment() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", EngineTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "  public String use_simpleName_assignment() {", "    String s = '23';", "    s = '12345';", "    return s;", "  }", "}"));
        Object actual = this.evaluateSingleMethod(typeDeclaration, "use_simpleName_assignment()");
        EngineTest.assertEquals((Object)"12345", (Object)actual);
    }

    @Test
    public void test_SimpleName_recursiveAssignment() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic int root() {\n\t\tint value = 4;\n\t\tvalue = value + 1;\n\t\treturn value;\n\t}\n}");
        Object actual = this.evaluateSingleMethod(typeDeclaration, "root()");
        EngineTest.assertEquals((Object)5, (Object)actual);
    }

    @Test
    public void test_SimpleName_inv_good() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic void root() {\n\t\tfoo(\"12345\");\n\t}\n\tpublic String foo(String s) {\n\t\treturn s;\n\t}\n}");
        Object actual = this.evaluateSingleMethod(typeDeclaration, "root()", "foo(java.lang.String)");
        EngineTest.assertEquals((Object)"12345", (Object)actual);
    }

    @Test
    public void test_SimpleName_inv_noInvocation() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic int foo(int value) {\n\t\treturn value;\n\t}\n}");
        try {
            this.evaluateSingleMethod(typeDeclaration, "foo(int)");
            EngineTest.fail();
        }
        catch (Throwable e_) {
            DesignerException e = DesignerExceptionUtils.getDesignerException((Throwable)e_);
            EngineTest.assertEquals((long)304L, (long)e.getCode());
        }
    }

    @Test
    public void test_SimpleName_inv_twoInvocation() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic void root() {\n\t\tfoo(\"111\");\n\t\tfoo(\"222\");\n\t}\n\tpublic String foo(String s) {\n\t\treturn s;\n\t}\n}");
        Object actual = this.evaluateSingleMethod(typeDeclaration, "root()", "foo(java.lang.String)");
        EngineTest.assertEquals((Object)"111", (Object)actual);
    }

    @Test
    public void test_SimpleName_inheritedConstant() throws Exception {
        EngineTest.setFileContentSrc("test/SuperClass.java", EngineTest.getSourceDQ("package test;", "public class SuperClass {", "  public static int FOO = 555;", "}"));
        EngineTest.waitForAutoBuild();
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test extends SuperClass {\n\tpublic int foo() {\n\t\treturn FOO;\n\t}\n}");
        EngineTest.waitForAutoBuild();
        EngineTest.assertEquals((Object)555, (Object)this.evaluateSingleMethod(typeDeclaration, "foo()"));
    }

    @Test
    public void test_SimpleName_localConstant() throws Exception {
        EngineTest.waitForAutoBuild();
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic static int FOO = 222;\n\t\tpublic int foo() {\n\t\treturn FOO;\n\t}\n}");
        EngineTest.assertEquals((Object)222, (Object)this.evaluateSingleMethod(typeDeclaration, "foo()"));
    }

    @Test
    public void test_SimpleName_fieldWithoutInitializer() throws Exception {
        EngineTest.waitForAutoBuild();
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Object field;\n\tpublic Object foo() {\n\t\treturn field;\n\t}\n}");
        EngineTest.assertEquals(null, (Object)this.evaluateSingleMethod(typeDeclaration, "foo()"));
    }

    @Test
    public void test_SimpleName_interfaceConstant() throws Exception {
        EngineTest.setFileContentSrc("test/IConstants.java", EngineTest.getSourceDQ("package test;", "public interface IConstants {", "  int FOO = 555;", "}"));
        EngineTest.waitForAutoBuild();
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test implements IConstants {\n\tpublic int foo() {\n\t\treturn FOO;\n\t}\n}");
        EngineTest.waitForAutoBuild();
        EngineTest.assertEquals((Object)555, (Object)this.evaluateSingleMethod(typeDeclaration, "foo()"));
    }

    @Test
    public void test_QualifiedName_1() throws Exception {
        EngineTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.evaluateExpression("java.util.Collections.EMPTY_LIST", "java.lang.Object"));
    }

    @Test
    public void test_QualifiedName_2() throws Exception {
        Integer actualValue = (Integer)this.evaluateExpression("javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS", "int");
        EngineTest.assertEquals((long)32L, (long)actualValue.intValue());
    }

    @Test
    public void test_QualifiedName_3() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tpublic int foo() {\n\t\tint[] ints = new int[]{1,2,3};\n\t\treturn ints.length;\n\t}\n}");
        EngineTest.waitForAutoBuild();
        Object actual = this.evaluateSingleMethod(typeDeclaration, "foo()");
        EngineTest.assertEquals((Object)3, (Object)actual);
    }

    @Test
    public void test_QualifiedName_4() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import java.awt.Dimension;\nclass Test {\n\tpublic int foo() {\n\t\tDimension dimension = new Dimension(1, 2);\n\t\treturn dimension.width;\n\t}\n}");
        Object actual = this.evaluateSingleMethod(typeDeclaration, "foo()");
        EngineTest.assertEquals((Object)1, (Object)actual);
    }

    @Test
    public void test_FieldAccess() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tpublic int use_fieldAccess() {\n\t\treturn new Foo(12345).m_value;\n\t}\n\tpublic static class Foo {\n\t\tpublic final int m_value;\n\t\tpublic Foo(int value) {\n\t\tm_value = value;\n\t\t}\n\t}\n}");
        EngineTest.waitForAutoBuild();
        Object actual = this.evaluateSingleMethod(typeDeclaration, "use_fieldAccess()");
        EngineTest.assertEquals((Object)12345, (Object)actual);
    }

    @Test
    public void test_assignment() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tpublic void foo() {\n\t\tint a;\n\t\tint b;\n\t\ta = b = 5;\n\t}\n}");
        EngineTest.waitForAutoBuild();
        MethodDeclaration methodDeclaration = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"foo()");
        List statements = DomGenerics.statements((Block)methodDeclaration.getBody());
        ProjectClassLoader projectClassLoader = CodeUtils.getProjectClassLoader((IJavaProject)this.m_lastEditor.getModelUnit().getJavaProject());
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{methodDeclaration});
        EvaluationContext context = new EvaluationContext((ClassLoader)projectClassLoader, flowDescription);
        ExpressionStatement statement = (ExpressionStatement)statements.get(2);
        Object result = AstEvaluationEngine.evaluate((EvaluationContext)context, (Expression)statement.getExpression());
        EngineTest.assertEquals((Object)5, (Object)result);
    }

    @Test
    public void test_assignment_array1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n  public int[] foo() {\n    int[] a = new int[] { 5 };\n    return a;\n  }\n}");
        EngineTest.waitForAutoBuild();
        int[] result = (int[])this.evaluateSingleMethod(typeDeclaration, "foo()");
        EngineTest.assertArrayEquals((int[])new int[]{5}, (int[])result);
    }

    @Test
    public void test_assignment_array2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n  public int[] foo() {\n    int[] a = new int[] { 1 };\n    a[0] = 5;\n    return a;\n  }\n}");
        EngineTest.waitForAutoBuild();
        int[] result = (int[])this.evaluateSingleMethod(typeDeclaration, "foo()");
        EngineTest.assertArrayEquals((int[])new int[]{5}, (int[])result);
    }

    @Test
    public void test_assignment_array3() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n  public int[] foo() {\n    int[] a = new int[1];\n    a[0] = 5;\n    return a;\n  }\n}");
        EngineTest.waitForAutoBuild();
        int[] result = (int[])this.evaluateSingleMethod(typeDeclaration, "foo()");
        EngineTest.assertArrayEquals((int[])new int[]{5}, (int[])result);
    }

    @Test
    public void test_assignment_array4() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n  public int[] foo() {\n    int[] a = new int[1];\n    a[0] = 1;\n    a = new int[1];\n    a[0] = 5;\n    return a;\n  }\n}");
        EngineTest.waitForAutoBuild();
        int[] result = (int[])this.evaluateSingleMethod(typeDeclaration, "foo()");
        EngineTest.assertArrayEquals((int[])new int[]{5}, (int[])result);
    }

    @Test
    public void test_ConditionalExpression_1() throws Exception {
        EngineTest.assertEquals((Object)1, (Object)this.evaluateExpression("true ? 1 : 2", "int"));
    }

    @Test
    public void test_ConditionalExpression_2() throws Exception {
        EngineTest.assertEquals((Object)2, (Object)this.evaluateExpression("false? 1 : 2", "int"));
    }
}

