/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.handles.MoveHandle;
import org.eclipse.wb.gef.graphical.handles.ResizeHandle;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.gef.graphical.policies.SelectionEditPolicy;
import org.eclipse.wb.gef.graphical.tools.ResizeTracker;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.gef.core.EditDomain;
import org.eclipse.wb.internal.gef.graphical.GraphicalViewer;
import org.eclipse.wb.tests.gef.CursorLogger;
import org.eclipse.wb.tests.gef.EventSender;
import org.eclipse.wb.tests.gef.GefTestCase;
import org.junit.After;
import org.junit.Before;

public abstract class GefCursorTestCase
extends GefTestCase {
    protected Shell m_shell;
    protected GraphicalViewer m_viewer;
    protected EditDomain m_domain;
    protected CursorLogger m_actualLogger;
    protected EventSender m_sender;
    protected IDefaultToolProvider m_defaultToolProvider;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.m_shell = new Shell();
        this.m_actualLogger = new CursorLogger();
        this.m_viewer = new TestGraphicalViewer(this.m_shell, this.m_actualLogger);
        this.m_viewer.getControl().setSize(500, 400);
        this.m_domain = new EditDomain(){

            public Tool getDefaultTool() {
                if (GefCursorTestCase.this == null || GefCursorTestCase.this.m_defaultToolProvider == null) {
                    return null;
                }
                return GefCursorTestCase.this.m_defaultToolProvider.getDefaultTool();
            }
        };
        this.m_viewer.setEditDomain(this.m_domain);
        this.m_sender = new EventSender((Control)this.m_viewer.getControl());
    }

    @After
    public void tearDown() throws Exception {
        this.m_shell.dispose();
        this.m_shell = null;
        this.m_viewer = null;
        this.m_actualLogger = null;
        this.m_sender = null;
        this.m_defaultToolProvider = null;
    }

    protected static final GraphicalEditPart createEditPart(EditPart parentEditPart, int x, int y, int width, int height, final Command acceptCreateCommand, final Command acceptResizeCommand) throws Exception {
        GraphicalEditPart editPart = new GraphicalEditPart(){

            protected void createEditPolicies() {
                this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new LayoutEditPolicy(){

                    protected Command getCreateCommand(CreateRequest request) {
                        return acceptCreateCommand;
                    }
                });
                this.installEditPolicy("Selection Feedback", (EditPolicy)new SelectionEditPolicy(){

                    protected List<Handle> createSelectionHandles() {
                        ArrayList<Handle> handles = new ArrayList<Handle>();
                        handles.add((Handle)new MoveHandle(this.getHost()));
                        handles.add(this.createResizeHandle(16));
                        handles.add(this.createResizeHandle(20));
                        handles.add(this.createResizeHandle(4));
                        handles.add(this.createResizeHandle(12));
                        handles.add(this.createResizeHandle(8));
                        handles.add(this.createResizeHandle(9));
                        handles.add(this.createResizeHandle(1));
                        handles.add(this.createResizeHandle(17));
                        return handles;
                    }

                    private Handle createResizeHandle(int direction) {
                        ResizeHandle handle = new ResizeHandle(this.getHost(), direction);
                        handle.setDragTrackerTool((Tool)new ResizeTracker(direction, (Object)"REQ_RESIZE"));
                        return handle;
                    }

                    public boolean understandsRequest(Request request) {
                        return super.understandsRequest(request) || "REQ_RESIZE".equals(request.getType());
                    }

                    public org.eclipse.wb.gef.core.EditPart getTargetEditPart(Request request) {
                        if (this.understandsRequest(request)) {
                            return this.getHost();
                        }
                        return super.getTargetEditPart(request);
                    }

                    public Command getCommand(Request request) {
                        if (this.understandsRequest(request)) {
                            return acceptResizeCommand;
                        }
                        return null;
                    }
                });
            }

            protected Figure createFigure() {
                return new Figure();
            }
        };
        editPart.getFigure().setBounds(new Rectangle(x, y, width, height));
        GefCursorTestCase.addChildEditPart(parentEditPart, (EditPart)editPart);
        return editPart;
    }

    protected static interface IDefaultToolProvider {
        public Tool getDefaultTool();
    }

    private static final class TestGraphicalViewer
    extends GraphicalViewer {
        protected TestGraphicalViewer(Shell parent, final CursorLogger actualLogger) {
            super(new FigureCanvas((Composite)parent, 768){

                protected void setDefaultEventManager() {
                }

                public void setCursor(Cursor cursor) {
                    actualLogger.setCursor(cursor);
                    super.setCursor(cursor);
                }
            });
        }
    }
}

