/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts.grid;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jface.action.IAction;
import org.eclipse.wb.core.gef.policy.selection.NonResizableSelectionEditPolicy;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.GridSelectionEditPolicy;
import org.eclipse.wb.internal.swt.model.layout.grid.GridColumnInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridRowInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.palette.AbsoluteLayoutEntryInfo;
import org.eclipse.wb.tests.designer.rcp.RcpGefTest;
import org.eclipse.wb.tests.gef.GraphicalRobot;
import org.junit.Ignore;
import org.junit.Test;

public class GridLayoutGefTest
extends RcpGefTest {
    private static final int M = 5;
    private static final int S = 5;
    private static final int VS = 25;
    private static final int VG = 5;
    private CompositeInfo composite;
    private GridLayoutInfo layout;
    private GraphicalRobot horizontalRobot;
    private GraphicalRobot verticalRobot;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_deleteChildAndAncestorResize() throws Exception {
        this.openPanel("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new GridLayout());", "      {", "        Label label = new Label(composite, SWT.NONE);", "        label.setText('Label');", "      }", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setText('Button');", "      }", "    }", "  }", "}");
        this.assertJavaInfo("composite");
        this.assertJavaInfo("label");
        this.assertJavaInfo("button");
        ControlInfo button = (ControlInfo)GridLayoutGefTest.getJavaInfoByName("button");
        this.canvas.select(button);
        GridLayoutGefTest.waitEventLoop(20);
        IAction deleteAction = this.getDeleteAction();
        GridLayoutGefTest.assertTrue((boolean)deleteAction.isEnabled());
        deleteAction.run();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new GridLayout());", "      {", "        Label label = new Label(composite, SWT.NONE);", "        label.setText('Label');", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_replaceGridLayout_withAbsolute() throws Exception {
        this.prepareComponent();
        this.openPanel("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        this.canvas.select(this.composite);
        GridLayoutGefTest.waitEventLoop(20);
        AbsoluteLayoutEntryInfo absoluteEntry = new AbsoluteLayoutEntryInfo();
        absoluteEntry.initialize((IEditPartViewer)this.m_viewerCanvas, (JavaInfo)this.composite);
        absoluteEntry.activate(false);
        this.canvas.target(this.composite).in(250, 50).move().click();
        GridLayoutGefTest.waitEventLoop(20);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setBounds(5, 5, 100, 50);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setBounds(110, 60, 100, 50);", "    }", "  }", "}");
    }

    @Test
    public void test_change_numColumns() throws Exception {
        this.openPanel("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    Button button_00 = new Button(this, SWT.NONE);", "    Button button_01 = new Button(this, SWT.NONE);", "  }", "}");
        this.canvas.select(this.composite);
        GridLayoutGefTest.assertEquals((long)1L, (long)this.layout.getColumns().size());
        GridLayoutGefTest.assertEquals((long)2L, (long)this.layout.getRows().size());
        this.layout.getPropertyByTitle("numColumns").setValue((Object)2);
        this.assertNoLoggedExceptions();
        GridLayoutGefTest.assertEquals((long)2L, (long)this.layout.getColumns().size());
        GridLayoutGefTest.assertEquals((long)1L, (long)this.layout.getRows().size());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    Button button_00 = new Button(this, SWT.NONE);", "    Button button_01 = new Button(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_markAsExcluded() throws Exception {
        this.openPanel("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)GridLayoutGefTest.getJavaInfoByName("button");
        GraphicalEditPart buttonPart = this.canvas.getEditPart(button);
        this.canvas.select(button);
        GridLayoutGefTest.assertInstanceOf(GridSelectionEditPolicy.class, (Object)buttonPart.getEditPolicy((Object)"Selection Feedback"));
        GridLayoutInfo.getGridData((ControlInfo)button).getPropertyByTitle("exclude").setValue((Object)true);
        this.assertNoLoggedExceptions();
        GridLayoutGefTest.assertInstanceOf(NonResizableSelectionEditPolicy.class, (Object)buttonPart.getEditPolicy((Object)"Selection Feedback"));
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gd_button = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);", "        gd_button.exclude = true;", "        button.setLayoutData(gd_button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_indirectlyExposed() throws Exception {
        this.openPanel("import org.eclipse.ui.dialogs.FilteredTree;", "import org.eclipse.ui.dialogs.PatternFilter;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    FilteredTree filteredTree = new FilteredTree(this, SWT.NONE, new PatternFilter());", "  }", "}");
        CompositeInfo filteredTree = (CompositeInfo)GridLayoutGefTest.getJavaInfoByName("filteredTree");
        ControlInfo filterControl = (ControlInfo)filteredTree.getChildrenControls().get(0);
        GraphicalEditPart buttonPart = this.canvas.getEditPart(filterControl);
        GridLayoutGefTest.assertInstanceOf(NonResizableSelectionEditPolicy.class, (Object)buttonPart.getEditPolicy((Object)"Selection Feedback"));
    }

    @Test
    public void test_moveOut() throws Exception {
        this.openPanel("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Group group = new Group(this, SWT.NONE);", "      group.setLayout(new FillLayout());", "      group.setText('My Group');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        CompositeInfo group = (CompositeInfo)GridLayoutGefTest.getJavaInfoByName("group");
        ControlInfo button = (ControlInfo)GridLayoutGefTest.getJavaInfoByName("button");
        this.canvas.select(button);
        GraphicalEditPart buttonPart = this.canvas.getEditPart(button);
        EditPolicy selectionPolicy = buttonPart.getEditPolicy((Object)"Selection Feedback");
        GridLayoutGefTest.assertInstanceOf(GridSelectionEditPolicy.class, (Object)selectionPolicy);
        this.canvas.beginDrag(button).dragTo((Object)group, 0.5, 0.5).endDrag();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Group group = new Group(this, SWT.NONE);", "      group.setLayout(new FillLayout());", "      group.setText('My Group');", "      {", "        Button button = new Button(group, SWT.NONE);", "      }", "    }", "  }", "}");
        buttonPart = this.canvas.getEditPart(button);
        selectionPolicy = buttonPart.getEditPolicy((Object)"Selection Feedback");
        GridLayoutGefTest.assertInstanceOf(NonResizableSelectionEditPolicy.class, (Object)selectionPolicy);
    }

    @Test
    public void test_setSizeHint_width() throws Exception {
        this.openPanel("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)GridLayoutGefTest.getJavaInfoByName("button");
        this.canvas.toResizeHandle(button, "resize_size", 16).beginDrag();
        this.canvas.target(button).in(200, 0).drag().endDrag();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gd_button = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);", "        gd_button.widthHint = 200;", "        button.setLayoutData(gd_button);", "      }", "      button.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_setSizeHint_height() throws Exception {
        this.openPanel("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)GridLayoutGefTest.getJavaInfoByName("button");
        this.canvas.toResizeHandle(button, "resize_size", 4).beginDrag();
        this.canvas.target(button).in(0, 50).drag();
        this.canvas.endDrag();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gd_button = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);", "        gd_button.heightHint = 50;", "        button.setLayoutData(gd_button);", "      }", "      button.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_setAlignment_usingKeyboard() throws Exception {
        this.openPanel("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)GridLayoutGefTest.getJavaInfoByName("button");
        this.canvas.select(button);
        this.canvas.keyDown(0, 'h');
        this.assert_setAlignment("SWT.LEFT, SWT.CENTER, true, false");
        this.canvas.keyDown(0, 'h');
        this.assert_setAlignment(null);
        this.canvas.keyDown(0, 'r');
        this.assert_setAlignment("SWT.RIGHT, SWT.CENTER, false, false");
        this.canvas.keyDown(0, 'c');
        this.assert_setAlignment("SWT.CENTER, SWT.CENTER, false, false");
        this.canvas.keyDown(0, 'f');
        this.assert_setAlignment("SWT.FILL, SWT.CENTER, false, false");
        this.canvas.keyDown(0, 'l');
        this.assert_setAlignment(null);
        this.canvas.keyDown(0, 'v');
        this.assert_setAlignment("SWT.LEFT, SWT.CENTER, false, true");
        this.canvas.keyDown(0, 'v');
        this.assert_setAlignment(null);
        this.canvas.keyDown(0, 't');
        this.assert_setAlignment("SWT.LEFT, SWT.TOP, false, false");
        this.canvas.keyDown(0, 'b');
        this.assert_setAlignment("SWT.LEFT, SWT.BOTTOM, false, false");
        this.canvas.keyDown(0, 'F');
        this.assert_setAlignment("SWT.LEFT, SWT.FILL, false, false");
        this.canvas.keyDown(0, 'm');
        this.assert_setAlignment(null);
        this.canvas.keyDown(0, 'o');
        this.assert_setAlignment("SWT.FILL, SWT.FILL, true, true");
    }

    private void assert_setAlignment(String alignmentString) {
        if (alignmentString != null) {
            this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(" + alignmentString + ", 1, 1));", "      button.setText('New Button');", "    }", "  }", "}");
        } else {
            this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
        }
    }

    @Test
    public void test_CREATE_filled() throws Exception {
        this.openPanel("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "  }", "}");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)this.composite, 5, 5);
        this.canvas.assertCommandNull();
    }

    @Test
    public void test_CREATE_filledByInherited() throws Exception {
        GridLayoutGefTest.setFileContentSrc("test/MyShell.java", this.getTestSource2("public class MyShell extends Shell {", "  public MyShell() {", "    super(SWT.NONE);", "    setLayout(new GridLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('Implicit Button');", "    }", "  }", "  protected void checkSubclass() {", "  }", "}"));
        GridLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyShell {", "  public Test() {", "  }", "}");
        this.loadButtonWithText();
        Rectangle cell = new Rectangle(0, 0, 1, 1);
        Rectangle cellRectangle = this.layout.getGridInfo().getCellsRectangle(cell);
        Point cellCenter = cellRectangle.getCenter();
        this.canvas.moveTo((Object)this.composite, cellCenter.x, cellCenter.y);
        this.canvas.assertCommandNull();
    }

    @Test
    public void test_CREATE_virtual_0x0() throws Exception {
        this.openPanel("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "  }", "}");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)this.composite, 5, 5);
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_virtual_0x1() throws Exception {
        this.openPanel("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "  }", "}");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)this.composite, 35, 5);
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_appendToColumn_1x0() throws Exception {
        this.openPanel("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "  }", "}");
        Object existingButton = GridLayoutGefTest.getJavaInfoByName("existingButton");
        this.loadButtonWithText();
        this.canvas.target(existingButton).inX(0.5).outY(6).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_appendToRow_0x1() throws Exception {
        this.openPanel("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "  }", "}");
        Object existingButton = GridLayoutGefTest.getJavaInfoByName("existingButton");
        this.loadButtonWithText();
        this.canvas.target(existingButton).inY(0.5).outX(6).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_beforeFirstRow() throws Exception {
        this.openPanel("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "  }", "}");
        Object existingButton = GridLayoutGefTest.getJavaInfoByName("existingButton");
        this.loadButtonWithText();
        this.canvas.target(existingButton).inX(0.5).outY(-2).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_beforeFirstColumn() throws Exception {
        this.openPanel("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "  }", "}");
        Object existingButton = GridLayoutGefTest.getJavaInfoByName("existingButton");
        this.loadButtonWithText();
        this.canvas.target(existingButton).inY(0.5).outX(-2).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_insertColumn() throws Exception {
        this.openPanel("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "    }", "  }", "}");
        Object button_1 = GridLayoutGefTest.getJavaInfoByName("button_1");
        this.loadButtonWithText();
        this.canvas.target(button_1).inY(0.5).outX(2).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(3, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_insertRow() throws Exception {
        this.openPanel("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "    }", "  }", "}");
        Object button_1 = GridLayoutGefTest.getJavaInfoByName("button_1");
        this.loadButtonWithText();
        this.canvas.target(button_1).inX(0.5).outY(2).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_inherited_columnOperations() throws Exception {
        GridLayoutGefTest.setFileContentSrc("test/MyShell.java", this.getTestSource2("public class MyShell extends Shell {", "  public MyShell() {", "    super(SWT.NONE);", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Implicit #1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Implicit #2');", "    }", "  }", "  protected void checkSubclass() {", "  }", "}"));
        GridLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyShell {", "  public Test() {", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Explicit #1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Explicit #2');", "    }", "  }", "}");
        this.loadButton();
        ControlInfo button_1 = (ControlInfo)GridLayoutGefTest.getJavaInfoByName("button_1");
        this.canvas.target(button_1).inY(0.5).inX(-2).move();
        this.canvas.assertCommandNull();
        ControlInfo button_2 = (ControlInfo)GridLayoutGefTest.getJavaInfoByName("button_2");
        this.canvas.target(button_2).inY(0.5).outX(6).move();
        this.canvas.assertCommandNull();
    }

    @Test
    public void test_CREATE_inheritedEmpty_columnOperations() throws Exception {
        GridLayoutGefTest.setFileContentSrc("test/MyShell.java", this.getTestSource2("public class MyShell extends Shell {", "  public MyShell() {", "    super(SWT.NONE);", "    setLayout(new GridLayout(2, false));", "  }", "  protected void checkSubclass() {", "  }", "}"));
        GridLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyShell {", "  public Test() {", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Explicit #1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Explicit #2');", "    }", "  }", "}");
        this.loadButton();
        ControlInfo button_1 = (ControlInfo)GridLayoutGefTest.getJavaInfoByName("button_1");
        this.canvas.target(button_1).inY(0.5).inX(-2).move();
        this.canvas.assertCommandNotNull();
        ControlInfo button_2 = (ControlInfo)GridLayoutGefTest.getJavaInfoByName("button_2");
        this.canvas.target(button_2).inY(0.5).outX(6).move();
        this.canvas.assertCommandNotNull();
    }

    @Test
    public void test_CREATE_inherited_rowOperations() throws Exception {
        GridLayoutGefTest.setFileContentSrc("test/MyShell.java", this.getTestSource2("public class MyShell extends Shell {", "  public MyShell() {", "    super(SWT.NONE);", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Implicit #1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Implicit #2');", "    }", "  }", "  protected void checkSubclass() {", "  }", "}"));
        GridLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyShell {", "  public Test() {", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Explicit #1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Explicit #2');", "    }", "  }", "}");
        this.loadButton();
        this.canvas.target(this.composite).inX(10).inY(0).move();
        this.canvas.assertCommandNull();
        ControlInfo button_1 = (ControlInfo)GridLayoutGefTest.getJavaInfoByName("button_1");
        this.canvas.target(button_1).inX(0.5).outY(-1).move();
        this.canvas.assertCommandNotNull();
        button_1 = (ControlInfo)GridLayoutGefTest.getJavaInfoByName("button_1");
        this.canvas.target(button_1).inX(0.5).outY(6).move();
        this.canvas.assertCommandNotNull();
    }

    @Ignore
    @Test
    public void test_PASTE_virtual_1x0() throws Exception {
        this.openPanel("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('My Button');", "    }", "  }", "}");
        Object existingButton = GridLayoutGefTest.getJavaInfoByName("existingButton");
        this.doCopyPaste((JavaInfo)existingButton);
        this.canvas.target(existingButton).inX(0.5).outY(6).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('My Button');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('My Button');", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_virtual_1x0() throws Exception {
        this.openPanel("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('Existing Button');", "    }", "  }", "}");
        Object button = GridLayoutGefTest.getJavaInfoByName("button");
        this.canvas.beginDrag(button);
        this.canvas.target(button).inX(0.5).outY(6).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('Existing Button');", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_virtual_0x0() throws Exception {
        this.openPanel("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('Existing Button');", "    }", "    {", "      Composite target = new Composite(this, SWT.NONE);", "      target.setLayout(new GridLayout(1, false));", "    }", "  }", "}");
        Object button = GridLayoutGefTest.getJavaInfoByName("button");
        Object target = GridLayoutGefTest.getJavaInfoByName("target");
        this.canvas.beginDrag(button);
        this.canvas.dragTo(target, 17, 17);
        this.canvas.endDrag();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      Composite target = new Composite(this, SWT.NONE);", "      target.setLayout(new GridLayout(1, false));", "      {", "        Button button = new Button(target, SWT.NONE);", "        button.setText('Existing Button');", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_headerColumn_MOVE_inherited() throws Exception {
        GridLayoutGefTest.setFileContentSrc("test/MyShell.java", this.getTestSource2("public class MyShell extends Shell {", "  public MyShell() {", "    super(SWT.NONE);", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Implicit #1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Implicit #2');", "    }", "  }", "  protected void checkSubclass() {", "  }", "}"));
        GridLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyShell {", "  public Test() {", "  }", "}");
        this.canvas.select(this.composite);
        List columns = this.layout.getColumns();
        GridColumnInfo sourceColumn = (GridColumnInfo)columns.get(0);
        GridColumnInfo relativeColumn = (GridColumnInfo)columns.get(1);
        this.horizontalRobot.beginDrag(sourceColumn).dragTo((Object)relativeColumn, -5.0, 0.5);
        this.horizontalRobot.assertCommandNull();
    }

    @Test
    public void test_headerColumn_MOVE_beforeFirst() throws Exception {
        this.openPanel("public class Test extends Shell {", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Implicit #1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Implicit #2');", "    }", "  }", "}");
        this.canvas.select(this.composite);
        List columns = this.layout.getColumns();
        GridColumnInfo sourceColumn = (GridColumnInfo)columns.get(1);
        GridColumnInfo relativeColumn = (GridColumnInfo)columns.get(0);
        this.horizontalRobot.beginDrag(sourceColumn).dragTo((Object)relativeColumn, 5.0, 0.5);
        this.horizontalRobot.assertCommandNotNull();
        this.horizontalRobot.endDrag();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Implicit #2');", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Implicit #1');", "    }", "  }", "}");
    }

    @Test
    public void test_headerColumn_MOVE_afterLast() throws Exception {
        this.openPanel("public class Test extends Shell {", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new GridLayout(3, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button #1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button #2');", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "      button_3.setText('Button #3');", "    }", "  }", "}");
        this.canvas.select(this.composite);
        List columns = this.layout.getColumns();
        GridColumnInfo sourceColumn = (GridColumnInfo)columns.get(0);
        GridColumnInfo relativeColumn = (GridColumnInfo)columns.get(2);
        this.horizontalRobot.beginDrag(sourceColumn).dragTo((Object)relativeColumn, -5.0, 0.5);
        this.horizontalRobot.assertCommandNotNull();
        this.horizontalRobot.endDrag();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new GridLayout(3, false));", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button #2');", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "      button_3.setText('Button #3');", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button #1');", "    }", "  }", "}");
    }

    @Test
    public void test_headerColumn_MOVE_beforeOther() throws Exception {
        this.openPanel("public class Test extends Shell {", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new GridLayout(3, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button #1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button #2');", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "      button_3.setText('Button #3');", "    }", "  }", "}");
        this.canvas.select(this.composite);
        List columns = this.layout.getColumns();
        GridColumnInfo sourceColumn = (GridColumnInfo)columns.get(0);
        GridColumnInfo relativeColumn = (GridColumnInfo)columns.get(2);
        this.horizontalRobot.beginDrag(sourceColumn).dragTo((Object)relativeColumn, 5.0, 0.5);
        this.horizontalRobot.assertCommandNotNull();
        this.horizontalRobot.endDrag();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new GridLayout(3, false));", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button #2');", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button #1');", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "      button_3.setText('Button #3');", "    }", "  }", "}");
    }

    @Test
    public void test_headerColumn_MOVE_beforeOther_RTL() throws Exception {
        this.openPanel("public class Test extends Shell {", "  public Test() {", "    super(SWT.RIGHT_TO_LEFT);", "    setLayout(new GridLayout(3, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button #1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button #2');", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "      button_3.setText('Button #3');", "    }", "  }", "}");
        this.canvas.select(this.composite);
        List columns = this.layout.getColumns();
        GridColumnInfo sourceColumn = (GridColumnInfo)columns.get(0);
        GridColumnInfo relativeColumn = (GridColumnInfo)columns.get(2);
        this.horizontalRobot.beginDrag(sourceColumn).dragTo((Object)relativeColumn, -5.0, 0.5);
        this.horizontalRobot.assertCommandNotNull();
        this.horizontalRobot.endDrag();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    super(SWT.RIGHT_TO_LEFT);", "    setLayout(new GridLayout(3, false));", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button #2');", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button #1');", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "      button_3.setText('Button #3');", "    }", "  }", "}");
    }

    @Test
    public void test_headerRow_MOVE_inherited_moveImplicitRow() throws Exception {
        GridLayoutGefTest.setFileContentSrc("test/MyShell.java", this.getTestSource2("public class MyShell extends Shell {", "  public MyShell() {", "    super(SWT.NONE);", "    setLayout(new GridLayout(1, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Implicit #1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Implicit #2');", "    }", "  }", "  protected void checkSubclass() {", "  }", "}"));
        GridLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyShell {", "  public Test() {", "  }", "}");
        this.canvas.select(this.composite);
        List rows = this.layout.getRows();
        GridRowInfo sourceRow = (GridRowInfo)rows.get(1);
        GridRowInfo relativeRow = (GridRowInfo)rows.get(0);
        this.verticalRobot.beginDrag(sourceRow).dragTo((Object)relativeRow, 0.5, 1.0);
        this.verticalRobot.assertCommandNull();
    }

    @Test
    public void test_headerRow_MOVE_inherited_moveBeforeImplicitRow() throws Exception {
        GridLayoutGefTest.setFileContentSrc("test/MyShell.java", this.getTestSource2("public class MyShell extends Shell {", "  public MyShell() {", "    super(SWT.NONE);", "    setLayout(new GridLayout(1, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Implicit #1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Implicit #2');", "    }", "  }", "  protected void checkSubclass() {", "  }", "}"));
        GridLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyShell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('Explicit Button');", "    }", "  }", "}");
        this.canvas.select(this.composite);
        List rows = this.layout.getRows();
        GridRowInfo sourceRow = (GridRowInfo)rows.get(2);
        GridRowInfo relativeRow = (GridRowInfo)rows.get(1);
        this.verticalRobot.beginDrag(sourceRow).dragTo((Object)relativeRow, 0.5, 1.0);
        this.verticalRobot.assertCommandNull();
    }

    @Test
    public void test_headerRow_MOVE_beforeOther() throws Exception {
        this.openPanel("public class Test extends Shell {", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new GridLayout(1, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button #1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button #2');", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "      button_3.setText('Button #3');", "    }", "  }", "}");
        this.canvas.select(this.composite);
        List rows = this.layout.getRows();
        GridRowInfo sourceRow = (GridRowInfo)rows.get(2);
        GridRowInfo relativeRow = (GridRowInfo)rows.get(0);
        this.verticalRobot.beginDrag(sourceRow).dragTo((Object)relativeRow, 0.5, 1.0);
        this.verticalRobot.assertCommandNotNull();
        this.verticalRobot.endDrag();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new GridLayout(1, false));", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "      button_3.setText('Button #3');", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button #1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button #2');", "    }", "  }", "}");
    }

    @Test
    public void test_headerRow_MOVE_afterLast() throws Exception {
        this.openPanel("public class Test extends Shell {", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new GridLayout(1, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button #1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button #2');", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "      button_3.setText('Button #3');", "    }", "  }", "}");
        this.canvas.select(this.composite);
        List rows = this.layout.getRows();
        GridRowInfo sourceRow = (GridRowInfo)rows.get(0);
        GridRowInfo relativeRow = (GridRowInfo)rows.get(2);
        this.verticalRobot.beginDrag(sourceRow).dragTo((Object)relativeRow, 0.5, -1.0);
        this.verticalRobot.assertCommandNotNull();
        this.verticalRobot.endDrag();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new GridLayout(1, false));", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button #2');", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "      button_3.setText('Button #3');", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button #1');", "    }", "  }", "}");
    }

    private void openPanel(String ... lines) throws Exception {
        this.composite = this.openComposite(lines);
        if (this.composite.getLayout() instanceof GridLayoutInfo) {
            this.layout = (GridLayoutInfo)this.composite.getLayout();
        }
        this.horizontalRobot = new GraphicalRobot(this.m_headerHorizontal);
        this.verticalRobot = new GraphicalRobot(this.m_headerVertical);
    }
}

