/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts.grid;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class GridLayoutConverterTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_empty() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        this.setGridLayout(shell, new String[]{"// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "  }", "}"}, new Rectangle[0]);
    }

    @Test
    public void test_singleColumn_normalOrder() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Button button_0 = new Button(this, SWT.NONE);", "      button_0.setBounds(10, 10, 100, 20);", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setBounds(20, 40, 100, 20);", "    }", "  }", "}");
        this.setGridLayout(shell, new String[]{"public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button_0 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "  }", "}"}, new Rectangle[]{new Rectangle(0, 0, 1, 1), new Rectangle(0, 1, 1, 1)});
    }

    @Test
    public void test_noReorderIfRightOrder() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Button button_0 = new Button(this, SWT.NONE);", "      button_0.setBounds(10, 10, 100, 20);", "    }", "    int marker;", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setBounds(10, 50, 100, 20);", "    }", "  }", "}");
        this.setGridLayout(shell, new String[]{"public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button_0 = new Button(this, SWT.NONE);", "    }", "    int marker;", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "  }", "}"});
    }

    @Test
    public void test_singleColumn_reverseOrder() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setBounds(20, 40, 100, 20);", "    }", "    {", "      Button button_0 = new Button(this, SWT.NONE);", "      button_0.setBounds(10, 10, 100, 20);", "    }", "  }", "}");
        this.setGridLayout(shell, new String[]{"public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button_0 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "  }", "}"}, new Rectangle[]{new Rectangle(0, 0, 1, 1), new Rectangle(0, 1, 1, 1)});
    }

    @Test
    public void test_twoRows_noFillers() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Button button_0 = new Button(this, SWT.NONE);", "      button_0.setBounds(10, 10, 100, 20);", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setBounds(120, 15, 100, 20);", "    }", "  }", "}");
        this.setGridLayout(shell, new String[]{"public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_0 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "  }", "}"}, new Rectangle[]{new Rectangle(0, 0, 1, 1), new Rectangle(1, 0, 1, 1)});
    }

    @Test
    public void test_twoRows_withFillers() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Button button_0 = new Button(this, SWT.NONE);", "      button_0.setBounds(10, 10, 100, 20);", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setBounds(120, 40, 100, 20);", "    }", "  }", "}");
        this.setGridLayout(shell, new String[]{"public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_0 = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "  }", "}"}, new Rectangle[]{new Rectangle(0, 0, 1, 1), new Rectangle(1, 1, 1, 1)});
    }

    @Test
    public void test_spanHorizontal() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Button button_0 = new Button(this, SWT.NONE);", "      button_0.setBounds(10, 10, 10, 10);", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setBounds(30, 10, 10, 10);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setBounds(10, 30, 30, 10);", "    }", "  }", "}");
        this.setGridLayout(shell, new String[]{"public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_0 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 2, 1));", "    }", "  }", "}"}, new Rectangle[]{new Rectangle(0, 0, 1, 1), new Rectangle(1, 0, 1, 1), new Rectangle(0, 1, 2, 1)});
    }

    @Test
    public void test_spanVertical() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Button button_0 = new Button(this, SWT.NONE);", "      button_0.setBounds(10, 10, 10, 10);", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setBounds(30, 10, 10, 30);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setBounds(10, 30, 10, 10);", "    }", "  }", "}");
        this.setGridLayout(shell, new String[]{"public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_0 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 2));", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}"}, new Rectangle[]{new Rectangle(0, 0, 1, 1), new Rectangle(1, 0, 1, 2), new Rectangle(0, 1, 1, 1)});
    }

    private void setGridLayout(CompositeInfo composite, String[] expectedLines, Rectangle[] cells) throws Exception {
        GridLayoutInfo layout = this.setGridLayout(composite, expectedLines);
        int cellIndex = 0;
        for (ControlInfo control : composite.getChildrenControls()) {
            if (layout.isFiller(control)) continue;
            GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)control);
            GridLayoutConverterTest.assertEquals((Object)cells[cellIndex++], (Object)new Rectangle(ReflectionUtils.getFieldInt((Object)gridData, (String)"x"), ReflectionUtils.getFieldInt((Object)gridData, (String)"y"), ReflectionUtils.getFieldInt((Object)gridData, (String)"width"), ReflectionUtils.getFieldInt((Object)gridData, (String)"height")));
        }
    }

    private GridLayoutInfo setGridLayout(CompositeInfo composite, String[] expectedLines) throws Exception {
        composite.getRoot().refresh();
        GridLayoutInfo gridLayout = (GridLayoutInfo)GridLayoutConverterTest.createJavaInfo("org.eclipse.swt.layout.GridLayout");
        composite.setLayout((LayoutInfo)gridLayout);
        this.assertEditor(expectedLines);
        return gridLayout;
    }
}

