/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gbl;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.Activator;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagLayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.gbl.AbstractGridBagLayoutTest;
import org.junit.After;
import org.junit.Test;

public class GridBagLayoutParametersTest
extends AbstractGridBagLayoutTest {
    @Override
    @After
    public void tearDown() throws Exception {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        preferences.setToDefault("GridBagLayout.enableGrab");
        preferences.setToDefault("GridBagLayout.enableRightAlignment");
        super.tearDown();
    }

    @Test
    public void test_CREATE_Text() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = GridBagLayoutParametersTest.createComponent(JTextField.class);
                layout.command_CREATE(newComponent, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {1.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JTextField textField = new JTextField();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.fill = GridBagConstraints.HORIZONTAL;", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(textField, gbc);", "      textField.setColumns(10);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_Text_disabled() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "  }", "}");
        panel.refresh();
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("GridBagLayout.enableGrab", false);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = GridBagLayoutParametersTest.createComponent(JTextField.class);
                layout.command_CREATE(newComponent, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JTextField textField = new JTextField();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(textField, gbc);", "      textField.setColumns(10);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_Table() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = GridBagLayoutParametersTest.createComponent(JTable.class);
                layout.command_CREATE(newComponent, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {1.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {1.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JTable table = new JTable();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.fill = GridBagConstraints.BOTH;", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(table, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_LabelBeforeText() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, 1.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JTextField textField = new JTextField();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.fill = GridBagConstraints.HORIZONTAL;", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(textField, gbc);", "    }", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = GridBagLayoutParametersTest.createComponent(JLabel.class);
                layout.command_CREATE(newComponent, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, 1.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JLabel label = new JLabel('New label');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.anchor = GridBagConstraints.EAST;", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(label, gbc);", "    }", "    {", "      JTextField textField = new JTextField();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.fill = GridBagConstraints.HORIZONTAL;", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(textField, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_TextAfterLabel() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JLabel label = new JLabel('New label');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(label, gbc);", "    }", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = GridBagLayoutParametersTest.createComponent(JTextField.class);
                layout.command_CREATE(newComponent, 1, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, 1.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JLabel label = new JLabel('New label');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.anchor = GridBagConstraints.EAST;", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(label, gbc);", "    }", "    {", "      JTextField textField = new JTextField();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.fill = GridBagConstraints.HORIZONTAL;", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(textField, gbc);", "      textField.setColumns(10);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_LabelBeforeText_disabled() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, 1.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JTextField textField = new JTextField();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.fill = GridBagConstraints.HORIZONTAL;", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(textField, gbc);", "    }", "  }", "}");
        panel.refresh();
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("GridBagLayout.enableRightAlignment", false);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = GridBagLayoutParametersTest.createComponent(JLabel.class);
                layout.command_CREATE(newComponent, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, 1.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JLabel label = new JLabel('New label');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(label, gbc);", "    }", "    {", "      JTextField textField = new JTextField();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.fill = GridBagConstraints.HORIZONTAL;", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(textField, gbc);", "    }", "  }", "}");
    }
}

