/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.string.StringPropertyEditor;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.exception.MultipleConstructorsError;
import org.eclipse.wb.internal.core.utils.exception.NoEntryPointError;
import org.eclipse.wb.internal.rcp.model.widgets.TabFolderInfo;
import org.eclipse.wb.internal.rcp.model.widgets.TabItemInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.Expectations;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public class ControlTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        Assume.assumeTrue((boolean)EnvironmentUtils.IS_WINDOWS);
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(450, 300);", "    Button button = new Button(this, SWT.NONE);", "    button.setBounds(10, 20, 50, 30);", "    button.setText('button');", "  }", "}");
        List children = shell.getChildrenControls();
        ControlTest.assertEquals((long)1L, (long)children.size());
        ControlInfo buttonInfo = (ControlInfo)children.get(0);
        Property buttonProperty = buttonInfo.getPropertyByTitle("text");
        ControlTest.assertNotNull((Object)buttonProperty);
        ControlTest.assertEquals((Object)"button", (Object)buttonProperty.getValue());
        ControlTest.assertTrue((boolean)(buttonProperty.getEditor() instanceof StringPropertyEditor));
        shell.refresh();
        ControlTest.assertNotNull((Object)shell.getImage());
        ControlTest.assertEquals((Object)new org.eclipse.swt.graphics.Rectangle(0, 0, 450, 300), (Object)shell.getImage().getBounds());
    }

    @Test
    public void test_parse_unknownSuperClassForAnonymous() throws Exception {
        this.m_ignoreCompilationProblems = true;
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    new UnknownType() {};", "  }", "}");
        shell.refresh();
        ControlTest.assertNoErrors((JavaInfo)shell);
    }

    @DisposeProjectAfter
    @Test
    public void test_parse_notConfiguredForSWT() throws Exception {
        ControlTest.do_projectDispose();
        ControlTest.do_projectCreate();
        this.m_ignoreCompilationProblems = true;
        try {
            this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
            ControlTest.fail();
        }
        catch (Throwable e) {
            DesignerException de = DesignerExceptionUtils.getDesignerException((Throwable)e);
            ControlTest.assertEquals((long)3005L, (long)de.getCode());
            ControlTest.assertTrue((boolean)DesignerExceptionUtils.isWarning((Throwable)e));
        }
    }

    @Test
    public void test_severalConstructors_useDefault_forComposite() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "  public Test(Composite parent, int style, boolean a) {", "    super(parent, style);", "  }", "}");
        composite.refresh();
        ControlTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_severalConstructors_useDefault_forShell() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Shell {", "  public Test() {", "  }", "  public Test(Shell parent) {", "    super(parent);", "  }", "}");
        composite.refresh();
        ControlTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_severalConstructors_noDefault() throws Exception {
        try {
            this.parseComposite("public class Test extends Composite{", "  public Test(Composite parent, int style, boolean a) {", "    super(parent, style);", "  }", "  public Test(Composite parent, int style, int b) {", "    super(parent, style);", "  }", "}");
            ControlTest.fail();
        }
        catch (MultipleConstructorsError e) {
            ControlTest.assertNotNull((Object)e.getEditor());
            ControlTest.assertNotNull((Object)e.getTypeDeclaration());
        }
    }

    @Test
    public void test_entryPointTag() throws Exception {
        ControlTest.useStrictEvaluationMode(false);
        CompositeInfo shell = this.parseComposite("public class Test {", "  /**", "  * @wbp.parser.entryPoint", "  */", "  public Test(Shell parent) {", "    Shell shell = new Shell(parent);", "  }", "}");
        ControlTest.assertHierarchy("{new: org.eclipse.swt.widgets.Shell} {local-unique: shell} {/new Shell(parent)/}", "  {implicit-layout: absolute} {implicit-layout} {}");
        shell.refresh();
        ControlTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_alwaysTryConstructor_success() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  public Test() {", "    Shell shell = new Shell();", "  }", "}");
        ControlTest.assertHierarchy("{new: org.eclipse.swt.widgets.Shell} {local-unique: shell} {/new Shell()/}", "  {implicit-layout: absolute} {implicit-layout} {}");
        shell.refresh();
        ControlTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_alwaysTryConstructor_fail() throws Exception {
        try {
            this.parseComposite("public class Test {", "  Shell shell; // just to have reference on RCP", "  public Test() {", "  }", "}");
            ControlTest.fail();
        }
        catch (Throwable e_) {
            Throwable e = DesignerExceptionUtils.getRootCause((Throwable)e_);
            Assertions.assertThat((Throwable)e).isExactlyInstanceOf(NoEntryPointError.class);
        }
    }

    @Test
    public void test_constructor_withShellParameter_asSecondArgument() throws Exception {
        ControlTest.useStrictEvaluationMode(false);
        CompositeInfo shell = this.parseComposite("public class Test {", "  public Test(Object filler, Shell parent) {", "    Shell shell = new Shell(parent, SWT.SHELL_TRIM);", "  }", "}");
        ControlTest.assertHierarchy("{new: org.eclipse.swt.widgets.Shell} {local-unique: shell} {/new Shell(parent, SWT.SHELL_TRIM)/}", "  {implicit-layout: absolute} {implicit-layout} {}");
        shell.refresh();
        ControlTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_parse_Realm_runWithDefault() throws Exception {
        try {
            m_testProject.addPlugin("org.eclipse.core.databinding.observable");
            m_testProject.addPlugin("org.eclipse.jface.databinding");
            CompositeInfo shell = this.parseComposite("import org.eclipse.core.databinding.observable.Realm;", "import org.eclipse.jface.databinding.swt.DisplayRealm;", "public class Test {", "  public static void main(String[] args) {", "    Display display = Display.getDefault();", "    Realm.runWithDefault(DisplayRealm.getRealm(display), new Runnable() {", "      public void run() {", "        Test window = new Test();", "      }", "    });", "  }", "  public Test() {", "    Shell shell = new Shell();", "  }", "}");
            ControlTest.assertHierarchy("{new: org.eclipse.swt.widgets.Shell} {local-unique: shell} {/new Shell()/}", "  {implicit-layout: absolute} {implicit-layout} {}");
            shell.refresh();
            ControlTest.assertNoErrors((JavaInfo)shell);
        }
        finally {
            ControlTest.do_projectDispose();
        }
    }

    @Test
    public void test_parseSeparate_ClassInstanceCreation() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    new Button(this, SWT.NONE);", "  }", "}");
        ControlTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new Button(this, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: org.eclipse.swt.widgets.Button} {empty} {/new Button(this, SWT.NONE)/}");
        shell.refresh();
        ControlTest.assertNoErrors((JavaInfo)shell);
    }

    @Ignore
    @Test
    public void test_insetsWithGroup() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    Group group = new Group(this, SWT.NONE);", "    group.setBounds(0, 0, 200, 200);", "  }", "}");
        shell.refresh();
        Insets expected = Expectations.get(new Insets(30, 8, 8, 8), new Expectations.InsValue("flanker-windows", new Insets(30, 8, 8, 8)), new Expectations.InsValue("scheglov-win", new Insets(30, 8, 8, 8)));
        ControlTest.assertEquals((Object)expected, (Object)shell.getClientAreaInsets());
        ControlTest.assertEquals((Object)new Insets(0, 0, 0, 0), (Object)shell.getClientAreaInsets2());
        CompositeInfo group = (CompositeInfo)shell.getChildrenControls().get(0);
        ControlTest.assertEquals((Object)new Insets(0, 0, 0, 0), (Object)group.getClientAreaInsets());
        Insets expected2 = Expectations.get(new Insets(15, 3, 3, 3), new Expectations.InsValue("flanker-windows", new Insets(15, 3, 3, 3)), new Expectations.InsValue("scheglov-win", new Insets(15, 3, 3, 3)));
        ControlTest.assertEquals((Object)expected2, (Object)group.getClientAreaInsets2());
    }

    @Test
    public void test_visualInheritance_withOverride() throws Exception {
        ControlTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    init();", "  }", "  protected void init() {", "    setLayout(new FillLayout());", "  }", "}"));
        ControlTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends MyComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "  protected void init() {", "    super.init();", "  }", "}");
        ControlTest.assertHierarchy("{this: test.MyComposite} {this} {}", "  {implicit-layout: org.eclipse.swt.layout.FillLayout} {implicit-layout} {}");
        composite.refresh();
        ControlTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_properties_defaultValues() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ControlTest.assertEquals((Object)Boolean.FALSE, (Object)shell.getPropertyByTitle("capture").getValue());
        ControlTest.assertEquals((Object)Boolean.TRUE, (Object)shell.getPropertyByTitle("redraw").getValue());
    }

    @Test
    public void test_properties_setSize() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(new Point(399, 299));", "  }", "}");
        shell.refresh();
        ControlTest.assertEquals((Object)new Dimension(399, 299), (Object)shell.getBounds().getSize());
        ControlTest.assertEquals((Object)new Point(399, 299), (Object)shell.getWidget().getSize());
        Property sizeProperty = shell.getPropertyByTitle("size");
        ControlTest.assertEquals((Object)new Point(399, 299), (Object)sizeProperty.getValue());
        sizeProperty.setValue((Object)new Point(500, 300));
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setSize(new Point(500, 300));", "  }", "}");
    }

    @Test
    public void test_setIME_property() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        Property property = shell.getPropertyByTitle("IME");
        ControlTest.assertNull((Object)property);
    }

    @Test
    public void test_swingForm_InRCPproject() throws Exception {
        ContainerInfo panel = (ContainerInfo)this.parseJavaInfo("import javax.swing.*;", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ControlTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_swingClass_InRCPform() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private final javax.swing.JButton button = null;", "  public Test() {", "  }", "}");
        shell.refresh();
        ControlTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_swingNVO_inRCP() throws Exception {
        this.parseComposite("import javax.swing.*;", "public class Test extends Shell {", "  /**", "  * @wbp.nonvisual location=0,0", "  */", "  private final JPanel panel = new JPanel();", "  public Test() {", "    panel.add(new JButton());", "  }", "}");
        ControlTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {NonVisualBeans}", "    {new: javax.swing.JPanel} {field-initializer: panel} {/new JPanel()/ /panel.add(new JButton())/}", "      {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "      {new: javax.swing.JButton} {empty} {/panel.add(new JButton())/}");
    }

    @Test
    public void test_swingClass_InRCP_mainMethod() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  private final javax.swing.JButton button = null;", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "  }", "}");
        shell.refresh();
        ControlTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_BeanInfo_icon() throws Exception {
        ControlTest.setFileContentSrc("test/MyShell.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyShell extends Shell {", "}"));
        ControlTest.setFileContentSrc("test/MyShellBeanInfo.java", ControlTest.getSourceDQ("package test;", "import java.awt.Image;", "import java.awt.image.BufferedImage;", "public class MyShellBeanInfo extends java.beans.SimpleBeanInfo {", "  public Image getIcon(int iconKind) {", "    return new BufferedImage(10, 15, BufferedImage.TYPE_INT_RGB);", "  }", "}"));
        ControlTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends MyShell {", "  public Test() {", "  }", "}");
        ComponentDescription description = shell.getDescription();
        ControlTest.assertNotNull((Object)description.getBeanInfo());
        ImageDescriptor icon = description.getIcon();
        ControlTest.assertEquals((long)10L, (long)icon.getImageData((int)100).width);
        ControlTest.assertEquals((long)15L, (long)icon.getImageData((int)100).height);
    }

    @Test
    public void test_inAbsoluteLayout_realLayout() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Composite composite_1 = new Composite(this, SWT.NONE);", "      composite_1.setBounds(10, 10, 200, 150);", "      composite_1.setLayout(new FillLayout());", "      {", "        Composite composite_2 = new Composite(composite_1, SWT.NONE);", "        composite_2.setLayout(new RowLayout());", "        {", "          new Button(composite_2, SWT.NONE);", "        }", "      }", "    }", "  }", "}");
        ControlTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new Composite(this, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: org.eclipse.swt.widgets.Composite} {local-unique: composite_1} {/new Composite(this, SWT.NONE)/ /composite_1.setBounds(10, 10, 200, 150)/ /composite_1.setLayout(new FillLayout())/ /new Composite(composite_1, SWT.NONE)/}", "    {new: org.eclipse.swt.layout.FillLayout} {empty} {/composite_1.setLayout(new FillLayout())/}", "    {new: org.eclipse.swt.widgets.Composite} {local-unique: composite_2} {/new Composite(composite_1, SWT.NONE)/ /composite_2.setLayout(new RowLayout())/ /new Button(composite_2, SWT.NONE)/}", "      {new: org.eclipse.swt.layout.RowLayout} {empty} {/composite_2.setLayout(new RowLayout())/}", "      {new: org.eclipse.swt.widgets.Button} {empty} {/new Button(composite_2, SWT.NONE)/}", "        {virtual-layout_data: org.eclipse.swt.layout.RowData} {virtual-layout-data} {}");
        shell.refresh();
        CompositeInfo composite_1 = (CompositeInfo)shell.getChildrenControls().get(0);
        CompositeInfo composite_2 = (CompositeInfo)composite_1.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)composite_2.getChildrenControls().get(0);
        ControlTest.assertFalse((boolean)button.getBounds().isEmpty());
    }

    @Test
    public void test_inAbsoluteLayout_tabFolder() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "      tabFolder.setBounds(10, 10, 200, 150);", "      TabItem tabItem = new TabItem(tabFolder, SWT.NONE);", "      {", "        Composite composite = new Composite(tabFolder, SWT.NONE);", "        tabItem.setControl(composite);", "        composite.setLayout(new FillLayout());", "        {", "          new Button(composite, SWT.NONE);", "        }", "      }", "    }", "  }", "}");
        ControlTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new TabFolder(this, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: org.eclipse.swt.widgets.TabFolder} {local-unique: tabFolder} {/new TabFolder(this, SWT.NONE)/ /tabFolder.setBounds(10, 10, 200, 150)/ /new TabItem(tabFolder, SWT.NONE)/ /new Composite(tabFolder, SWT.NONE)/}", "    {new: org.eclipse.swt.widgets.TabItem} {local-unique: tabItem} {/new TabItem(tabFolder, SWT.NONE)/ /tabItem.setControl(composite)/}", "    {new: org.eclipse.swt.widgets.Composite} {local-unique: composite} {/new Composite(tabFolder, SWT.NONE)/ /tabItem.setControl(composite)/ /composite.setLayout(new FillLayout())/ /new Button(composite, SWT.NONE)/}", "      {new: org.eclipse.swt.layout.FillLayout} {empty} {/composite.setLayout(new FillLayout())/}", "      {new: org.eclipse.swt.widgets.Button} {empty} {/new Button(composite, SWT.NONE)/}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        TabItemInfo tabItem = (TabItemInfo)tabFolder.getItems2().get(0);
        CompositeInfo composite = (CompositeInfo)tabItem.getControl();
        ControlTest.assertFalse((boolean)composite.getBounds().isEmpty());
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        ControlTest.assertFalse((boolean)button.getBounds().isEmpty());
    }

    @Ignore
    @Test
    public void test_RTL() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent) {", "    super(parent, SWT.RIGHT_TO_LEFT);", "    setLayout(new RowLayout());", "    Button button_1 = new Button(this, SWT.NONE);", "    Button button_2 = new Button(this, SWT.NONE);", "  }", "}");
        ControlTest.assertHierarchy("{this: org.eclipse.swt.widgets.Composite} {this} {/setLayout(new RowLayout())/ /new Button(this, SWT.NONE)/ /new Button(this, SWT.NONE)/}", "  {new: org.eclipse.swt.layout.RowLayout} {empty} {/setLayout(new RowLayout())/}", "  {new: org.eclipse.swt.widgets.Button} {local-unique: button_1} {/new Button(this, SWT.NONE)/}", "    {virtual-layout_data: org.eclipse.swt.layout.RowData} {virtual-layout-data} {}", "  {new: org.eclipse.swt.widgets.Button} {local-unique: button_2} {/new Button(this, SWT.NONE)/}", "    {virtual-layout_data: org.eclipse.swt.layout.RowData} {virtual-layout-data} {}");
        composite.refresh();
        ControlTest.assertTrue((boolean)composite.isRTL());
        ControlTest.assertEquals((Object)new Insets(0, 0, 0, 0), (Object)composite.getClientAreaInsets());
        int m = 3;
        int s = 3;
        int w = 12;
        int h = Expectations.get(Integer.valueOf(25), new Expectations.IntValue("scheglov-win", 25), new Expectations.IntValue("Flanker-Windows", 25), new Expectations.IntValue("sablin-aa", 25));
        ControlInfo button_1 = (ControlInfo)ControlTest.getJavaInfoByName("button_1");
        ControlTest.assertEquals((Object)new Rectangle(m, m, w, h), (Object)button_1.getModelBounds());
        ControlTest.assertEquals((Object)new Rectangle(450 - w - m, m, w, h), (Object)button_1.getBounds());
        ControlInfo button_2 = (ControlInfo)ControlTest.getJavaInfoByName("button_2");
        ControlTest.assertEquals((Object)new Rectangle(m + w + s, m, w, h), (Object)button_2.getModelBounds());
        ControlTest.assertEquals((Object)new Rectangle(450 - w - m - s - w, m, w, h), (Object)button_2.getBounds());
    }

    @Ignore
    @Test
    public void test_RTL_withInnerComposite() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent) {", "    super(parent, SWT.RIGHT_TO_LEFT);", "    setLayout(new FillLayout());", "    {", "      Composite inner = new Composite(this, SWT.RIGHT_TO_LEFT);", "      inner.setLayout(new RowLayout());", "      Button button = new Button(inner, SWT.NONE);", "    }", "  }", "}");
        ControlTest.assertHierarchy("{this: org.eclipse.swt.widgets.Composite} {this} {/setLayout(new FillLayout())/ /new Composite(this, SWT.RIGHT_TO_LEFT)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {new: org.eclipse.swt.widgets.Composite} {local-unique: inner} {/new Composite(this, SWT.RIGHT_TO_LEFT)/ /inner.setLayout(new RowLayout())/ /new Button(inner, SWT.NONE)/}", "    {new: org.eclipse.swt.layout.RowLayout} {empty} {/inner.setLayout(new RowLayout())/}", "    {new: org.eclipse.swt.widgets.Button} {local-unique: button} {/new Button(inner, SWT.NONE)/}", "      {virtual-layout_data: org.eclipse.swt.layout.RowData} {virtual-layout-data} {}");
        composite.refresh();
        ControlTest.assertTrue((boolean)composite.isRTL());
        ControlTest.assertEquals((Object)new Insets(0, 0, 0, 0), (Object)composite.getClientAreaInsets());
        CompositeInfo inner = (CompositeInfo)ControlTest.getJavaInfoByName("inner");
        ControlTest.assertTrue((boolean)inner.isRTL());
        ControlTest.assertEquals((Object)new Insets(0, 0, 0, 0), (Object)inner.getClientAreaInsets());
        ControlTest.assertEquals((Object)new Rectangle(0, 0, 450, 300), (Object)inner.getModelBounds());
        ControlTest.assertEquals((Object)new Rectangle(0, 0, 450, 300), (Object)inner.getBounds());
        int m = 3;
        int w = 12;
        int h = Expectations.get(Integer.valueOf(25), new Expectations.IntValue("scheglov_win", 25), new Expectations.IntValue("Flanker-Windows", 25), new Expectations.IntValue("sablin-aa", 25));
        ControlInfo button = (ControlInfo)ControlTest.getJavaInfoByName("button");
        ControlTest.assertEquals((Object)new Rectangle(m, m, w, h), (Object)button.getModelBounds());
        ControlTest.assertEquals((Object)new Rectangle(450 - w - m, m, w, h), (Object)button.getBounds());
    }

    @Test
    public void test_newAnonymousControl() throws Exception {
        ControlTest.setFileContentSrc("test/MyAbstractButton.java", this.getTestSource("public class MyAbstractButton extends Button {", "  public MyAbstractButton(Composite parent, int style) {", "    super(parent, style);", "  }", "  protected void checkSubclass() {", "  }", "}"));
        ControlTest.waitForAutoBuild();
        ControlTest.useStrictEvaluationMode(false);
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    new MyAbstractButton(this, SWT.NONE) {};", "  }", "}");
        ControlTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new MyAbstractButton(this, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: test.MyAbstractButton} {empty} {/new MyAbstractButton(this, SWT.NONE)/}");
        shell.refresh();
        ControlTest.assertNoErrors((JavaInfo)shell);
    }
}

