/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.forms;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryInfo;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.rcp.model.forms.FormToolkitAccess;
import org.eclipse.wb.internal.rcp.model.forms.FormToolkitCreationSupport;
import org.eclipse.wb.internal.rcp.model.forms.FormToolkitVariableSupport;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.rcp.model.forms.AbstractFormsTest;
import org.junit.Test;

public class FormToolkitAccessTest
extends AbstractFormsTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_invalid() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import org.eclipse.ui.forms.*;\nimport org.eclipse.ui.forms.widgets.*;\npublic class Test {\n}");
        FormToolkitAccessTest.assertSame(null, (Object)FormToolkitAccess.get((TypeDeclaration)typeDeclaration));
        try {
            FormToolkitAccess.getOrFail((TypeDeclaration)typeDeclaration);
            FormToolkitAccessTest.fail();
        }
        catch (DesignerException e) {
            FormToolkitAccessTest.assertEquals((long)3000L, (long)e.getCode());
        }
    }

    @Test
    public void test_toolkitMethod_public() throws Exception {
        FormToolkitAccessTest.setFileContentSrc("test/MyForm.java", FormToolkitAccessTest.getSource("package test;", "import org.eclipse.ui.forms.*;", "import org.eclipse.ui.forms.widgets.*;", "public class MyForm {", "  public FormToolkit getPublicToolkit() {", "    return null;", "  }", "}"));
        FormToolkitAccessTest.waitForAutoBuild();
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", FormToolkitAccessTest.getSource("package test;", "import org.eclipse.ui.forms.*;", "import org.eclipse.ui.forms.widgets.*;", "public class Test extends MyForm {", "  public void isToolkit_1() {", "    int a;", "  }", "  public void isToolkit_2() {", "    System.out.println();", "  }", "  public void isToolkit_3() {", "    getPublicToolkit();", "  }", "}"));
        FormToolkitAccess toolkitAccess = FormToolkitAccess.getOrFail((TypeDeclaration)typeDeclaration);
        FormToolkitAccessTest.assertEquals((Object)"getPublicToolkit()", (Object)toolkitAccess.getReferenceExpression());
        FormToolkitAccessTest.assertToolkitNode(false, toolkitAccess, typeDeclaration, "isToolkit_1");
        FormToolkitAccessTest.assertToolkitNode(false, toolkitAccess, typeDeclaration, "isToolkit_2");
        FormToolkitAccessTest.assertToolkitNode(true, toolkitAccess, typeDeclaration, "isToolkit_3");
    }

    @Test
    public void test_toolkitMethod_protected() throws Exception {
        FormToolkitAccessTest.setFileContentSrc("test/MyForm.java", FormToolkitAccessTest.getSource("package test;", "import org.eclipse.ui.forms.*;", "import org.eclipse.ui.forms.widgets.*;", "public class MyForm {", "  public FormToolkit getProtectedToolkit() {", "    return null;", "  }", "}"));
        FormToolkitAccessTest.waitForAutoBuild();
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", FormToolkitAccessTest.getSource("package test;", "import org.eclipse.ui.forms.*;", "import org.eclipse.ui.forms.widgets.*;", "public class Test extends MyForm {", "}"));
        FormToolkitAccess toolkitAccess = FormToolkitAccess.getOrFail((TypeDeclaration)typeDeclaration);
        FormToolkitAccessTest.assertEquals((Object)"getProtectedToolkit()", (Object)toolkitAccess.getReferenceExpression());
    }

    @Test
    public void test_toolkitField() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import org.eclipse.ui.forms.*;\nimport org.eclipse.ui.forms.widgets.*;\npublic class Test {\n\tprivate FormToolkit m_toolkit;\n\t//\n\tprivate int field;\n\tpublic void isToolkit_1() {\n\t\tint a;\n\t}\n\tpublic int isToolkit_2() {\n\t\treturn field;\n\t}\n\tpublic Object isToolkit_3() {\n\t\treturn m_toolkit;\n\t}\n}");
        FormToolkitAccess toolkitAccess = FormToolkitAccess.getOrFail((TypeDeclaration)typeDeclaration);
        FormToolkitAccessTest.assertEquals((Object)"m_toolkit", (Object)toolkitAccess.getReferenceExpression());
        FormToolkitAccessTest.assertToolkitNode(false, toolkitAccess, typeDeclaration, "isToolkit_1");
        FormToolkitAccessTest.assertToolkitNode(false, toolkitAccess, typeDeclaration, "isToolkit_2");
        FormToolkitAccessTest.assertToolkitNode(true, toolkitAccess, typeDeclaration, "isToolkit_3");
    }

    @Test
    public void test_toolkitLocal() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import org.eclipse.ui.forms.*;\nimport org.eclipse.ui.forms.widgets.*;\nimport org.eclipse.swt.widgets.*;\npublic class Test {\n\tpublic void createMasterPart(int a, double b) {\n\t\tSystem.out.println(1);\n\t\tFormToolkit toolkit = new FormToolkit((Display) null);\n\t\tSystem.out.println(2);\n\t\tSystem.out.println(toolkit);\n\t}\n\tpublic void foo() {\n\t\tSystem.out.println(3);\n\t}\n}");
        FormToolkitAccess toolkitAccess = FormToolkitAccess.getOrFail((TypeDeclaration)typeDeclaration);
        FormToolkitAccessTest.assertEquals((Object)"toolkit", (Object)toolkitAccess.getReferenceExpression());
        ASTNode node = this.m_lastEditor.getEnclosingNode("toolkit)");
        FormToolkitAccessTest.assertTrue((boolean)toolkitAccess.isToolkit(node));
        node = this.m_lastEditor.getEnclosingNode("3)");
        FormToolkitAccessTest.assertFalse((boolean)toolkitAccess.isToolkit(node));
    }

    @Test
    public void test_formMethod() throws Exception {
        FormToolkitAccessTest.setFileContentSrc("test/MyForm.java", FormToolkitAccessTest.getSource("package test;", "import org.eclipse.ui.forms.*;", "import org.eclipse.ui.forms.widgets.*;", "public class MyForm {", "  public IManagedForm getMyForm() {", "    return null;", "  }", "}"));
        FormToolkitAccessTest.waitForAutoBuild();
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import org.eclipse.ui.forms.*;\nimport org.eclipse.ui.forms.widgets.*;\npublic class Test extends MyForm {\n\tpublic void isToolkit_1() {\n\t\tint a;\n\t}\n\tpublic void isToolkit_2() {\n\t\tSystem.out.println();\n\t}\n\tpublic void isToolkit_3() {\n\t\tgetMyForm().getToolkit();\n\t}\n}");
        FormToolkitAccess toolkitAccess = FormToolkitAccess.getOrFail((TypeDeclaration)typeDeclaration);
        FormToolkitAccessTest.assertEquals((Object)"getMyForm().getToolkit()", (Object)toolkitAccess.getReferenceExpression());
        FormToolkitAccessTest.assertToolkitNode(false, toolkitAccess, typeDeclaration, "isToolkit_1");
        FormToolkitAccessTest.assertToolkitNode(false, toolkitAccess, typeDeclaration, "isToolkit_2");
        FormToolkitAccessTest.assertToolkitNode(true, toolkitAccess, typeDeclaration, "isToolkit_3");
    }

    @Test
    public void test_formField() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import org.eclipse.ui.forms.*;\nimport org.eclipse.ui.forms.widgets.*;\npublic class Test {\n\tprivate IManagedForm m_form;\n\t//\n\tprivate int field;\n\tpublic void isToolkit_1() {\n\t\tint a;\n\t}\n\tpublic int isToolkit_2() {\n\t\treturn field;\n\t}\n\tpublic Object isToolkit_3() {\n\t\treturn m_form.getToolkit();\n\t}\n}");
        FormToolkitAccess toolkitAccess = FormToolkitAccess.getOrFail((TypeDeclaration)typeDeclaration);
        FormToolkitAccessTest.assertEquals((Object)"m_form.getToolkit()", (Object)toolkitAccess.getReferenceExpression());
        FormToolkitAccessTest.assertToolkitNode(false, toolkitAccess, typeDeclaration, "isToolkit_1");
        FormToolkitAccessTest.assertToolkitNode(false, toolkitAccess, typeDeclaration, "isToolkit_2");
        FormToolkitAccessTest.assertToolkitNode(true, toolkitAccess, typeDeclaration, "isToolkit_3");
    }

    @Test
    public void test_formMethod_prefer_toolkitLocal() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import org.eclipse.swt.widgets.*;\nimport org.eclipse.ui.forms.*;\nimport org.eclipse.ui.forms.widgets.*;\npublic class Test {\n\tpublic void createMasterPart(int a, double b) {\n\t\tFormToolkit toolkit = new FormToolkit((Display) null);\n\t}\n\tpublic IManagedForm getMyForm() {\n\t\treturn null;\n\t}\n}");
        FormToolkitAccess toolkitAccess = FormToolkitAccess.getOrFail((TypeDeclaration)typeDeclaration);
        FormToolkitAccessTest.assertEquals((Object)"toolkit", (Object)toolkitAccess.getReferenceExpression());
    }

    private static void assertToolkitNode(boolean expectedResult, FormToolkitAccess toolkitAccess, TypeDeclaration typeDeclaration, String methodName) {
        MethodDeclaration methodDeclaration = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)(methodName + "()"));
        Statement statement = (Statement)DomGenerics.statements((Block)methodDeclaration.getBody()).get(0);
        Object node = statement instanceof ExpressionStatement ? ((ExpressionStatement)statement).getExpression() : (statement instanceof ReturnStatement ? ((ReturnStatement)statement).getExpression() : statement);
        FormToolkitAccessTest.assertEquals((Object)toolkitAccess.isToolkit((ASTNode)node), (Object)expectedResult);
    }

    @Test
    public void test_toolkitAccessSupports() throws Exception {
        FormToolkitAccessTest.setFileContentSrc("test/MyShell.java", this.getTestSource("public abstract class MyShell extends Shell {", "  protected IManagedForm m_managedForm;", "  public void initialize(IManagedForm form) {", "    m_managedForm = form;", "  }", "  public abstract void createContents(Composite parent);", "  protected void checkSubclass () {}", "}"));
        FormToolkitAccessTest.setFileContentSrc("test/MyShell.wbp-component.xml", FormToolkitAccessTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='FormToolkit.configureMethod'>createContents(org.eclipse.swt.widgets.Composite)</parameter>", "  </parameters>", "</component>"));
        FormToolkitAccessTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends MyShell {", "  public Test() {", "    createContents(this);", "  }", "  public void createContents(Composite parent) {", "  }", "  private void isToolkit_1() {", "    m_managedForm.getToolkit();", "  }", "}");
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration((JavaInfo)shell);
        FormToolkitAccess toolkitAccess = FormToolkitAccess.getOrFail((TypeDeclaration)typeDeclaration);
        FormToolkitCreationSupport creationSupport = new FormToolkitCreationSupport((JavaInfo)shell, toolkitAccess);
        InstanceFactoryInfo toolkit = InstanceFactoryInfo.createFactory((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("org.eclipse.ui.forms.widgets.FormToolkit"), (CreationSupport)creationSupport);
        FormToolkitVariableSupport variableSupport = new FormToolkitVariableSupport((JavaInfo)toolkit, (JavaInfo)shell, toolkitAccess);
        toolkit.setVariableSupport((VariableSupport)variableSupport);
        FormToolkitAccessTest.assertEquals((Object)"toolkitAccess: m_managedForm.getToolkit()", (Object)creationSupport.toString());
        FormToolkitAccessTest.assertSame((Object)shell.getCreationSupport().getNode(), (Object)creationSupport.getNode());
        FormToolkitAccessTest.assertFalse((boolean)creationSupport.isJavaInfo(null));
        MethodDeclaration methodDeclaration = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"isToolkit_1()");
        Statement statement = (Statement)DomGenerics.statements((Block)methodDeclaration.getBody()).get(0);
        Expression toolkitExpression = ((ExpressionStatement)statement).getExpression();
        FormToolkitAccessTest.assertTrue((boolean)creationSupport.isJavaInfo((ASTNode)toolkitExpression));
        FormToolkitAccessTest.assertFalse((boolean)creationSupport.canDelete());
        FormToolkitAccessTest.assertFalse((boolean)creationSupport.canReorder());
        FormToolkitAccessTest.assertFalse((boolean)creationSupport.canReparent());
        FormToolkitAccessTest.assertEquals((Object)"toolkitAccess", (Object)variableSupport.toString());
        FormToolkitAccessTest.assertEquals((Object)"FormToolkit instance", (Object)variableSupport.getTitle());
        NodeTarget nodeTarget = FormToolkitAccessTest.getNodeStatementTarget((JavaInfo)shell, false, 0);
        FormToolkitAccessTest.assertEquals((Object)"m_managedForm.getToolkit()", (Object)variableSupport.getReferenceExpression(nodeTarget));
        FormToolkitAccessTest.assertEquals((Object)"m_managedForm.getToolkit().", (Object)variableSupport.getAccessExpression(nodeTarget));
        MethodDeclaration expectedMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"createContents(org.eclipse.swt.widgets.Composite)");
        FormToolkitAccessTest.assertTarget(variableSupport.getStatementTarget(), expectedMethod.getBody(), null, true);
    }
}

