/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor.validator;

import org.eclipse.jface.action.IAction;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.Test;

public class BorderOfChildLayoutRequestValidatorTest
extends SwingGefTest {
    private ContainerInfo mainPanel;
    private ContainerInfo panel_1;
    private ComponentInfo button;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_CREATE_inside() throws Exception {
        this.prepare_CREATE();
        this.canvas.select(this.mainPanel);
        this.loadCreationTool("javax.swing.JButton", "empty");
        this.canvas.moveTo((Object)this.panel_1, 10, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout());\n\t\t{\n\t\t\tJPanel panel_1 = new JPanel();\n\t\t\tadd(panel_1);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tpanel_1.add(button);\n\t\t\t}\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_targetIsNotChildOfSelected_onBorder() throws Exception {
        this.prepare_CREATE();
        this.canvas.select(this.panel_1);
        this.loadCreationTool("javax.swing.JButton", "empty");
        this.canvas.moveTo((Object)this.panel_1, 10, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout());\n\t\t{\n\t\t\tJPanel panel_1 = new JPanel();\n\t\t\tadd(panel_1);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tpanel_1.add(button);\n\t\t\t}\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_targetIsChildOfSelected_onBorder() throws Exception {
        this.prepare_CREATE();
        this.canvas.select(this.mainPanel);
        this.loadCreationTool("javax.swing.JButton", "empty");
        this.canvas.moveTo((Object)this.panel_1, 1, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel panel_1 = new JPanel();\n\t\t\tadd(panel_1);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_targetMarkedAsTransparentOnBorders_noSelection_onBorder() throws Exception {
        this.prepare_CREATE();
        JavaInfoUtils.setParameter((JavaInfo)this.panel_1, (String)"GEF.transparentOnBorders.always", (String)"true");
        this.loadCreationTool("javax.swing.JButton", "empty");
        this.canvas.moveTo((Object)this.panel_1, 1, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel panel_1 = new JPanel();\n\t\t\tadd(panel_1);\n\t\t}\n\t}\n}");
    }

    private void prepare_CREATE() throws Exception {
        this.mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout());\n\t\t{\n\t\t\tJPanel panel_1 = new JPanel();\n\t\t\tadd(panel_1);\n\t\t}\n\t}\n}");
        this.panel_1 = (ContainerInfo)this.mainPanel.getChildrenComponents().get(0);
    }

    @Test
    public void test_PASTE_inside() throws Exception {
        this.prepare_PASTE();
        this.canvas.select(this.mainPanel);
        this.canvas.moveTo((Object)this.panel_1, 10, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout());\n\t\t{\n\t\t\tJPanel panel_1 = new JPanel();\n\t\t\tadd(panel_1);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tpanel_1.add(button);\n\t\t\t}\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_PASTE_targetIsNotChildOfSelected_onBorder() throws Exception {
        this.prepare_PASTE();
        this.canvas.select(this.panel_1);
        this.canvas.moveTo((Object)this.panel_1, 2, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout());\n\t\t{\n\t\t\tJPanel panel_1 = new JPanel();\n\t\t\tadd(panel_1);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tpanel_1.add(button);\n\t\t\t}\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_PASTE_targetIsChildOfSelected_onBorder() throws Exception {
        this.prepare_PASTE();
        this.canvas.select(this.mainPanel);
        this.canvas.moveTo((Object)this.panel_1, 2, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel panel_1 = new JPanel();\n\t\t\tadd(panel_1);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    private void prepare_PASTE() throws Exception {
        this.mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout());\n\t\t{\n\t\t\tJPanel panel_1 = new JPanel();\n\t\t\tadd(panel_1);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        this.panel_1 = (ContainerInfo)this.mainPanel.getChildrenComponents().get(0);
        this.button = (ComponentInfo)this.mainPanel.getChildrenComponents().get(1);
        this.canvas.select(this.button);
        IAction copyAction = this.getCopyAction();
        BorderOfChildLayoutRequestValidatorTest.assertTrue((boolean)copyAction.isEnabled());
        copyAction.run();
        IAction pasteAction = this.getPasteAction();
        BorderOfChildLayoutRequestValidatorTest.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
    }

    @Test
    public void test_ADD_inside() throws Exception {
        this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout());\n\t\t{\n\t\t\tJPanel panel_1 = new JPanel();\n\t\t\tadd(panel_1);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        this.panel_1 = (ContainerInfo)BorderOfChildLayoutRequestValidatorTest.getJavaInfoByName("panel_1");
        this.button = (ComponentInfo)BorderOfChildLayoutRequestValidatorTest.getJavaInfoByName("button");
        this.canvas.beginDrag(this.button, 10, 10).dragTo((Object)this.panel_1, 10, 10);
        this.canvas.assertEmptyFlowContainerFeedback(this.panel_1, true);
        this.canvas.assertCommandNotNull();
        this.canvas.endDrag();
        this.canvas.assertNoFeedbacks();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout());\n\t\t{\n\t\t\tJPanel panel_1 = new JPanel();\n\t\t\tadd(panel_1);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tpanel_1.add(button);\n\t\t\t}\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_ADD_onBorder() throws Exception {
        this.mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout());\n\t\t{\n\t\t\tJPanel panel_1 = new JPanel();\n\t\t\tadd(panel_1);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        this.panel_1 = (ContainerInfo)this.mainPanel.getChildrenComponents().get(0);
        this.button = (ComponentInfo)this.mainPanel.getChildrenComponents().get(1);
        this.canvas.beginDrag(this.button, 10, 10).dragTo((Object)this.panel_1, 1, 10);
        this.canvas.assertFeedbacks(this.canvas.getLinePredicate(this.panel_1, 1));
        this.canvas.assertCommandNotNull();
        this.canvas.endDrag();
        this.canvas.assertNoFeedbacks();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJPanel panel_1 = new JPanel();\n\t\t\tadd(panel_1);\n\t\t}\n\t}\n}");
    }
}

