/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.description;

import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.IDescriptionProcessor;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.Test;

public class DescriptionProcessorTest
extends DesignerTestCase {
    private static final String POINT_ID = "org.eclipse.wb.core.descriptionProcessors";

    @Test
    public void test_getDescriptionProcessors() throws Exception {
        DescriptionProcessorTest.assertNull((Object)this.getMyProcessor());
        DescriptionProcessorTest.addProcessorExtension(MyDescriptionProcessor.class.getName());
        try {
            IDescriptionProcessor myProcessor = this.getMyProcessor();
            DescriptionProcessorTest.assertNotNull((Object)myProcessor);
            DescriptionProcessorTest.assertEquals((long)0L, (long)MyDescriptionProcessor.m_processCount);
            myProcessor.process(null, null);
            DescriptionProcessorTest.assertEquals((long)1L, (long)MyDescriptionProcessor.m_processCount);
        }
        finally {
            DescriptionProcessorTest.removeProcessorExtension();
        }
        DescriptionProcessorTest.assertNull((Object)this.getMyProcessor());
    }

    private IDescriptionProcessor getMyProcessor() {
        String myProcessorName = MyDescriptionProcessor.class.getName();
        IDescriptionProcessor myProcessor = null;
        for (IDescriptionProcessor processor : ComponentDescriptionHelper.getDescriptionProcessors()) {
            if (!myProcessorName.equals(processor.getClass().getName())) continue;
            myProcessor = processor;
            break;
        }
        return myProcessor;
    }

    private static void addProcessorExtension(String className) throws Exception {
        String contribution = "  <processor class='" + className + "'/>";
        TestUtils.addDynamicExtension(POINT_ID, contribution);
    }

    protected static void removeProcessorExtension() throws Exception {
        TestUtils.removeDynamicExtension(POINT_ID);
    }

    public static final class MyDescriptionProcessor
    implements IDescriptionProcessor {
        private static int m_processCount;

        public void process(AstEditor editor, ComponentDescription componentDescription) throws Exception {
            ++m_processCount;
        }
    }
}

