/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.geometry;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.geometry.AbstractGeometryDialog;
import org.eclipse.wb.internal.swt.model.ModelMessages;

public final class RectanglePropertyEditor
extends TextDialogPropertyEditor {
    public static final PropertyEditor INSTANCE = new RectanglePropertyEditor();

    private RectanglePropertyEditor() {
    }

    protected String getText(Property property) throws Exception {
        Object object = property.getValue();
        if (object instanceof Rectangle) {
            Rectangle rect = (Rectangle)object;
            return "(%d, %d, %d, %d)".formatted(rect.x, rect.y, rect.width, rect.height);
        }
        return null;
    }

    protected void openDialog(Property property) throws Exception {
        Rectangle oldRectangle;
        Object object = property.getValue();
        Rectangle rectangle = object instanceof Rectangle ? (oldRectangle = (Rectangle)object) : new Rectangle(0, 0, 0, 0);
        RectangleDialog rectangleDialog = new RectangleDialog(property.getTitle(), rectangle);
        int result = rectangleDialog.open();
        if (result == 9) {
            property.setValue(Property.UNKNOWN_VALUE);
        } else if (result == 0) {
            property.setValue((Object)rectangle);
        }
    }

    private static final class RectangleDialog
    extends AbstractGeometryDialog {
        public RectangleDialog(String title, Object rectangle) {
            super(title, rectangle);
        }

        protected void createEditors() {
            this.createEditor(ModelMessages.RectanglePropertyEditor_xLabel, "x");
            this.createEditor(ModelMessages.RectanglePropertyEditor_yLabel, "y");
            this.createEditor(ModelMessages.RectanglePropertyEditor_widthLabel, "width");
            this.createEditor(ModelMessages.RectanglePropertyEditor_heightLabel, "height");
        }
    }
}

