/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.bean;

import java.util.List;
import javax.swing.JRadioButton;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.ObjectReferenceInfo;
import org.eclipse.wb.internal.swing.model.bean.ButtonGroupContainerInfo;
import org.eclipse.wb.internal.swing.model.bean.ButtonGroupInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;

public class ButtonGroupTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_noButtonGroups() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ButtonGroupTest.assertEquals((long)0L, (long)panel.getChildren(ButtonGroupContainerInfo.class).size());
        ButtonGroupTest.assertEquals((long)0L, (long)ButtonGroupContainerInfo.getButtonGroups((JavaInfo)panel).size());
        ButtonGroupTest.assertEquals((long)0L, (long)panel.getChildren(ButtonGroupContainerInfo.class).size());
    }

    @Test
    public void test_parse() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final ButtonGroup m_buttonGroup = new ButtonGroup();", "  public Test() {", "    {", "      JRadioButton button_0 = new JRadioButton();", "      add(button_0);", "      m_buttonGroup.add(button_0);", "    }", "    {", "      JRadioButton button_1 = new JRadioButton();", "      add(button_1);", "      m_buttonGroup.add(button_1);", "    }", "    {", "      JRadioButton button_2 = new JRadioButton();", "      add(button_2);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo buttonInfo_0 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonInfo_1 = (ComponentInfo)panel.getChildrenComponents().get(1);
        ComponentInfo buttonInfo_2 = (ComponentInfo)panel.getChildrenComponents().get(2);
        ButtonGroupContainerInfo container = ButtonGroupContainerInfo.get((JavaInfo)panel);
        ButtonGroupTest.assertNotNull((Object)container);
        ButtonGroupTest.assertEquals((long)1L, (long)container.getChildren().size());
        ButtonGroupTest.assertFalse((boolean)container.canDelete());
        container.delete();
        ButtonGroupTest.assertEquals((Object)"(button groups)", (Object)container.getPresentation().getText());
        ButtonGroupTest.assertNotNull((Object)container.getPresentation().getIcon());
        List buttonGroups = ButtonGroupContainerInfo.getButtonGroups((JavaInfo)panel);
        ButtonGroupTest.assertEquals((long)1L, (long)buttonGroups.size());
        ButtonGroupInfo buttonGroup = (ButtonGroupInfo)buttonGroups.get(0);
        ButtonGroupTest.assertNotNull((Object)buttonGroup.getAssociation());
        ButtonGroupTest.assertEquals((Object)"m_buttonGroup", (Object)buttonGroup.getVariableSupport().getName());
        List buttons = buttonGroup.getButtons();
        ButtonGroupTest.assertEquals((long)2L, (long)buttons.size());
        ButtonGroupTest.assertSame((Object)buttonInfo_0, (Object)((ObjectReferenceInfo)buttons.get(0)).getObject());
        ButtonGroupTest.assertSame((Object)buttonInfo_1, (Object)((ObjectReferenceInfo)buttons.get(1)).getObject());
        buttons = buttonGroup.getPresentation().getChildrenTree();
        ButtonGroupTest.assertEquals((long)2L, (long)buttons.size());
        ButtonGroupTest.assertSame((Object)buttonInfo_0, (Object)((ObjectReferenceInfo)buttons.get(0)).getObject());
        ButtonGroupTest.assertSame((Object)buttonInfo_1, (Object)((ObjectReferenceInfo)buttons.get(1)).getObject());
        ButtonGroupTest.assertTrue((boolean)buttonGroup.hasButton(buttonInfo_0));
        ButtonGroupTest.assertTrue((boolean)buttonGroup.hasButton(buttonInfo_1));
        ButtonGroupTest.assertFalse((boolean)buttonGroup.hasButton(buttonInfo_2));
        JRadioButton button_1 = (JRadioButton)buttonInfo_0.getComponent();
        JRadioButton button_2 = (JRadioButton)buttonInfo_1.getComponent();
        ButtonGroupTest.assertFalse((boolean)button_1.isSelected());
        ButtonGroupTest.assertFalse((boolean)button_2.isSelected());
        button_1.setSelected(true);
        ButtonGroupTest.assertTrue((boolean)button_1.isSelected());
        ButtonGroupTest.assertFalse((boolean)button_2.isSelected());
        button_2.setSelected(true);
        ButtonGroupTest.assertFalse((boolean)button_1.isSelected());
        ButtonGroupTest.assertTrue((boolean)button_2.isSelected());
    }

    @Test
    public void test_parse_customButtonGroup() throws Exception {
        ButtonGroupTest.setFileContentSrc("test/MyButtonGroup.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButtonGroup extends ButtonGroup {", "}"));
        ButtonGroupTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  private final MyButtonGroup m_buttonGroup = new MyButtonGroup();", "  public Test() {", "  }", "}");
        ButtonGroupTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {org.eclipse.wb.internal.swing.model.bean.ButtonGroupContainerInfo}", "    {new: test.MyButtonGroup} {field-initializer: m_buttonGroup} {/new MyButtonGroup()/}");
    }

    @Test
    public void test_addButton_new() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final ButtonGroup m_buttonGroup = new ButtonGroup();", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ButtonGroupInfo buttonGroup = (ButtonGroupInfo)ButtonGroupContainerInfo.getButtonGroups((JavaInfo)panel).get(0);
        buttonGroup.addButton(button);
        this.assertEditor("public class Test extends JPanel {", "  private final ButtonGroup m_buttonGroup = new ButtonGroup();", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      m_buttonGroup.add(button);", "      add(button);", "    }", "  }", "}");
        List buttons = buttonGroup.getButtons();
        ButtonGroupTest.assertEquals((long)1L, (long)buttons.size());
        ButtonGroupTest.assertSame((Object)button, (Object)((ObjectReferenceInfo)buttons.get(0)).getObject());
    }

    @Test
    public void test_addButton_inOtherGroup() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final ButtonGroup m_buttonGroup_1 = new ButtonGroup();", "  private final ButtonGroup m_buttonGroup_2 = new ButtonGroup();", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      m_buttonGroup_1.add(button);", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ButtonGroupInfo buttonGroup_1 = (ButtonGroupInfo)ButtonGroupContainerInfo.getButtonGroups((JavaInfo)panel).get(0);
        ButtonGroupInfo buttonGroup_2 = (ButtonGroupInfo)ButtonGroupContainerInfo.getButtonGroups((JavaInfo)panel).get(1);
        ButtonGroupTest.assertTrue((boolean)buttonGroup_1.hasButton(button));
        ButtonGroupTest.assertFalse((boolean)buttonGroup_2.hasButton(button));
        buttonGroup_2.addButton(button);
        this.assertEditor("public class Test extends JPanel {", "  private final ButtonGroup m_buttonGroup_1 = new ButtonGroup();", "  private final ButtonGroup m_buttonGroup_2 = new ButtonGroup();", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      m_buttonGroup_2.add(button);", "      add(button);", "    }", "  }", "}");
        ButtonGroupTest.assertFalse((boolean)buttonGroup_1.hasButton(button));
        ButtonGroupTest.assertTrue((boolean)buttonGroup_2.hasButton(button));
    }

    @Test
    public void test_clearButton() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final ButtonGroup m_buttonGroup = new ButtonGroup();", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      m_buttonGroup.add(button);", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ButtonGroupInfo buttonGroup = (ButtonGroupInfo)ButtonGroupContainerInfo.getButtonGroups((JavaInfo)panel).get(0);
        ButtonGroupTest.assertTrue((boolean)buttonGroup.hasButton(button));
        ButtonGroupInfo.clearButton((ComponentInfo)button);
        this.assertEditor("public class Test extends JPanel {", "  private final ButtonGroup m_buttonGroup = new ButtonGroup();", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      add(button);", "    }", "  }", "}");
        ButtonGroupTest.assertFalse((boolean)buttonGroup.hasButton(button));
    }

    @Test
    public void test_newButtonGroup() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ButtonGroupInfo buttonGroup = ButtonGroupContainerInfo.add((JavaInfo)panel, (String)"javax.swing.ButtonGroup");
        this.assertEditor("public class Test extends JPanel {", "  private final ButtonGroup buttonGroup = new ButtonGroup();", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      add(button);", "    }", "  }", "}");
        buttonGroup.addButton(button);
        this.assertEditor("public class Test extends JPanel {", "  private final ButtonGroup buttonGroup = new ButtonGroup();", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      buttonGroup.add(button);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_contextMenu_notButton() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final ButtonGroup m_buttonGroup = new ButtonGroup();", "  public Test() {", "  }", "}");
        panel.refresh();
        IMenuManager designerMenu = ButtonGroupTest.getContextMenu(new ObjectInfo[]{panel});
        IMenuManager groupsMenu = ButtonGroupTest.findChildMenuManager((IContributionManager)designerMenu, "Set ButtonGroup");
        ButtonGroupTest.assertNull((Object)groupsMenu);
    }

    @Test
    public void test_contextMenu_setGroup_single() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final ButtonGroup m_buttonGroup = new ButtonGroup();", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IAction buttonGroupAction = ButtonGroupTest.getButtonGroupAction("m_buttonGroup", button);
        buttonGroupAction.setChecked(true);
        buttonGroupAction.run();
        this.assertEditor("public class Test extends JPanel {", "  private final ButtonGroup m_buttonGroup = new ButtonGroup();", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      m_buttonGroup.add(button);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_contextMenu_setGroup_multiple() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final ButtonGroup m_buttonGroup = new ButtonGroup();", "  public Test() {", "    {", "      JRadioButton button_1 = new JRadioButton();", "      add(button_1);", "    }", "    {", "      JRadioButton button_2 = new JRadioButton();", "      add(button_2);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        MenuManager designerMenu = ButtonGroupTest.getDesignerMenuManager();
        panel.getBroadcastObject().addContextMenu(List.of(button_1, button_2), (ObjectInfo)button_2, (IMenuManager)designerMenu);
        IMenuManager groupsMenu = ButtonGroupTest.findChildMenuManager((IContributionManager)designerMenu, "Set ButtonGroup");
        IAction buttonGroupAction = ButtonGroupTest.findChildAction((IContributionManager)groupsMenu, "m_buttonGroup");
        String expectedSource = this.m_lastEditor.getSource();
        buttonGroupAction.setChecked(true);
        buttonGroupAction.run();
        ButtonGroupTest.assertEditor(expectedSource, this.m_lastEditor);
        IAction buttonGroupAction2 = ButtonGroupTest.getButtonGroupAction("m_buttonGroup", button_1, button_2);
        buttonGroupAction2.setChecked(true);
        buttonGroupAction2.run();
        this.assertEditor("public class Test extends JPanel {", "  private final ButtonGroup m_buttonGroup = new ButtonGroup();", "  public Test() {", "    {", "      JRadioButton button_1 = new JRadioButton();", "      m_buttonGroup.add(button_1);", "      add(button_1);", "    }", "    {", "      JRadioButton button_2 = new JRadioButton();", "      m_buttonGroup.add(button_2);", "      add(button_2);", "    }", "  }", "}");
    }

    @Test
    public void test_contextMenu_noGroup() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final ButtonGroup m_buttonGroup = new ButtonGroup();", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      m_buttonGroup.add(button);", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IAction noGroupAction = ButtonGroupTest.getButtonGroupAction("None", button);
        noGroupAction.run();
        this.assertEditor("public class Test extends JPanel {", "  private final ButtonGroup m_buttonGroup = new ButtonGroup();", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_contextMenu_newGroup() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IAction newGroupAction = ButtonGroupTest.getButtonGroupAction("New standard", button);
        newGroupAction.run();
        this.assertEditor("public class Test extends JPanel {", "  private final ButtonGroup buttonGroup = new ButtonGroup();", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      buttonGroup.add(button);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_contextMenu_newGroup_custom() throws Exception {
        ButtonGroupTest.setFileContentSrc("test/MyButtonGroup.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButtonGroup extends ButtonGroup {", "}"));
        ButtonGroupTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        final IAction newGroupAction = ButtonGroupTest.getButtonGroupAction("New custom...", button);
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() {
                newGroupAction.run();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                ButtonGroupTest.animateOpenTypeSelection(bot, "MyButtonGroup", "OK");
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  private final MyButtonGroup myButtonGroup = new MyButtonGroup();", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      myButtonGroup.add(button);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_contextMenu_newGroup_custom_cancel() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        final IAction newGroupAction = ButtonGroupTest.getButtonGroupAction("New custom...", button);
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() {
                newGroupAction.run();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                ButtonGroupTest.animateOpenTypeSelection(bot, "java.lang.Object", "OK");
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_contextMenu_newGroup_custom_notButtonGroup() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        final IAction newGroupAction = ButtonGroupTest.getButtonGroupAction("New custom...", button);
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() {
                newGroupAction.run();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Open type").bot();
                shell.button("Cancel").click();
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JRadioButton button = new JRadioButton();", "      add(button);", "    }", "  }", "}");
    }

    private static IAction getButtonGroupAction(String text, ComponentInfo ... buttons) throws Exception {
        IMenuManager designerMenu = ButtonGroupTest.getContextMenu((ObjectInfo[])buttons);
        IMenuManager groupMenu = ButtonGroupTest.findChildMenuManager((IContributionManager)designerMenu, "Set ButtonGroup");
        IAction action = ButtonGroupTest.findChildAction((IContributionManager)groupMenu, text);
        ButtonGroupTest.assertNotNull((Object)action);
        return action;
    }
}

