/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.forms;

import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.rcp.model.forms.SectionInfo;
import org.eclipse.wb.internal.rcp.model.forms.SectionPartInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.model.forms.AbstractFormsTest;
import org.junit.Test;

public class SectionPartTest
extends AbstractFormsTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_withFormToolkit() throws Exception {
        SectionPartInfo part = (SectionPartInfo)this.parseJavaInfo("public class Test extends SectionPart {", "  public Test(Composite parent, FormToolkit toolkit, int style) {", "    super(parent, toolkit, style);", "    createClient(getSection(), toolkit);", "  }", "  private void createClient(Section section, FormToolkit toolkit) {", "    section.setText('New SectionPart');", "    Composite container = toolkit.createComposite(section);", "    section.setClient(container);", "  }", "}");
        SectionPartTest.assertHierarchy("{this: org.eclipse.ui.forms.SectionPart} {this} {}", "  {viewer: public org.eclipse.ui.forms.widgets.Section org.eclipse.ui.forms.SectionPart.getSection()} {viewer} {/createClient(getSection(), toolkit)/ /section.setText('New SectionPart')/ /toolkit.createComposite(section)/ /section.setClient(container)/}", "    {instance factory: {toolkit} createComposite(org.eclipse.swt.widgets.Composite)} {local-unique: container} {/toolkit.createComposite(section)/ /section.setClient(container)/}", "      {implicit-layout: absolute} {implicit-layout} {}", "  {instance factory container}", "    {parameter} {toolkit} {/toolkit.createComposite(section)/ /createClient(getSection(), toolkit)/}");
        SectionInfo section = part.getSection();
        part.refresh();
        SectionPartTest.assertNoErrors((JavaInfo)part);
        SectionPartTest.assertEquals((long)part.getBounds().width, (long)600L);
        SectionPartTest.assertEquals((long)part.getBounds().height, (long)500L);
        SectionPartTest.assertEquals((long)section.getBounds().width, (long)600L);
        SectionPartTest.assertEquals((long)section.getBounds().height, (long)500L);
    }

    @Test
    public void test_additionalConstructorParameter() throws Exception {
        SectionPartInfo part = (SectionPartInfo)this.parseJavaInfo("public class Test extends SectionPart {", "  public Test(Composite parent, FormToolkit toolkit, int style, int foo) {", "    super(parent, toolkit, style);", "    createClient(getSection(), toolkit);", "  }", "  private void createClient(Section section, FormToolkit toolkit) {", "    Composite container = toolkit.createComposite(section);", "    section.setClient(container);", "  }", "}");
        SectionPartTest.assertHierarchy("{this: org.eclipse.ui.forms.SectionPart} {this} {}", "  {viewer: public org.eclipse.ui.forms.widgets.Section org.eclipse.ui.forms.SectionPart.getSection()} {viewer} {/createClient(getSection(), toolkit)/ /toolkit.createComposite(section)/ /section.setClient(container)/}", "    {instance factory: {toolkit} createComposite(org.eclipse.swt.widgets.Composite)} {local-unique: container} {/toolkit.createComposite(section)/ /section.setClient(container)/}", "      {implicit-layout: absolute} {implicit-layout} {}", "  {instance factory container}", "    {parameter} {toolkit} {/toolkit.createComposite(section)/ /createClient(getSection(), toolkit)/}");
        part.refresh();
        SectionPartTest.assertNoErrors((JavaInfo)part);
    }

    @Test
    public void test_disposing() throws Exception {
        SectionPartInfo part = (SectionPartInfo)this.parseJavaInfo("public class Test extends SectionPart {", "  public Test(Composite parent, FormToolkit toolkit, int style) {", "    super(parent, toolkit, style);", "  }", "}");
        part.refresh();
        SectionPartTest.assertNoErrors((JavaInfo)part);
        SectionInfo sectionInfo = (SectionInfo)part.getChildren(SectionInfo.class).get(0);
        Section sectionObject = sectionInfo.getWidget();
        Font font = sectionObject.getFont();
        SectionPartTest.assertFalse((boolean)font.isDisposed());
        Property fontProperty = sectionInfo.getPropertyByTitle("font");
        Font font2 = (Font)fontProperty.getValue();
        SectionPartTest.assertFalse((boolean)font2.isDisposed());
    }

    @Test
    public void test_withFormPage() throws Exception {
        this.parseJavaInfo("public class Test extends SectionPart {", "  /**", "  * @wbp.parser.constructor", "  */", "  public Test(FormPage formPage, Composite parent) {", "    this(parent, formPage.getManagedForm().getToolkit(), Section.DESCRIPTION);", "  }", "  public Test(Composite parent, FormToolkit toolkit, int style) {", "    super(parent, toolkit, style);", "    createClient(getSection(), toolkit);", "  }", "  private void createClient(Section section, FormToolkit toolkit) {", "    Composite container = toolkit.createComposite(section);", "    section.setClient(container);", "  }", "}");
        SectionPartTest.assertHierarchy("{this: org.eclipse.ui.forms.SectionPart} {this} {}", "  {viewer: public org.eclipse.ui.forms.widgets.Section org.eclipse.ui.forms.SectionPart.getSection()} {viewer} {/createClient(getSection(), toolkit)/ /toolkit.createComposite(section)/ /section.setClient(container)/}", "    {instance factory: {empty} createComposite(org.eclipse.swt.widgets.Composite)} {local-unique: container} {/toolkit.createComposite(section)/ /section.setClient(container)/}", "      {implicit-layout: absolute} {implicit-layout} {}", "  {instance factory container}", "    {opaque} {empty} {/formPage.getManagedForm().getToolkit()/ /toolkit.createComposite(section)/ /createClient(getSection(), toolkit)/}");
    }

    @Test
    public void test_useSectionPart() throws Exception {
        SectionPartTest.setFileContentSrc("test/MySectionPart.java", this.getTestSource("public class MySectionPart extends SectionPart {", "  public MySectionPart(Composite parent, FormToolkit toolkit, int style) {", "    super(parent, toolkit, style);", "  }", "}"));
        SectionPartTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private final FormToolkit m_toolkit = new FormToolkit(Display.getDefault());", "  public Test() {", "    setLayout(new FillLayout());", "    MySectionPart part = new MySectionPart(this, m_toolkit, Section.TITLE_BAR);", "  }", "}");
        SectionPartTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FillLayout())/ /new MySectionPart(this, m_toolkit, Section.TITLE_BAR)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {viewer: public org.eclipse.ui.forms.widgets.Section org.eclipse.ui.forms.SectionPart.getSection()} {viewer} {}", "    {new: test.MySectionPart} {local-unique: part} {/new MySectionPart(this, m_toolkit, Section.TITLE_BAR)/}", "  {instance factory container}", "    {new: org.eclipse.ui.forms.widgets.FormToolkit} {field-initializer: m_toolkit} {/new FormToolkit(Display.getDefault())/ /new MySectionPart(this, m_toolkit, Section.TITLE_BAR)/}");
        shell.refresh();
        SectionPartTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_liveImage() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        shell.refresh();
        SectionPartInfo newSectionPart = (SectionPartInfo)SectionPartTest.createJavaInfo("org.eclipse.ui.forms.SectionPart");
        SectionInfo newSection = (SectionInfo)newSectionPart.getWrapper().getWrappedInfo();
        SectionPartTest.assertNotNull((Object)newSection.getImage());
    }

    @Test
    public void test_CREATE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        shell.refresh();
        SectionPartInfo newSectionPart = (SectionPartInfo)SectionPartTest.createJavaInfo("org.eclipse.ui.forms.SectionPart");
        SectionInfo newSection = (SectionInfo)newSectionPart.getWrapper().getWrappedInfo();
        shell.getLayout().command_CREATE((ControlInfo)newSection, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      SectionPart sectionPart = new SectionPart(this, new FormToolkit(Display.getCurrent()), Section.TWISTIE | Section.TITLE_BAR);", "      Section section = sectionPart.getSection();", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_withToolkit() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private final FormToolkit formToolkit = new FormToolkit(Display.getCurrent());", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        SectionPartTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FillLayout())/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {instance factory container}", "    {new: org.eclipse.ui.forms.widgets.FormToolkit} {field-initializer: formToolkit} {/new FormToolkit(Display.getCurrent())/}");
        shell.refresh();
        SectionPartInfo newSectionPart = (SectionPartInfo)SectionPartTest.createJavaInfo("org.eclipse.ui.forms.SectionPart");
        SectionInfo newSection = (SectionInfo)newSectionPart.getWrapper().getWrappedInfo();
        shell.getLayout().command_CREATE((ControlInfo)newSection, null);
        this.assertEditor("public class Test extends Shell {", "  private final FormToolkit formToolkit = new FormToolkit(Display.getCurrent());", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      SectionPart sectionPart = new SectionPart(this, formToolkit, Section.TWISTIE | Section.TITLE_BAR);", "      Section section = sectionPart.getSection();", "      formToolkit.paintBordersFor(section);", "    }", "  }", "}");
    }
}

