/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.palette;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.IPaletteSite;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.core.editor.palette.model.entry.ChooseComponentEntryInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.requests.ICreationFactory;
import org.eclipse.wb.gef.core.tools.CreationTool;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.DesignPageSite;
import org.eclipse.wb.internal.core.editor.palette.PaletteManager;
import org.eclipse.wb.internal.core.editor.palette.command.Command;
import org.eclipse.wb.tests.designer.core.TestProject;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.eclipse.wb.tests.designer.core.palette.AbstractPaletteTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Ignore;
import org.junit.Test;

public class ChooseComponentEntryInfoTest
extends AbstractPaletteTest {
    @Test
    public void test_access() throws Exception {
        ChooseComponentEntryInfo entry = new ChooseComponentEntryInfo();
        ChooseComponentEntryInfoTest.assertNotNull((Object)entry.getIcon());
        ChooseComponentEntryInfoTest.assertNotNull((Object)entry.getName());
        ChooseComponentEntryInfoTest.assertNotNull((Object)entry.getDescription());
    }

    @Test
    public void test_parse() throws Exception {
        ChooseComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <entry id='system.chooseComponent' name='my name' class='" + ChooseComponentEntryInfo.class.getName() + "'/>", "</category>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("category_1");
        ChooseComponentEntryInfo entry = (ChooseComponentEntryInfo)category.getEntries().get(0);
        ChooseComponentEntryInfoTest.assertSame((Object)category, (Object)entry.getCategory());
        ChooseComponentEntryInfoTest.assertEquals((Object)"system.chooseComponent", (Object)entry.getId());
        ChooseComponentEntryInfoTest.assertEquals((Object)"my name", (Object)entry.getName());
    }

    @Test
    public void test_createTool_cancel() throws Exception {
        ChooseComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <entry id='system.chooseComponent' class='" + ChooseComponentEntryInfo.class.getName() + "'/>", "</category>"});
        JavaInfo panel = this.parseEmptyPanel();
        PaletteManager manager = new PaletteManager(panel, "test.toolkit");
        manager.reloadPalette();
        IPaletteSite.Helper.setSite((ObjectInfo)panel, (IPaletteSite)new IPaletteSite.Empty(){

            public Shell getShell() {
                return DesignerPlugin.getShell();
            }
        });
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category = palette.getCategory("category_1");
        final ChooseComponentEntryInfo entry = (ChooseComponentEntryInfo)category.getEntries().get(0);
        ChooseComponentEntryInfoTest.assertTrue((boolean)entry.initialize(null, panel));
        final CreationTool[] tools = new CreationTool[1];
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                tools[0] = (CreationTool)entry.createTool();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Open type").bot();
                shell.button("Cancel").click();
            }
        });
        CreationTool creationTool = tools[0];
        ChooseComponentEntryInfoTest.assertNull((Object)creationTool);
    }

    @Test
    public void test_createTool_select() throws Exception {
        ChooseComponentEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <entry id='system.chooseComponent' class='" + ChooseComponentEntryInfo.class.getName() + "'/>", "</category>"});
        JavaInfo panel = this.parseEmptyPanel();
        final PaletteManager manager = new PaletteManager(panel, "test.toolkit");
        manager.reloadPalette();
        IPaletteSite.Helper.setSite((ObjectInfo)panel, (IPaletteSite)new IPaletteSite.Empty(){

            public Shell getShell() {
                return DesignerPlugin.getShell();
            }

            public PaletteInfo getPalette() {
                return manager.getPalette();
            }

            public void addCommand(Command command) {
                manager.commands_add(command);
            }
        });
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category = palette.getCategory("category_1");
        final ChooseComponentEntryInfo entry = (ChooseComponentEntryInfo)category.getEntries().get(0);
        ChooseComponentEntryInfoTest.assertTrue((boolean)entry.initialize(null, panel));
        final CreationTool[] tools = new CreationTool[1];
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                tools[0] = (CreationTool)entry.createTool();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                ChooseComponentEntryInfoTest.animateOpenTypeSelection(bot, "JButton", "OK");
            }
        });
        CreationTool creationTool = tools[0];
        ICreationFactory creationFactory = creationTool.getFactory();
        creationFactory.activate();
        JavaInfo javaInfo = (JavaInfo)creationFactory.getNewObject();
        ChooseComponentEntryInfoTest.assertEquals((Object)"new javax.swing.JButton(\"New button\")", (Object)javaInfo.getCreationSupport().add_getSource(null));
    }

    @DisposeProjectAfter
    @Ignore
    @Test
    public void test_createTool_inProject_butNotInClassLoader() throws Exception {
        JavaInfo panel = this.parseEmptyPanel();
        final PaletteManager manager = new PaletteManager(panel, "test.toolkit");
        manager.reloadPalette();
        IPaletteSite.Helper.setSite((ObjectInfo)panel, (IPaletteSite)new IPaletteSite.Empty(){

            public Shell getShell() {
                return DesignerPlugin.getShell();
            }

            public PaletteInfo getPalette() {
                return manager.getPalette();
            }

            public void addCommand(Command command) {
                manager.commands_add(command);
            }
        });
        final AtomicBoolean reparsed = new AtomicBoolean();
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)new DesignPageSite(){

            public void reparse() {
                reparsed.set(true);
            }
        });
        TestProject newProject = new TestProject("NewProject");
        try {
            ChooseComponentEntryInfoTest.setFileContentSrc(newProject.getProject(), "my/classes/MyClass.java", ChooseComponentEntryInfoTest.getSource("// filler filler filler filler filler", "package my.classes;", "public class MyClass {", "}"));
            m_testProject.addRequiredProject(newProject);
            ChooseComponentEntryInfoTest.waitForAutoBuild();
            final ChooseComponentEntryInfo entry = new ChooseComponentEntryInfo();
            ChooseComponentEntryInfoTest.assertTrue((boolean)entry.initialize(null, panel));
            final CreationTool[] tools = new CreationTool[1];
            new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

                public void run() throws Exception {
                    tools[0] = (CreationTool)entry.createTool();
                }
            }, new FailableConsumer<SWTBot, Exception>(){

                public void accept(SWTBot bot) {
                    ChooseComponentEntryInfoTest.animateOpenTypeSelection(bot, "MyClass", "OK");
                    bot.shell("Unable to load component").bot().button("Yes").click();
                }
            });
        }
        finally {
            newProject.dispose();
        }
        ChooseComponentEntryInfoTest.assertTrue((boolean)reparsed.get());
    }
}

