/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.AssociationObject;
import org.eclipse.wb.core.model.association.AssociationObjects;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryInfo;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGenerator;
import org.eclipse.wb.internal.core.model.generation.statement.block.BlockStatementGenerator;
import org.eclipse.wb.internal.core.model.generation.statement.block.BlockStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualBeanContainerInfo;
import org.eclipse.wb.internal.core.model.variable.FieldInitializerVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.model.variable.description.FieldInitializerVariableDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.core.model.variables.AbstractVariableTest;
import org.eclipse.wb.tests.designer.swing.SwingTestUtils;
import org.junit.Test;

public class FieldInitializerTest
extends AbstractVariableTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_object() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button = new JButton();", "  public Test() {", "    button.setText('text');", "    add(button);", "  }", "}");
        AstEditor editor = this.m_lastEditor;
        FieldInitializerTest.assertEquals((long)1L, (long)panel.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FieldInitializerVariableSupport variableSupport = (FieldInitializerVariableSupport)button.getVariableSupport();
        FieldInitializerTest.assertEquals((Object)"field-initializer: button", (Object)variableSupport.toString());
        FieldInitializerTest.assertEquals((Object)"button", (Object)variableSupport.getName());
        FieldInitializerTest.assertFalse((boolean)variableSupport.canConvertLocalToField());
        FieldInitializerTest.assertFalse((boolean)variableSupport.canConvertFieldToLocal());
        try {
            variableSupport.convertLocalToField();
            FieldInitializerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.convertFieldToLocal();
            FieldInitializerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        String expected = StringUtils.replace((String)editor.getSource(), (String)"button", (String)"abc");
        variableSupport.setName("abc");
        FieldInitializerTest.assertEquals((Object)expected, (Object)editor.getSource());
    }

    @Test
    public void test_getReferenceExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button = new JButton();", "  public Test() {", "    add(button);", "  }", "}");
        String expectedSource = this.m_lastEditor.getSource();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FieldInitializerVariableSupport variableSupport = (FieldInitializerVariableSupport)button.getVariableSupport();
        NodeTarget target = FieldInitializerTest.getNodeStatementTarget((JavaInfo)panel, true, new int[0]);
        FieldInitializerTest.assertTrue((boolean)variableSupport.hasExpression(target));
        FieldInitializerTest.assertEquals((Object)"button", (Object)variableSupport.getReferenceExpression(target));
        FieldInitializerTest.assertEditor(expectedSource, this.m_lastEditor);
        target = FieldInitializerTest.getNodeBodyDeclarationTarget((JavaInfo)button, false, 0);
        FieldInitializerTest.assertTrue((boolean)variableSupport.hasExpression(target));
        FieldInitializerTest.assertEquals((Object)"button", (Object)variableSupport.getReferenceExpression(target));
        FieldInitializerTest.assertEditor(expectedSource, this.m_lastEditor);
        target = FieldInitializerTest.getNodeBodyDeclarationTarget((JavaInfo)button, false, 1);
        FieldInitializerTest.assertTrue((boolean)variableSupport.hasExpression(target));
        FieldInitializerTest.assertEquals((Object)"button", (Object)variableSupport.getReferenceExpression(target));
        FieldInitializerTest.assertEditor(expectedSource, this.m_lastEditor);
        target = FieldInitializerTest.getNodeBodyDeclarationTarget((JavaInfo)button, true, 0);
        FieldInitializerTest.assertFalse((boolean)variableSupport.hasExpression(target));
        try {
            variableSupport.getReferenceExpression(target);
            FieldInitializerTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
        target = FieldInitializerTest.getNodeBodyDeclarationTarget((JavaInfo)button, true, 1);
        FieldInitializerTest.assertTrue((boolean)variableSupport.hasExpression(target));
        FieldInitializerTest.assertEquals((Object)"button", (Object)variableSupport.getReferenceExpression(target));
        FieldInitializerTest.assertEditor(expectedSource, this.m_lastEditor);
        target = FieldInitializerTest.getNodeTypeDeclarationTarget((JavaInfo)button, true);
        FieldInitializerTest.assertFalse((boolean)variableSupport.hasExpression(target));
        target = FieldInitializerTest.getNodeTypeDeclarationTarget((JavaInfo)button, false);
        FieldInitializerTest.assertTrue((boolean)variableSupport.hasExpression(target));
        FieldInitializerTest.assertEquals((Object)"button", (Object)variableSupport.getReferenceExpression(target));
        FieldInitializerTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_getTarget_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  static JPanel panel = new JPanel();", "  public static void main(String args[]) {", "    int value;", "  }", "}");
        Block expectedBlock = FieldInitializerTest.getBlock((JavaInfo)panel, "main(java.lang.String[])", new int[0]);
        FieldInitializerTest.assertStatementTarget((JavaInfo)panel, expectedBlock, null, true);
    }

    @Test
    public void test_getTarget_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  static JPanel panel = new JPanel();", "  public static void main(String args[]) {", "    int value;", "    panel.add(new JButton());", "  }", "}");
        Statement expectedStatement = FieldInitializerTest.getStatement((JavaInfo)panel, "main(java.lang.String[])", 1);
        FieldInitializerTest.assertStatementTarget((JavaInfo)panel, null, expectedStatement, true);
    }

    @Test
    public void test_getTarget_4() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  static JButton button = new JButton();", "  public Test() {", "    super();", "    int value;", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Statement expectedStatement = FieldInitializerTest.getStatement((JavaInfo)panel, 2);
        FieldInitializerTest.assertStatementTarget((JavaInfo)button, null, expectedStatement, true);
    }

    @Test
    public void test_getTarget_5() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  static JPanel panel = new JPanel();", "  public static void main(String args[]) {", "    int value;", "    panel.setVisible(true);", "    panel.setEnabled(true);", "  }", "}");
        Statement expectedStatement = FieldInitializerTest.getStatement((JavaInfo)panel, "main(java.lang.String[])", 1);
        FieldInitializerTest.assertStatementTarget((JavaInfo)panel, null, expectedStatement, true);
    }

    @Test
    public void test_getTarget_6() throws Exception {
        FieldInitializerTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public int m_value;", "}"));
        FieldInitializerTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test {", "  static MyPanel panel = new MyPanel();", "  public static void main(String args[]) {", "    int value;", "    panel.m_value = 1;", "  }", "}");
        Statement expectedStatement = FieldInitializerTest.getStatement((JavaInfo)panel, "main(java.lang.String[])", 1);
        FieldInitializerTest.assertStatementTarget((JavaInfo)panel, null, expectedStatement, true);
    }

    @Test
    public void test_getTarget_7() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  static JPanel panel = new JPanel();", "  public static void main(String args[]) {", "    int value;", "    foo(panel);", "  }", "  private static void foo(Component component) {", "  }", "}");
        Block expectedBlock = FieldInitializerTest.getBlock((JavaInfo)panel, "main(java.lang.String[])", new int[0]);
        FieldInitializerTest.assertStatementTarget((JavaInfo)panel, expectedBlock, null, true);
    }

    @Test
    public void test_getTarget_8() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  private JPanel panel = new JPanel();", "  public static void main(String args[]) {", "    Test application = new Test();", "  }", "  public Test() {", "    int constructorMarker;", "  }", "}");
        ExecutionFlowDescription flowDescription = this.m_lastState.getFlowDescription();
        List startMethods = flowDescription.getStartMethods();
        FieldInitializerTest.assertEquals((long)1L, (long)startMethods.size());
        FieldInitializerTest.assertEquals((Object)"main(java.lang.String[])", (Object)AstNodeUtils.getMethodSignature((MethodDeclaration)((MethodDeclaration)startMethods.get(0))));
        Block expectedBlock = FieldInitializerTest.getBlock((JavaInfo)panel, "<init>()", new int[0]);
        FieldInitializerTest.assertStatementTarget((JavaInfo)panel, expectedBlock, null, true);
    }

    @Test
    public void test_getTarget_9() throws Exception {
        FieldInitializerTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public class InstanceFactory {", "  public JButton createButton() {", "    return new JButton();", "  }", "}"));
        FieldInitializerTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test {", "  private final InstanceFactory m_factory = new InstanceFactory();", "  private JPanel panel;", "  public static void main(String args[]) {", "    Test application = new Test();", "  }", "  public Test() {", "    createContents();", "  }", "  public void createContents() {", "    panel = new JPanel();", "  }", "}");
        FieldInitializerTest.assertEquals((Object)"panel", (Object)panel.getVariableSupport().getName());
        InstanceFactoryInfo factory = (InstanceFactoryInfo)InstanceFactoryInfo.getFactories((JavaInfo)panel, this.m_lastLoader.loadClass("test.InstanceFactory")).get(0);
        ExecutionFlowDescription flowDescription = this.m_lastState.getFlowDescription();
        List startMethods = flowDescription.getStartMethods();
        FieldInitializerTest.assertEquals((long)1L, (long)startMethods.size());
        FieldInitializerTest.assertEquals((Object)"main(java.lang.String[])", (Object)AstNodeUtils.getMethodSignature((MethodDeclaration)((MethodDeclaration)startMethods.get(0))));
        Block expectedBlock = FieldInitializerTest.getBlock((JavaInfo)panel, "createContents()", new int[0]);
        FieldInitializerTest.assertStatementTarget((JavaInfo)factory, expectedBlock, null, true);
    }

    @Test
    public void test_getTarget_forNonVisualBean_whenSuper() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  /**", "  * @wbp.nonvisual location=150,400", "  */", "  private final Object object = new Object();", "  public Test() {", "    super();", "  }", "}");
        NonVisualBeanContainerInfo nvoContainer = NonVisualBeanContainerInfo.find((JavaInfo)panel);
        JavaInfo object = (JavaInfo)nvoContainer.getChildren(JavaInfo.class).get(0);
        Statement expectedStatement = FieldInitializerTest.getStatement((JavaInfo)panel, 0);
        FieldInitializerTest.assertStatementTarget(object, null, expectedStatement, false);
    }

    @Test
    public void test_ADD_private() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = FieldInitializerTest.createJButton();
        SwingTestUtils.setGenerations(FieldInitializerVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        SwingTestUtils.setFieldInitializerModifier(0);
        try {
            flowLayout.add(newComponent, null);
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private final JButton button = new JButton();", "  public Test() {", "    {", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_package() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = FieldInitializerTest.createJButton();
        SwingTestUtils.setGenerations(FieldInitializerVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        SwingTestUtils.setFieldInitializerModifier(1);
        try {
            flowLayout.add(newComponent, null);
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  final JButton button = new JButton();", "  public Test() {", "    {", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_static() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = FieldInitializerTest.createJButton();
        SwingTestUtils.setGenerations(FieldInitializerVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        try {
            flowLayout.add(newComponent, null);
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        this.assertEditor("public class Test {", "  private static final JButton button = new JButton();", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    {", "      panel.add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_forceStatic() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentInfo newComponent = FieldInitializerTest.createJButton();
        FieldInitializerVariableSupport variableSupport = new FieldInitializerVariableSupport((JavaInfo)newComponent);
        variableSupport.setForceStaticModifier(true);
        JavaInfoUtils.add((JavaInfo)newComponent, (VariableSupport)variableSupport, (StatementGenerator)BlockStatementGenerator.INSTANCE, (AssociationObject)AssociationObjects.invocationChild((String)"%parent%.add(%child%)", (boolean)false), (JavaInfo)panel, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private static final JButton button = new JButton();", "  public Test() {", "    {", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_thisPrefix() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = FieldInitializerTest.createJButton();
        SwingTestUtils.setGenerations(FieldInitializerVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        panel.getDescription().getToolkit().getPreferences().setValue("variable.fieldInitializer.prefixThis", true);
        try {
            flowLayout.add(newComponent, null);
            this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private final JButton button = new JButton();", "  public Test() {", "    {", "      add(this.button);", "    }", "  }", "}");
            FieldInitializerVariableSupport variableSupport = (FieldInitializerVariableSupport)newComponent.getVariableSupport();
            NodeTarget target = FieldInitializerTest.getNodeStatementTarget((JavaInfo)panel, false, 0, 0);
            FieldInitializerTest.assertTrue((boolean)variableSupport.hasExpression(target));
            FieldInitializerTest.assertEquals((Object)"this.button", (Object)variableSupport.getReferenceExpression(target));
            FieldInitializerTest.assertEquals((Object)"this.button.", (Object)variableSupport.getAccessExpression(target));
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
    }

    @Test
    public void test_ADD_variableName_inCreationSource() throws Exception {
        FieldInitializerTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "public class MyButton extends JButton {", "  public MyButton(String text) {", "  }", "}"));
        FieldInitializerTest.setFileContentSrc("test/MyButton.wbp-component.xml", FieldInitializerTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton('%variable-name%')]]></source>", "  </creation>", "</component>"));
        FieldInitializerTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentInfo button = (ComponentInfo)FieldInitializerTest.createJavaInfo("test.MyButton");
        SwingTestUtils.setGenerations(FieldInitializerVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        ((FlowLayoutInfo)panel.getLayout()).add(button, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private final MyButton myButton = new MyButton('myButton');", "  public Test() {", "    {", "      add(myButton);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_typeArguments() throws Exception {
        FieldInitializerTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton<K, V> extends JButton {", "}"));
        FieldInitializerTest.setFileContentSrc("test/MyButton.wbp-component.xml", FieldInitializerTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton<%keyType%, %valueType%>()]]></source>", "  </creation>", "</component>"));
        FieldInitializerTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        SwingTestUtils.setGenerations(FieldInitializerVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        ComponentInfo newButton = (ComponentInfo)FieldInitializerTest.createJavaInfo("test.MyButton");
        newButton.putTemplateArgument("keyType", "java.lang.String");
        newButton.putTemplateArgument("valueType", "java.util.List<java.lang.Double>");
        ((FlowLayoutInfo)panel.getLayout()).add(newButton, null);
        this.assertEditor("import java.util.List;", "// filler filler filler filler filler", "public class Test extends JPanel {", "  private final MyButton<String, List<Double>> myButton = new MyButton<String, List<Double>>();", "  public Test() {", "    {", "      add(myButton);", "    }", "  }", "}");
    }

    @Test
    public void test_delete_1() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class  Test extends JPanel {", "  private JButton button = new JButton();", "  Test() {", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FieldInitializerTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("// filler filler filler", "public class  Test extends JPanel {", "  Test() {", "  }", "}");
    }

    @Test
    public void test_delete_2() throws Exception {
        this.parseContainer("// filler filler filler", "public class  Test extends JPanel {", "  private JButton button_1 = new JButton(), button_2 = new JButton();", "  Test() {", "    add(button_1);", "    add(button_2);", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)FieldInitializerTest.getJavaInfoByName("button_1");
        FieldInitializerTest.assertTrue((boolean)button_1.canDelete());
        button_1.delete();
        this.assertEditor("// filler filler filler", "public class  Test extends JPanel {", "  private JButton button_2 = new JButton();", "  Test() {", "    add(button_2);", "  }", "}");
        ComponentInfo button_2 = (ComponentInfo)FieldInitializerTest.getJavaInfoByName("button_2");
        FieldInitializerTest.assertTrue((boolean)button_2.canDelete());
        button_2.delete();
        this.assertEditor("// filler filler filler", "public class  Test extends JPanel {", "  Test() {", "  }", "}");
    }

    @Test
    public void test_delete_3() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test {", "  private static JPanel rootPanel = new JPanel();", "  public static void main(String[] args) {", "  }", "}");
        FieldInitializerTest.assertTrue((boolean)panel.canDelete());
        panel.delete();
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test {", "  private static JPanel rootPanel = new JPanel();", "  public static void main(String[] args) {", "  }", "}");
    }

    @Test
    public void test_move_withRelatedNodes() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final JPanel panel2 = new JPanel();", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "    }", "    {", "      add(panel2);", "      panel2.setEnabled(false);", "    }", "  }", "}");
        ContainerInfo panel_1 = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerInfo panel_2 = (ContainerInfo)panel.getChildrenComponents().get(1);
        FlowLayoutInfo flowLayout_1 = (FlowLayoutInfo)panel_1.getLayout();
        flowLayout_1.move((ComponentInfo)panel_2, null);
        this.assertEditor("public class Test extends JPanel {", "  private final JPanel panel2 = new JPanel();", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      {", "        panel.add(panel2);", "        panel2.setEnabled(false);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_move_noRelatedNodes() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final JPanel panel2 = new JPanel();", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "    }", "    {", "      add(panel2);", "    }", "  }", "}");
        ContainerInfo panel_1 = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerInfo panel_2 = (ContainerInfo)panel.getChildrenComponents().get(1);
        FlowLayoutInfo flowLayout_1 = (FlowLayoutInfo)panel_1.getLayout();
        flowLayout_1.move((ComponentInfo)panel_2, null);
        this.assertEditor("public class Test extends JPanel {", "  private final JPanel panel2 = new JPanel();", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      panel.add(panel2);", "    }", "  }", "}");
    }

    @Test
    public void test_setType() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button = new JButton();", "  public Test() {", "    add(button);", "  }", "}");
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        FieldInitializerVariableSupport variable = (FieldInitializerVariableSupport)button.getVariableSupport();
        variable.setType("javax.swing.JTextField");
        this.assertEditor("public class Test extends JPanel {", "  private JTextField button = new JButton();", "  public Test() {", "    add(button);", "  }", "}");
    }
}

