/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.refactoring.descriptors.DeleteDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.MoveDescriptor;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class RefactoringTestUtils {
    private static final String ATTRIBUTE_RESOURCES = "resources";
    private static final String ATTRIBUTE_ELEMENTS = "elements";
    private static final String ATTRIBUTE_SUGGEST_ACCESSORS = "accessors";
    private static final String ATTRIBUTE_DELETE_SUBPACKAGES = "subPackages";

    public static void renameType(IType typeToRename, String newName) throws Exception {
        RenameSupport renameSupport = RenameSupport.create((IType)typeToRename, (String)newName, (int)1);
        renameSupport.preCheck();
        renameSupport.perform(DesignerPlugin.getShell(), (IRunnableContext)DesignerPlugin.getActiveWorkbenchWindow());
    }

    public static void renameMethod(IMethod methodToRename, String newName) throws Exception {
        RenameSupport renameSupport = RenameSupport.create((IMethod)methodToRename, (String)newName, (int)1);
        renameSupport.preCheck();
        renameSupport.perform(DesignerPlugin.getShell(), (IRunnableContext)DesignerPlugin.getActiveWorkbenchWindow());
    }

    public static void moveType(IType type, IPackageFragment newPackage) throws Exception {
        RefactoringTestUtils.moveCompilationUnit(type.getCompilationUnit(), newPackage);
    }

    public static void moveCompilationUnit(ICompilationUnit compilationUnit, IPackageFragment newPackage) throws Exception {
        MoveDescriptor refactoringDescriptor = (MoveDescriptor)RefactoringCore.getRefactoringContribution((String)"org.eclipse.jdt.ui.move").createDescriptor();
        refactoringDescriptor.setMoveResources(new IFile[0], new IFolder[0], new ICompilationUnit[]{compilationUnit});
        refactoringDescriptor.setDestination((IJavaElement)newPackage);
        refactoringDescriptor.setUpdateReferences(true);
        RefactoringTestUtils.performRefactoring((RefactoringDescriptor)refactoringDescriptor);
    }

    public static void deleteType(IType type) throws Exception {
        RefactoringTestUtils.deleteCompilationUnit(type.getCompilationUnit());
    }

    public static void deleteCompilationUnit(ICompilationUnit compilationUnit) throws Exception {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put(ATTRIBUTE_DELETE_SUBPACKAGES, "false");
        arguments.put(ATTRIBUTE_SUGGEST_ACCESSORS, "false");
        arguments.put(ATTRIBUTE_RESOURCES, "0");
        arguments.put(ATTRIBUTE_ELEMENTS, "1");
        arguments.put("element1", compilationUnit.getHandleIdentifier());
        DeleteDescriptor refactoringDescriptor = (DeleteDescriptor)RefactoringCore.getRefactoringContribution((String)"org.eclipse.jdt.ui.delete").createDescriptor("org.eclipse.jdt.ui.delete", compilationUnit.getJavaProject().getElementName(), "Delete " + compilationUnit.getElementName(), "", arguments, 0);
        RefactoringTestUtils.performRefactoring((RefactoringDescriptor)refactoringDescriptor);
    }

    public static void performRefactoring(RefactoringDescriptor refactoringDescriptor) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Refactoring refactoring = refactoringDescriptor.createRefactoring(refactoringStatus);
        Assert.isTrue((!refactoringStatus.hasError() ? 1 : 0) != 0, (String)refactoringStatus.toString());
        refactoring.checkAllConditions((IProgressMonitor)monitor);
        Assert.isTrue((!refactoringStatus.hasError() ? 1 : 0) != 0, (String)refactoringStatus.toString());
        Change change = refactoring.createChange((IProgressMonitor)monitor);
        change.perform((IProgressMonitor)monitor);
    }
}

