package com.leagueplanet.model;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class Event implements Serializable {

	private static final long serialVersionUID = 1L;

	private long id;

	private String name;

	private Location location;

	private Date date;

	private Time time;

	private Schedule schedule;

	public Event() {
		this(0, "", "1970-01-01", "00:00:00");
	}

	public Event(long id, String name, String date, String time) {
		this(id, name, Date.valueOf(date), Time.valueOf(time));
	}

	public Event(long id, String name, Date date, Time time) {
		setId(id);
		setName(name);
		setDate(date);
		setTime(time);
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public Location getLocation() {
		return location;
	}

	public void setLocation(Location location) {
		this.location = location;
	}

	public void setTime(Time time) {
		this.time = time;
	}

	public Time getTime() {
		return time;
	}

	public Schedule getSchedule() {
		return schedule;
	}

	public void setSchedule(Schedule schedule) {
		this.schedule = schedule;
	}
	
	/**
	 * Creates a calendar based on the time zone of the location
	 * and the local date and time of the event.
	 * 
	 * @return the calendar for the event
	 */

	public Calendar toCalendar() {

		// get the time zone from the location
		String timeZoneId = location.getTimeZoneId();
		TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
		
		// create a calendar for the time zone
		GregorianCalendar calendar = new GregorianCalendar(timeZone);

		// zero out the time to clear the milliseconds field
		calendar.setTimeInMillis(0);

		// set the local date and time
		int year = date.getYear() + 1900;
		int month = date.getMonth();
		int dayOfMonth = date.getDate();
		int hours = time.getHours();
		int minutes = time.getMinutes();
		int seconds = time.getSeconds();
		
		calendar.set(year, month, dayOfMonth, hours, minutes, seconds);

		return calendar;
	}
}
