/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterator.ReadOnlyIterator;

public class ReadOnlyIteratorTests
extends TestCase {
    public ReadOnlyIteratorTests(String name) {
        super(name);
    }

    public void testHasNext() {
        int i = 0;
        Iterator<String> stream = this.buildReadOnlyIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        ReadOnlyIteratorTests.assertEquals((int)this.buildVector().size(), (int)i);
    }

    public void testHasNextUpcast() {
        int i = 0;
        Iterator<Object> stream = this.buildReadOnlyIteratorUpcast();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        ReadOnlyIteratorTests.assertEquals((int)this.buildVector().size(), (int)i);
    }

    public void testNext() {
        Iterator<String> nestedIterator = this.buildNestedIterator();
        Iterator<String> stream = this.buildReadOnlyIterator();
        while (stream.hasNext()) {
            ReadOnlyIteratorTests.assertEquals((String)"bogus element", (String)nestedIterator.next(), (String)stream.next());
        }
    }

    public void testNextUpcast() {
        Iterator<String> nestedIterator = this.buildNestedIterator();
        Iterator<Object> stream = this.buildReadOnlyIteratorUpcast();
        while (stream.hasNext()) {
            ReadOnlyIteratorTests.assertEquals((String)"bogus element", (Object)nestedIterator.next(), (Object)stream.next());
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildReadOnlyIterator();
        String string = null;
        while (stream.hasNext()) {
            string = stream.next();
        }
        try {
            string = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        ReadOnlyIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testRemove() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildReadOnlyIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ReadOnlyIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    private Iterator<String> buildReadOnlyIterator() {
        return this.buildReadOnlyIterator(this.buildNestedIterator());
    }

    private Iterator<Object> buildReadOnlyIteratorUpcast() {
        return this.buildReadOnlyIteratorUpcast(this.buildNestedIterator());
    }

    private Iterator<String> buildReadOnlyIterator(Iterator<String> nestedIterator) {
        return new ReadOnlyIterator(nestedIterator);
    }

    private Iterator<Object> buildReadOnlyIteratorUpcast(Iterator<String> nestedIterator) {
        return new ReadOnlyIterator(nestedIterator);
    }

    private Iterator<String> buildNestedIterator() {
        return this.buildVector().iterator();
    }

    private Vector<String> buildVector() {
        Vector<String> v = new Vector<String>();
        v.addElement("one");
        v.addElement("two");
        v.addElement("three");
        v.addElement("four");
        v.addElement("five");
        v.addElement("six");
        v.addElement("seven");
        v.addElement("eight");
        return v;
    }
}

