/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.deque;

import java.util.Arrays;
import org.eclipse.jpt.common.utility.deque.Deque;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.deque.DequeTools;
import org.eclipse.jpt.common.utility.internal.deque.LinkedDeque;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.tests.internal.deque.DequeTests;

public class LinkedDequeTests
extends DequeTests {
    public LinkedDequeTests(String name) {
        super(name);
    }

    @Override
    Deque<String> buildDeque() {
        return DequeTools.linkedDeque();
    }

    public void testConstructorInt_IAE() {
        boolean exCaught = false;
        try {
            LinkedDeque queue = DequeTools.linkedDeque((int)-3);
            LinkedDequeTests.fail((String)("bogus deque: " + queue));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        LinkedDequeTests.assertTrue((boolean)exCaught);
    }

    public void testSize() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        String third = "third";
        LinkedDequeTests.assertEquals((int)0, (int)((Integer)ObjectTools.execute(queue, (String)"size")));
        queue.enqueueTail((Object)first);
        queue.enqueueTail((Object)second);
        LinkedDequeTests.assertEquals((int)2, (int)((Integer)ObjectTools.execute(queue, (String)"size")));
        queue.enqueueTail((Object)third);
        LinkedDequeTests.assertEquals((int)3, (int)((Integer)ObjectTools.execute(queue, (String)"size")));
        queue.dequeueHead();
        LinkedDequeTests.assertEquals((int)2, (int)((Integer)ObjectTools.execute(queue, (String)"size")));
        queue.dequeueHead();
        queue.dequeueHead();
        LinkedDequeTests.assertEquals((int)0, (int)((Integer)ObjectTools.execute(queue, (String)"size")));
    }

    public void testSize_reverse() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        String third = "third";
        LinkedDequeTests.assertEquals((int)0, (int)((Integer)ObjectTools.execute(queue, (String)"size")));
        queue.enqueueHead((Object)first);
        queue.enqueueHead((Object)second);
        LinkedDequeTests.assertEquals((int)2, (int)((Integer)ObjectTools.execute(queue, (String)"size")));
        queue.enqueueHead((Object)third);
        LinkedDequeTests.assertEquals((int)3, (int)((Integer)ObjectTools.execute(queue, (String)"size")));
        queue.dequeueTail();
        LinkedDequeTests.assertEquals((int)2, (int)((Integer)ObjectTools.execute(queue, (String)"size")));
        queue.dequeueTail();
        queue.dequeueTail();
        LinkedDequeTests.assertEquals((int)0, (int)((Integer)ObjectTools.execute(queue, (String)"size")));
    }

    public void testBuildElements() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        String third = "third";
        queue.enqueueTail((Object)first);
        queue.enqueueTail((Object)second);
        queue.enqueueTail((Object)third);
        Object[] elements = new Object[]{first, second, third};
        LinkedDequeTests.assertTrue((boolean)Arrays.equals(elements, (Object[])ObjectTools.execute(queue, (String)"buildElements")));
    }

    public void testBuildElements_reverse() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        String third = "third";
        queue.enqueueHead((Object)first);
        queue.enqueueHead((Object)second);
        queue.enqueueHead((Object)third);
        Object[] elements = new Object[]{third, second, first};
        LinkedDequeTests.assertTrue((boolean)Arrays.equals(elements, (Object[])ObjectTools.execute(queue, (String)"buildElements")));
    }

    public void testNodeCache_max() {
        LinkedDeque queue = new LinkedDeque(2);
        String first = "first";
        String second = "second";
        String third = "third";
        String fourth = "fourth";
        String fifth = "fifth";
        Object factory = ObjectTools.get((Object)queue, (String)"nodeFactory");
        this.verifyNodeCache(0, factory);
        queue.enqueueTail((Object)first);
        this.verifyNodeCache(0, factory);
        queue.enqueueTail((Object)second);
        queue.enqueueHead((Object)third);
        queue.enqueueHead((Object)fourth);
        queue.enqueueTail((Object)fifth);
        this.verifyNodeCache(0, factory);
        LinkedDequeTests.assertNull((Object)ObjectTools.get((Object)factory, (String)"cacheHead"));
        queue.dequeueHead();
        this.verifyNodeCache(1, factory);
        queue.dequeueHead();
        this.verifyNodeCache(2, factory);
        queue.dequeueTail();
        this.verifyNodeCache(2, factory);
        queue.dequeueHead();
        this.verifyNodeCache(2, factory);
        queue.dequeueTail();
        this.verifyNodeCache(2, factory);
        queue.enqueueTail((Object)first);
        this.verifyNodeCache(1, factory);
        queue.enqueueTail((Object)second);
        this.verifyNodeCache(0, factory);
        queue.enqueueTail((Object)third);
        this.verifyNodeCache(0, factory);
    }

    public void testNodeCache_unlimited() {
        LinkedDeque queue = DequeTools.linkedDeque((int)-1);
        String first = "first";
        String second = "second";
        String third = "third";
        String fourth = "fourth";
        String fifth = "fifth";
        Object factory = ObjectTools.get((Object)queue, (String)"nodeFactory");
        this.verifyNodeCache(0, factory);
        queue.enqueueTail((Object)first);
        this.verifyNodeCache(0, factory);
        queue.enqueueTail((Object)second);
        queue.enqueueHead((Object)third);
        queue.enqueueHead((Object)fourth);
        queue.enqueueTail((Object)fifth);
        this.verifyNodeCache(0, factory);
        LinkedDequeTests.assertNull((Object)ObjectTools.get((Object)factory, (String)"cacheHead"));
        queue.dequeueHead();
        this.verifyNodeCache(1, factory);
        queue.dequeueHead();
        this.verifyNodeCache(2, factory);
        queue.dequeueTail();
        this.verifyNodeCache(3, factory);
        queue.dequeueHead();
        this.verifyNodeCache(4, factory);
        queue.dequeueTail();
        this.verifyNodeCache(5, factory);
        queue.enqueueTail((Object)first);
        this.verifyNodeCache(4, factory);
        queue.enqueueTail((Object)second);
        this.verifyNodeCache(3, factory);
        queue.enqueueTail((Object)third);
        this.verifyNodeCache(2, factory);
        queue.enqueueTail((Object)fourth);
        this.verifyNodeCache(1, factory);
        queue.enqueueTail((Object)fifth);
        this.verifyNodeCache(0, factory);
    }

    public void verifyNodeCache(int size, Object factory) {
        LinkedDequeTests.assertEquals((int)size, (int)((Integer)ObjectTools.get((Object)factory, (String)"cacheSize")));
        int nodeCount = 0;
        Object node = ObjectTools.get((Object)factory, (String)"cacheHead");
        while (node != null) {
            ++nodeCount;
            node = ObjectTools.get((Object)node, (String)"next");
        }
        LinkedDequeTests.assertEquals((int)size, (int)nodeCount);
    }

    public void testNodeToString() {
        LinkedDeque queue = DequeTools.linkedDeque();
        String first = "first";
        String second = "second";
        String third = "third";
        queue.enqueueTail((Object)first);
        queue.enqueueTail((Object)second);
        queue.enqueueHead((Object)third);
        Object head = ObjectTools.get((Object)queue, (String)"head");
        LinkedDequeTests.assertTrue((boolean)head.toString().startsWith("LinkedDeque.Node"));
        LinkedDequeTests.assertTrue((boolean)head.toString().endsWith("(third)"));
    }

    public void testSimpleNodeFactoryToString() {
        LinkedDeque queue = DequeTools.linkedDeque();
        Object factory = ObjectTools.get((Object)queue, (String)"nodeFactory");
        LinkedDequeTests.assertEquals((String)"LinkedDeque.SimpleNodeFactory", (String)factory.toString());
    }

    public void testCachingNodeFactoryToString() {
        LinkedDeque queue = DequeTools.linkedDeque((int)20);
        Object factory = ObjectTools.get((Object)queue, (String)"nodeFactory");
        LinkedDequeTests.assertTrue((boolean)factory.toString().startsWith("LinkedDeque.CachingNodeFactory"));
        LinkedDequeTests.assertTrue((boolean)factory.toString().endsWith("(0)"));
    }

    public void testClone_caching() throws Exception {
        LinkedDeque original = DequeTools.linkedDeque((int)20);
        original.enqueueTail((Object)"first");
        LinkedDeque clone = original.clone();
        LinkedDequeTests.assertEquals((String)((String)original.peekHead()), (String)((String)clone.peekHead()));
        LinkedDequeTests.assertEquals((String)((String)original.dequeueHead()), (String)((String)clone.dequeueHead()));
        LinkedDequeTests.assertNotSame((Object)original, (Object)clone);
        LinkedDequeTests.assertTrue((boolean)original.isEmpty());
        LinkedDequeTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.enqueueTail((Object)"second");
        LinkedDequeTests.assertFalse((boolean)original.isEmpty());
        LinkedDequeTests.assertTrue((boolean)clone.isEmpty());
        Object factory = ObjectTools.get((Object)original, (String)"nodeFactory");
        LinkedDequeTests.assertTrue((boolean)factory.toString().startsWith("LinkedDeque.CachingNodeFactory"));
    }

    public void testSerialization_caching() throws Exception {
        LinkedDeque original = DequeTools.linkedDeque((int)20);
        original.enqueueTail((Object)"first");
        Deque clone = (Deque)TestTools.serialize(original);
        LinkedDequeTests.assertEquals((String)((String)original.peekHead()), (String)((String)clone.peekHead()));
        LinkedDequeTests.assertEquals((String)((String)original.dequeueHead()), (String)((String)clone.dequeueHead()));
        LinkedDequeTests.assertNotSame((Object)original, (Object)clone);
        LinkedDequeTests.assertTrue((boolean)original.isEmpty());
        LinkedDequeTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.enqueueTail((Object)"second");
        LinkedDequeTests.assertFalse((boolean)original.isEmpty());
        LinkedDequeTests.assertTrue((boolean)clone.isEmpty());
        Object factory = ObjectTools.get((Object)original, (String)"nodeFactory");
        LinkedDequeTests.assertTrue((boolean)factory.toString().startsWith("LinkedDeque.CachingNodeFactory"));
    }
}

