/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.eclipse.wst.jsdt.chromium.internal.transport.ChromeStub;
import org.eclipse.wst.jsdt.chromium.internal.transport.Connection;
import org.eclipse.wst.jsdt.chromium.internal.transport.Handshaker;
import org.eclipse.wst.jsdt.chromium.internal.transport.LineReader;
import org.eclipse.wst.jsdt.chromium.internal.transport.Message;
import org.junit.Assert;

public class FakeConnection
implements Connection {
    private boolean isRunning;
    private final ChromeStub responder;
    private Connection.NetListener netListener;
    public static final Handshaker.StandaloneV8 HANDSHAKER = new Handshaker.StandaloneV8(){
        private final FutureTask<Handshaker.StandaloneV8.RemoteInfo> remoteInfoFuture = new FutureTask<Handshaker.StandaloneV8.RemoteInfo>(new Callable<Handshaker.StandaloneV8.RemoteInfo>(){

            @Override
            public Handshaker.StandaloneV8.RemoteInfo call() throws Exception {
                return new Handshaker.StandaloneV8.RemoteInfo(){

                    public String getProtocolVersion() {
                        return "1";
                    }

                    public String getV8VmVersion() {
                        return "3.12.1 test fixture";
                    }

                    public String getEmbeddingHostName() {
                        return "junit test fixture";
                    }
                };
            }
        });
        {
            this.remoteInfoFuture.run();
        }

        public void perform(LineReader input, OutputStream output) throws IOException {
        }

        public Future<Handshaker.StandaloneV8.RemoteInfo> getRemoteInfo() {
            return this.remoteInfoFuture;
        }
    };

    public FakeConnection(ChromeStub responder) {
        this.responder = responder;
    }

    public void send(Message message) {
        Assert.assertTrue((boolean)this.isRunning);
        Assert.assertNotNull((Object)this.responder);
        Message response = this.responder.respondTo(message);
        if (response != null) {
            this.netListener.messageReceived(response);
        }
    }

    public void runInDispatchThread(Runnable callback) {
        callback.run();
    }

    public boolean isConnected() {
        return this.isRunning;
    }

    public void close() {
        boolean sendEos = this.isRunning;
        this.isRunning = false;
        if (this.netListener != null) {
            if (sendEos) {
                this.netListener.eosReceived();
            }
            this.netListener.connectionClosed();
        }
    }

    public void setNetListener(Connection.NetListener netListener) {
        this.netListener = netListener;
        this.responder.setNetListener(netListener);
    }

    public void start() throws IOException {
        this.isRunning = true;
    }
}

