/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.sync;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.DomTestUtils;
import org.eclipse.jst.ws.jaxws.testutils.dom.WaitingDomUtil;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;
import org.eclipse.jst.ws.jaxws.testutils.jobs.JobUtils;
import org.eclipse.jst.ws.jaxws.testutils.project.TestEjb3Project;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;

public class SynchronizationTestFixture
extends MockObjectTestCase {
    protected TestProject testPrj1;
    protected TestProject testPrj2;
    protected JaxWsWorkspaceResource target;
    protected IJavaModel javaModel;
    protected static final String prj1PckName = "com.sap.test.modelsync1";
    protected static final String prj2PckName = "com.sap.test.modelsync2";
    protected static final String ws1ImplName = "com.sap.test.modelsync1.WS1";
    protected static final String sei1ImplName = "com.sap.test.modelsync1.Sei1";
    protected static final String ws2ImplName = "com.sap.test.modelsync2.WS2";
    protected static final String sei2ImplName = "com.sap.test.modelsync2.Sei2";
    protected IWebServiceProject wsPrj1;
    protected IWebService ws1;
    protected IServiceEndpointInterface sei1;
    protected IWebServiceProject wsPrj2;
    protected IWebService ws2;
    protected IServiceEndpointInterface sei2;
    protected Collection<String> allowedProjects;
    protected DomUtil domUtil;
    protected DomTestUtils testUtil = new DomTestUtils();

    public void setUp() throws Exception {
        this.domUtil = new WaitingDomUtil();
        this.allowedProjects = new ArrayList<String>(3);
        this.javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.target = this.createTarget();
        this.testPrj1 = new TestProject(new TestEjb3Project("TestProject1").getProject());
        this.testPrj1.createSourceFolder("src");
        IPackageFragment modelSync1 = this.testPrj1.createPackage(prj1PckName);
        SynchronizationTestFixture.assertNotNull((String)"Java Model Error. Just created type not found in the java model", (Object)this.testPrj1.createType(modelSync1, "Sei1.java", "@javax.jws.WebService(name=\"Sei1Name\") public interface Sei1 {}"));
        SynchronizationTestFixture.assertNotNull((String)"Java Model Error. Just created type not found in the java model", (Object)this.testPrj1.createType(modelSync1, "WS1.java", "@javax.jws.WebService(serviceName=\"WS1Name\", endpointInterface=\"com.sap.test.modelsync1.Sei1\") public class WS1 {}"));
        this.testPrj2 = new TestProject(new TestEjb3Project("TestProject2").getProject());
        this.testPrj2.createSourceFolder("src");
        IPackageFragment modelSync2 = this.testPrj2.createPackage(prj2PckName);
        SynchronizationTestFixture.assertNotNull((String)"Java Model Error. Just created type not found in the java model", (Object)this.testPrj2.createType(modelSync2, "Sei2.java", "@javax.jws.WebService(name=\"Sei2Name\") public interface Sei2 {}"));
        SynchronizationTestFixture.assertNotNull((String)"Java Model Error. Just created type not found in the java model", (Object)this.testPrj2.createType(modelSync2, "WS2.java", "@javax.jws.WebService(serviceName=\"WS2Name\", endpointInterface=\"com.sap.test.modelsync1.Sei2\") public class WS2 {}"));
        this.allowedProjects.add(this.testPrj1.getJavaProject().getElementName());
        this.allowedProjects.add(this.testPrj2.getJavaProject().getElementName());
        JobUtils.waitForJobs();
        this.target.load(null);
        this.wsPrj1 = this.domUtil.findProjectByName(this.target.getDOM(), this.testPrj1.getJavaProject().getElementName());
        SynchronizationTestFixture.assertNotNull((Object)this.wsPrj1);
        SynchronizationTestFixture.assertEquals((int)1, (int)this.wsPrj1.getServiceEndpointInterfaces().size());
        SynchronizationTestFixture.assertEquals((int)1, (int)this.wsPrj1.getWebServices().size());
        this.ws1 = this.domUtil.findWsByImplName(this.wsPrj1, ws1ImplName);
        SynchronizationTestFixture.assertNotNull((Object)this.ws1);
        this.sei1 = this.domUtil.findSeiByImplName(this.wsPrj1, sei1ImplName);
        SynchronizationTestFixture.assertNotNull((Object)this.sei1);
        this.wsPrj2 = this.domUtil.findProjectByName(this.target.getDOM(), this.testPrj2.getJavaProject().getElementName());
        SynchronizationTestFixture.assertNotNull((Object)this.wsPrj2);
        SynchronizationTestFixture.assertEquals((int)1, (int)this.wsPrj2.getServiceEndpointInterfaces().size());
        SynchronizationTestFixture.assertEquals((int)1, (int)this.wsPrj2.getWebServices().size());
        this.ws2 = this.domUtil.findWsByImplName(this.wsPrj2, ws2ImplName);
        SynchronizationTestFixture.assertNotNull((Object)this.ws2);
        this.sei2 = this.domUtil.findSeiByImplName(this.wsPrj2, sei2ImplName);
        SynchronizationTestFixture.assertNotNull((Object)this.sei2);
    }

    public void beforeTestCase() throws CoreException {
        this.enableAutoBuild(ResourcesPlugin.getWorkspace(), false);
    }

    public void afterTestCase() throws CoreException {
        this.enableAutoBuild(ResourcesPlugin.getWorkspace(), true);
    }

    private void enableAutoBuild(IWorkspace ws, boolean enable) throws CoreException {
        IWorkspaceDescription desc = ws.getDescription();
        desc.setAutoBuilding(enable);
        ws.setDescription(desc);
    }

    protected Adapter findAdapter(EObject object, Class<?> clazz) {
        for (Adapter adapter : object.eAdapters()) {
            if (!adapter.isAdapterForType(clazz)) continue;
            return adapter;
        }
        return null;
    }

    public void tearDown() throws CoreException {
        this.target.stopSynchronizing();
        this.testPrj1.dispose();
        this.testPrj2.dispose();
    }

    private JaxWsWorkspaceResource createTarget() {
        return new JaxWsWorkspaceResource(this.javaModel){

            public boolean approveProject(IJavaProject prj) {
                for (String allowedPrj : SynchronizationTestFixture.this.allowedProjects) {
                    if (!prj.getElementName().equals(allowedPrj)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

