/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.internal;

import java.util.HashMap;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.web.ui.tests.internal.ProjectUtil;
import org.eclipse.wst.jsdt.web.ui.tests.internal.StringUtils;

public class TestProjectSetup
extends TestSetup {
    private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
    private static final String TESTING_RESOURCES_DIR = "testFiles";
    private String fPreviousWTPAutoTestNonInteractivePropValue = null;
    private final String fProjectName;
    private IProject fProject;
    private final String fRootDirictory;
    private final boolean fDeleteOnTearDown;
    private Map fFileToEditorMap = new HashMap();

    public TestProjectSetup(Test test, String projectName, String rootDirectory) {
        super(test);
        this.fProjectName = projectName;
        this.fRootDirictory = rootDirectory;
        this.fDeleteOnTearDown = false;
    }

    public TestProjectSetup(Test test, String projectName, String rootDirectory, boolean deleteOnTearDown) {
        super(test);
        this.fProjectName = projectName;
        this.fRootDirictory = rootDirectory;
        this.fDeleteOnTearDown = deleteOnTearDown;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public AbstractTextEditor getEditor(IFile file) {
        AbstractTextEditor editor = (AbstractTextEditor)this.fFileToEditorMap.get(file);
        if (editor == null) {
            try {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = workbenchWindow.getActivePage();
                IEditorPart editorPart = null;
                if (file.getFileExtension().equals("js")) {
                    editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true, (boolean)true);
                } else if (file.getFileExtension().equals("html")) {
                    editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"org.eclipse.wst.html.core.htmlsource.source", (boolean)true);
                }
                if (editorPart instanceof AbstractTextEditor) {
                    editor = (AbstractTextEditor)editorPart;
                } else {
                    Assert.fail((String)"Unable to open structured text editor");
                }
                if (editor != null) {
                    TestProjectSetup.standardizeLineEndings((ITextEditor)editor);
                    this.fFileToEditorMap.put(file, editor);
                } else {
                    Assert.fail((String)("Could not open editor for " + file));
                }
            }
            catch (Exception e) {
                Assert.fail((String)("Could not open editor for " + file + " exception: " + e.getMessage()));
            }
        }
        return editor;
    }

    public IFile getFile(String path) {
        IFile file = null;
        file = this.fRootDirictory != null ? this.fProject.getFile(String.valueOf(this.fRootDirictory) + '/' + path) : this.fProject.getFile(path);
        Assert.assertTrue((String)("Test file " + file + " can not be found"), (boolean)file.exists());
        return file;
    }

    public void editFile(String fileName, int lineNum, int lineRelativeCharOffset, int length, String text) throws Exception {
        IFile file = this.getFile(fileName);
        AbstractTextEditor editor = this.getEditor(file);
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        int offset = doc.getLineOffset(lineNum) + lineRelativeCharOffset;
        doc.replace(offset, length, text);
        TestProjectSetup.waitForIndexManager();
    }

    public void additionalSetUp() throws Exception {
    }

    public final void setUp() throws Exception {
        String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
        this.fPreviousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
        System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.fProject = root.getProject(this.fProjectName);
        if (this.fProject == null || !this.fProject.exists()) {
            this.fProject = ProjectUtil.createProject(this.fProjectName, null, null);
            ProjectUtil.copyBundleEntriesIntoWorkspace("testFiles/" + this.fProjectName, String.valueOf('/') + this.fProjectName);
        }
        this.additionalSetUp();
        Thread.sleep(1000L);
        TestProjectSetup.waitForIndexManager();
    }

    public void tearDown() throws Exception {
        for (AbstractTextEditor editor : this.fFileToEditorMap.values()) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)editor, false);
        }
        this.fFileToEditorMap.clear();
        if (this.fDeleteOnTearDown) {
            this.fProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (this.fPreviousWTPAutoTestNonInteractivePropValue != null) {
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, this.fPreviousWTPAutoTestNonInteractivePropValue);
        }
    }

    private static void standardizeLineEndings(ITextEditor editor) {
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        String contents = doc.get();
        contents = StringUtils.replace(contents, "\r\n", "\n");
        contents = StringUtils.replace(contents, "\r", "\n");
        doc.set(contents);
    }

    private static void waitForIndexManager() {
        TestProjectSetup.waitForIndexManager(10000L);
    }

    private static void waitForIndexManager(long max) {
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        long maxWaits = max / 10L;
        while (indexManager.awaitingJobsCount() > 0 && maxWaits-- > 0L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

