/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.describing;

import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingTest;

public class ASTRewritingMoveCodeTest
extends ASTRewritingTest {
    private static final Class THIS = ASTRewritingMoveCodeTest.class;

    public ASTRewritingMoveCodeTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test setUpTest(Test someTest) {
        SuiteOfTestCases.Suite suite = new SuiteOfTestCases.Suite("one test");
        suite.addTest(someTest);
        return suite;
    }

    public static Test suite() {
        return ASTRewritingMoveCodeTest.allTests();
    }

    public void testMove() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    int x;\n");
        buf.append("    public void foo() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        List bodyDecls = type.bodyDeclarations();
        ASTNode first = (ASTNode)bodyDecls.get(0);
        ASTNode placeholder = rewrite.createMoveTarget(first);
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertLast(placeholder, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("    }\n");
        buf.append("    int x;\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testMoveDeclSameLevelCD() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E extends Exception implements Runnable, Serializable {\n");
        buf.append("    public static class EInner {\n");
        buf.append("        public void xee() {\n");
        buf.append("            /* does nothing */\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    private /* inner comment */ int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("        super();\n");
        buf.append("        i= 0;\n");
        buf.append("        k= 9;\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            gee(); // cool\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface G {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        List members = type.bodyDeclarations();
        ASTRewritingMoveCodeTest.assertTrue((String)"Has declarations", (!members.isEmpty() ? 1 : 0) != 0);
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find inner class", (boolean)(members.get(0) instanceof TypeDeclaration));
        TypeDeclaration innerType = (TypeDeclaration)members.get(0);
        rewrite.remove((ASTNode)innerType, null);
        ASTNode movedNode = rewrite.createCopyTarget((ASTNode)innerType);
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertLast(movedNode, null);
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "E");
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find Constructor E", (methodDecl != null ? 1 : 0) != 0);
        Block body = methodDecl.getBody();
        ASTRewritingMoveCodeTest.assertTrue((String)"No body", (body != null ? 1 : 0) != 0);
        List statements = body.statements();
        ASTRewritingMoveCodeTest.assertTrue((String)"Not expected number of statements", (statements.size() == 4 ? 1 : 0) != 0);
        Statement toMove = (Statement)statements.get(1);
        Statement toCopy = (Statement)statements.get(3);
        rewrite.remove((ASTNode)toMove, null);
        methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "gee");
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find gee()", (methodDecl != null ? 1 : 0) != 0);
        body = methodDecl.getBody();
        ASTRewritingMoveCodeTest.assertTrue((String)"No body", (body != null ? 1 : 0) != 0);
        statements = body.statements();
        ASTRewritingMoveCodeTest.assertTrue((String)"Has statements", (boolean)statements.isEmpty());
        ASTNode insertNodeForMove = rewrite.createCopyTarget((ASTNode)toMove);
        ASTNode insertNodeForCopy = rewrite.createCopyTarget((ASTNode)toCopy);
        rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY).insertLast(insertNodeForCopy, null);
        rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY).insertLast(insertNodeForMove, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E extends Exception implements Runnable, Serializable {\n");
        buf.append("    private /* inner comment */ int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("        super();\n");
        buf.append("        k= 9;\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            gee(); // cool\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            gee(); // cool\n");
        buf.append("        }\n");
        buf.append("        i= 0;\n");
        buf.append("    }\n");
        buf.append("    public static class EInner {\n");
        buf.append("        public void xee() {\n");
        buf.append("            /* does nothing */\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface G {\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testMoveDeclSameLevel() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E extends Exception implements Runnable, Serializable {\n");
        buf.append("    public static class EInner {\n");
        buf.append("        public void xee() {\n");
        buf.append("            /* does nothing */\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    private /* inner comment */ int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("        super();\n");
        buf.append("        i= 0;\n");
        buf.append("        k= 9;\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            gee(); // cool\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface G {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        List members = type.bodyDeclarations();
        ASTRewritingMoveCodeTest.assertTrue((String)"Has declarations", (!members.isEmpty() ? 1 : 0) != 0);
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find inner class", (boolean)(members.get(0) instanceof TypeDeclaration));
        TypeDeclaration innerType = (TypeDeclaration)members.get(0);
        ASTNode movedNode = rewrite.createMoveTarget((ASTNode)innerType);
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertLast(movedNode, null);
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "E");
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find Constructor E", (methodDecl != null ? 1 : 0) != 0);
        Block body = methodDecl.getBody();
        ASTRewritingMoveCodeTest.assertTrue((String)"No body", (body != null ? 1 : 0) != 0);
        List statements = body.statements();
        ASTRewritingMoveCodeTest.assertTrue((String)"Not expected number of statements", (statements.size() == 4 ? 1 : 0) != 0);
        Statement toMove = (Statement)statements.get(1);
        Statement toCopy = (Statement)statements.get(3);
        methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "gee");
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find gee()", (methodDecl != null ? 1 : 0) != 0);
        body = methodDecl.getBody();
        ASTRewritingMoveCodeTest.assertTrue((String)"No body", (body != null ? 1 : 0) != 0);
        statements = body.statements();
        ASTRewritingMoveCodeTest.assertTrue((String)"Has statements", (boolean)statements.isEmpty());
        ASTNode insertNodeForMove = rewrite.createMoveTarget((ASTNode)toMove);
        ASTNode insertNodeForCopy = rewrite.createCopyTarget((ASTNode)toCopy);
        rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY).insertLast(insertNodeForCopy, null);
        rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY).insertLast(insertNodeForMove, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E extends Exception implements Runnable, Serializable {\n");
        buf.append("    private /* inner comment */ int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("        super();\n");
        buf.append("        k= 9;\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            gee(); // cool\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            gee(); // cool\n");
        buf.append("        }\n");
        buf.append("        i= 0;\n");
        buf.append("    }\n");
        buf.append("    public static class EInner {\n");
        buf.append("        public void xee() {\n");
        buf.append("            /* does nothing */\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface G {\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testMoveDeclDifferentLevelCD() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E extends Exception implements Runnable, Serializable {\n");
        buf.append("    public static class EInner {\n");
        buf.append("        public void xee() {\n");
        buf.append("            /* does nothing */\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    private /* inner comment */ int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("        super();\n");
        buf.append("        i= 0;\n");
        buf.append("        k= 9;\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            gee(); // cool\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface G {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        List members = type.bodyDeclarations();
        ASTRewritingMoveCodeTest.assertTrue((String)"Has declarations", (!members.isEmpty() ? 1 : 0) != 0);
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find inner class", (boolean)(members.get(0) instanceof TypeDeclaration));
        TypeDeclaration innerType = (TypeDeclaration)members.get(0);
        List innerMembers = innerType.bodyDeclarations();
        ASTRewritingMoveCodeTest.assertTrue((String)"Not expected number of inner members", (innerMembers.size() == 1 ? 1 : 0) != 0);
        TypeDeclaration outerType = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "G");
        ASTRewritingMoveCodeTest.assertTrue((String)"G not found", (outerType != null ? 1 : 0) != 0);
        rewrite.remove((ASTNode)outerType, null);
        ASTNode insertNodeForCopy = rewrite.createCopyTarget((ASTNode)outerType);
        rewrite.getListRewrite((ASTNode)innerType, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertLast(insertNodeForCopy, null);
        FunctionDeclaration methodDecl = (FunctionDeclaration)innerMembers.get(0);
        ASTNode insertNodeForMove = rewrite.createCopyTarget((ASTNode)methodDecl);
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertLast(insertNodeForMove, null);
        methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "E");
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find Constructor E", (methodDecl != null ? 1 : 0) != 0);
        Block body = methodDecl.getBody();
        WhileStatement whileStatement = ast.newWhileStatement();
        whileStatement.setExpression((Expression)ast.newBooleanLiteral(true));
        Statement insertNodeForCopy2 = (Statement)rewrite.createCopyTarget((ASTNode)body);
        whileStatement.setBody(insertNodeForCopy2);
        Block newBody = ast.newBlock();
        List newStatements = newBody.statements();
        newStatements.add(whileStatement);
        rewrite.replace((ASTNode)body, (ASTNode)newBody, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E extends Exception implements Runnable, Serializable {\n");
        buf.append("    public static class EInner {\n");
        buf.append("        public void xee() {\n");
        buf.append("            /* does nothing */\n");
        buf.append("        }\n");
        buf.append("\n");
        buf.append("        interface G {\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    private /* inner comment */ int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("        while (true) {\n");
        buf.append("            super();\n");
        buf.append("            i= 0;\n");
        buf.append("            k= 9;\n");
        buf.append("            if (System.out == null) {\n");
        buf.append("                gee(); // cool\n");
        buf.append("            }\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("    public void xee() {\n");
        buf.append("        /* does nothing */\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testMoveDeclDifferentLevel() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E extends Exception implements Runnable, Serializable {\n");
        buf.append("    public static class EInner {\n");
        buf.append("        public void xee() {\n");
        buf.append("            /* does nothing */\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    private /* inner comment */ int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("        super();\n");
        buf.append("        i= 0;\n");
        buf.append("        k= 9;\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            gee(); // cool\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface G {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        List members = type.bodyDeclarations();
        ASTRewritingMoveCodeTest.assertTrue((String)"Has declarations", (!members.isEmpty() ? 1 : 0) != 0);
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find inner class", (boolean)(members.get(0) instanceof TypeDeclaration));
        TypeDeclaration innerType = (TypeDeclaration)members.get(0);
        List innerMembers = innerType.bodyDeclarations();
        ASTRewritingMoveCodeTest.assertTrue((String)"Not expected number of inner members", (innerMembers.size() == 1 ? 1 : 0) != 0);
        TypeDeclaration outerType = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "G");
        ASTRewritingMoveCodeTest.assertTrue((String)"G not found", (outerType != null ? 1 : 0) != 0);
        ASTNode insertNodeForCopy = rewrite.createMoveTarget((ASTNode)outerType);
        rewrite.getListRewrite((ASTNode)innerType, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertLast(insertNodeForCopy, null);
        FunctionDeclaration methodDecl = (FunctionDeclaration)innerMembers.get(0);
        ASTNode insertNodeForMove = rewrite.createCopyTarget((ASTNode)methodDecl);
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertLast(insertNodeForMove, null);
        methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "E");
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find Constructor E", (methodDecl != null ? 1 : 0) != 0);
        Block body = methodDecl.getBody();
        WhileStatement whileStatement = ast.newWhileStatement();
        whileStatement.setExpression((Expression)ast.newBooleanLiteral(true));
        Statement insertNodeForCopy2 = (Statement)rewrite.createCopyTarget((ASTNode)body);
        whileStatement.setBody(insertNodeForCopy2);
        Block newBody = ast.newBlock();
        List newStatements = newBody.statements();
        newStatements.add(whileStatement);
        rewrite.replace((ASTNode)body, (ASTNode)newBody, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E extends Exception implements Runnable, Serializable {\n");
        buf.append("    public static class EInner {\n");
        buf.append("        public void xee() {\n");
        buf.append("            /* does nothing */\n");
        buf.append("        }\n");
        buf.append("\n");
        buf.append("        interface G {\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    private /* inner comment */ int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("        while (true) {\n");
        buf.append("            super();\n");
        buf.append("            i= 0;\n");
        buf.append("            k= 9;\n");
        buf.append("            if (System.out == null) {\n");
        buf.append("                gee(); // cool\n");
        buf.append("            }\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("    public void xee() {\n");
        buf.append("        /* does nothing */\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testMoveStatementsCD() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E extends Exception implements Runnable, Serializable {\n");
        buf.append("    public static class EInner {\n");
        buf.append("        public void xee() {\n");
        buf.append("            /* does nothing */\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    private /* inner comment */ int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("        super();\n");
        buf.append("        i= 0;\n");
        buf.append("        k= 9;\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            gee(); // cool\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface G {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "E");
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find Constructor E", (methodDecl != null ? 1 : 0) != 0);
        Block body = methodDecl.getBody();
        List statements = body.statements();
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find if statement", (boolean)(statements.get(3) instanceof IfStatement));
        IfStatement ifStatement = (IfStatement)statements.get(3);
        Statement insertNodeForCopy1 = (Statement)rewrite.createCopyTarget((ASTNode)statements.get(1));
        Statement insertNodeForCopy2 = (Statement)rewrite.createCopyTarget((ASTNode)statements.get(2));
        Block whileBody = ast.newBlock();
        WhileStatement whileStatement = ast.newWhileStatement();
        whileStatement.setExpression((Expression)ast.newBooleanLiteral(true));
        whileStatement.setBody((Statement)whileBody);
        List whileBodyStatements = whileBody.statements();
        whileBodyStatements.add(insertNodeForCopy2);
        ASTRewritingMoveCodeTest.assertTrue((String)"if statement body not a block", (boolean)(ifStatement.getThenStatement() instanceof Block));
        Block block = (Block)ifStatement.getThenStatement();
        rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertFirst((ASTNode)whileStatement, null);
        rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertAfter((ASTNode)insertNodeForCopy1, (ASTNode)whileStatement, null);
        rewrite.remove((ASTNode)statements.get(1), null);
        rewrite.remove((ASTNode)statements.get(2), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E extends Exception implements Runnable, Serializable {\n");
        buf.append("    public static class EInner {\n");
        buf.append("        public void xee() {\n");
        buf.append("            /* does nothing */\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    private /* inner comment */ int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("        super();\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            while (true) {\n");
        buf.append("                k= 9;\n");
        buf.append("            }\n");
        buf.append("            i= 0;\n");
        buf.append("            gee(); // cool\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface G {\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testMoveStatements() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E extends Exception implements Runnable, Serializable {\n");
        buf.append("    private /* inner comment */ int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("        super();\n");
        buf.append("        i= 0;\n");
        buf.append("        k= 9;\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            gee(); // cool\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface G {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "E");
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find Constructor E", (methodDecl != null ? 1 : 0) != 0);
        Block body = methodDecl.getBody();
        List statements = body.statements();
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find if statement", (boolean)(statements.get(3) instanceof IfStatement));
        IfStatement ifStatement = (IfStatement)statements.get(3);
        Statement insertNodeForCopy1 = (Statement)rewrite.createMoveTarget((ASTNode)statements.get(1));
        Statement insertNodeForCopy2 = (Statement)rewrite.createMoveTarget((ASTNode)statements.get(2));
        Block whileBody = ast.newBlock();
        WhileStatement whileStatement = ast.newWhileStatement();
        whileStatement.setExpression((Expression)ast.newBooleanLiteral(true));
        whileStatement.setBody((Statement)whileBody);
        List whileBodyStatements = whileBody.statements();
        whileBodyStatements.add(insertNodeForCopy2);
        ASTRewritingMoveCodeTest.assertTrue((String)"if statement body not a block", (boolean)(ifStatement.getThenStatement() instanceof Block));
        Block block = (Block)ifStatement.getThenStatement();
        rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertFirst((ASTNode)whileStatement, null);
        rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertAfter((ASTNode)insertNodeForCopy1, (ASTNode)whileStatement, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E extends Exception implements Runnable, Serializable {\n");
        buf.append("    private /* inner comment */ int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("        super();\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            while (true) {\n");
        buf.append("                k= 9;\n");
        buf.append("            }\n");
        buf.append("            i= 0;\n");
        buf.append("            gee(); // cool\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface G {\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testCopyFromDeleted() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            gee(); // cool\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    public void goo() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find foo", (methodDecl != null ? 1 : 0) != 0);
        rewrite.remove((ASTNode)methodDecl, null);
        Block body = methodDecl.getBody();
        List statements = body.statements();
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find if statement", (statements.size() == 1 ? 1 : 0) != 0);
        ASTNode placeHolder = rewrite.createMoveTarget((ASTNode)statements.get(0));
        FunctionDeclaration methodGoo = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "goo");
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find goo", (methodGoo != null ? 1 : 0) != 0);
        rewrite.getListRewrite((ASTNode)methodGoo.getBody(), Block.STATEMENTS_PROPERTY).insertLast(placeHolder, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void goo() {\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            gee(); // cool\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testChangesInMoveCD() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            gee( /* cool */);\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    public void goo() {\n");
        buf.append("        x= 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find foo", (methodDecl != null ? 1 : 0) != 0);
        List fooStatements = methodDecl.getBody().statements();
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find if statement", (fooStatements.size() == 1 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)fooStatements.get(0);
        rewrite.remove((ASTNode)ifStatement, null);
        ASTNode placeHolder = rewrite.createCopyTarget((ASTNode)ifStatement);
        ReturnStatement returnStatement = ast.newReturnStatement();
        Block then = (Block)ifStatement.getThenStatement();
        rewrite.getListRewrite((ASTNode)then, Block.STATEMENTS_PROPERTY).insertLast((ASTNode)returnStatement, null);
        FunctionDeclaration methodGoo = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "goo");
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find goo", (methodGoo != null ? 1 : 0) != 0);
        List gooStatements = methodGoo.getBody().statements();
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find statement in goo", (gooStatements.size() == 1 ? 1 : 0) != 0);
        rewrite.replace((ASTNode)gooStatements.get(0), placeHolder, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("    }\n");
        buf.append("    public void goo() {\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            gee( /* cool */);\n");
        buf.append("            return;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testChangesInMove() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            gee( /* cool */);\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    public void goo() {\n");
        buf.append("        x= 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find foo", (methodDecl != null ? 1 : 0) != 0);
        List fooStatements = methodDecl.getBody().statements();
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find if statement", (fooStatements.size() == 1 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)fooStatements.get(0);
        ASTNode placeHolder = rewrite.createMoveTarget((ASTNode)ifStatement);
        ReturnStatement returnStatement = ast.newReturnStatement();
        Block then = (Block)ifStatement.getThenStatement();
        rewrite.getListRewrite((ASTNode)then, Block.STATEMENTS_PROPERTY).insertLast((ASTNode)returnStatement, null);
        FunctionDeclaration methodGoo = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "goo");
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find goo", (methodGoo != null ? 1 : 0) != 0);
        List gooStatements = methodGoo.getBody().statements();
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find statement in goo", (gooStatements.size() == 1 ? 1 : 0) != 0);
        rewrite.replace((ASTNode)gooStatements.get(0), placeHolder, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("    }\n");
        buf.append("    public void goo() {\n");
        buf.append("        if (System.out == null) {\n");
        buf.append("            gee( /* cool */);\n");
        buf.append("            return;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testSwapCD() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        goo(xoo(/*hello*/), k * 2);\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find foo", (methodDecl != null ? 1 : 0) != 0);
        List fooStatements = methodDecl.getBody().statements();
        ASTRewritingMoveCodeTest.assertTrue((String)"More statements than expected", (fooStatements.size() == 1 ? 1 : 0) != 0);
        ExpressionStatement statement = (ExpressionStatement)fooStatements.get(0);
        FunctionInvocation invocation = (FunctionInvocation)statement.getExpression();
        List arguments = invocation.arguments();
        ASTRewritingMoveCodeTest.assertTrue((String)"More arguments than expected", (arguments.size() == 2 ? 1 : 0) != 0);
        ASTNode arg0 = (ASTNode)arguments.get(0);
        ASTNode arg1 = (ASTNode)arguments.get(1);
        ASTNode placeHolder0 = rewrite.createCopyTarget(arg0);
        ASTNode placeHolder1 = rewrite.createCopyTarget(arg1);
        rewrite.replace(arg0, placeHolder1, null);
        rewrite.replace(arg1, placeHolder0, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        goo(k * 2, xoo(/*hello*/));\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testSwap() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        goo(xoo(/*hello*/), k * 2);\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        ASTRewritingMoveCodeTest.assertTrue((String)"Cannot find foo", (methodDecl != null ? 1 : 0) != 0);
        List fooStatements = methodDecl.getBody().statements();
        ASTRewritingMoveCodeTest.assertTrue((String)"More statements than expected", (fooStatements.size() == 1 ? 1 : 0) != 0);
        ExpressionStatement statement = (ExpressionStatement)fooStatements.get(0);
        FunctionInvocation invocation = (FunctionInvocation)statement.getExpression();
        List arguments = invocation.arguments();
        ASTRewritingMoveCodeTest.assertTrue((String)"More arguments than expected", (arguments.size() == 2 ? 1 : 0) != 0);
        ASTNode arg0 = (ASTNode)arguments.get(0);
        ASTNode arg1 = (ASTNode)arguments.get(1);
        ASTNode placeHolder0 = rewrite.createMoveTarget(arg0);
        ASTNode placeHolder1 = rewrite.createMoveTarget(arg1);
        rewrite.replace(arg0, placeHolder1, null);
        rewrite.replace(arg1, placeHolder0, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        goo(k * 2, xoo(/*hello*/));\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testMultipleCopiesOfSameNode() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            foo();\n");
        buf.append("            i++; // comment\n");
        buf.append("            i++;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        List statements = methodDecl.getBody().statements();
        IfStatement ifStatement = (IfStatement)statements.get(0);
        List ifStatementBody = ((Block)ifStatement.getThenStatement()).statements();
        ASTNode node = (ASTNode)ifStatementBody.get(1);
        ASTNode placeholder1 = rewrite.createCopyTarget(node);
        rewrite.getListRewrite((ASTNode)methodDecl.getBody(), Block.STATEMENTS_PROPERTY).insertLast(placeholder1, null);
        ASTNode placeholder2 = rewrite.createCopyTarget(node);
        rewrite.replace((ASTNode)ifStatementBody.get(0), placeholder2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            i++; // comment\n");
        buf.append("            i++; // comment\n");
        buf.append("            i++;\n");
        buf.append("        }\n");
        buf.append("        i++; // comment\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testCopyMultipleNodes() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            foo();\n");
        buf.append("            i++; // comment\n");
        buf.append("            i++;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        List statements = methodDecl.getBody().statements();
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Block thenBlock = (Block)ifStatement.getThenStatement();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)thenBlock, Block.STATEMENTS_PROPERTY);
        List thenStatements = thenBlock.statements();
        ASTNode first = (ASTNode)thenStatements.get(0);
        ASTNode last = (ASTNode)thenStatements.get(1);
        ASTNode placeholder = listRewrite.createCopyTarget(first, last);
        rewrite.getListRewrite((ASTNode)methodDecl.getBody(), Block.STATEMENTS_PROPERTY).insertLast(placeholder, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            foo();\n");
        buf.append("            i++; // comment\n");
        buf.append("            i++;\n");
        buf.append("        }\n");
        buf.append("        foo();\n");
        buf.append("        i++; // comment\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testCopyMultipleNodes0() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            foo();\n");
        buf.append("            i++; // comment\n");
        buf.append("            i++;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        List statements = methodDecl.getBody().statements();
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Block thenBlock = (Block)ifStatement.getThenStatement();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)thenBlock, Block.STATEMENTS_PROPERTY);
        List thenStatements = thenBlock.statements();
        ASTNode first = (ASTNode)thenStatements.get(0);
        ASTNode second = (ASTNode)thenStatements.get(1);
        ASTNode placeholder = listRewrite.createCopyTarget(first, second);
        AST ast = astRoot.getAST();
        PrefixExpression expression = ast.newPrefixExpression();
        expression.setOperand((Expression)ast.newSimpleName("i"));
        expression.setOperator(PrefixExpression.Operator.DECREMENT);
        ExpressionStatement newStatement = ast.newExpressionStatement((Expression)expression);
        listRewrite.replace(first, (ASTNode)newStatement, null);
        rewrite.getListRewrite((ASTNode)methodDecl.getBody(), Block.STATEMENTS_PROPERTY).insertLast(placeholder, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            --i;\n");
        buf.append("            i++; // comment\n");
        buf.append("            i++;\n");
        buf.append("        }\n");
        buf.append("        --i;\n");
        buf.append("        i++; // comment\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testCopyMultipleNodes1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            foo();\n");
        buf.append("            i++; // comment\n");
        buf.append("            i++;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        List statements = methodDecl.getBody().statements();
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Block thenBlock = (Block)ifStatement.getThenStatement();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)thenBlock, Block.STATEMENTS_PROPERTY);
        List thenStatements = thenBlock.statements();
        ASTNode first = (ASTNode)thenStatements.get(0);
        ASTNode second = (ASTNode)thenStatements.get(1);
        ASTNode placeholder = listRewrite.createCopyTarget(first, second);
        AST ast = astRoot.getAST();
        PrefixExpression expression = ast.newPrefixExpression();
        expression.setOperand((Expression)ast.newSimpleName("i"));
        expression.setOperator(PrefixExpression.Operator.DECREMENT);
        ExpressionStatement newStatement = ast.newExpressionStatement((Expression)expression);
        listRewrite.insertAfter((ASTNode)newStatement, first, null);
        listRewrite.remove((ASTNode)thenStatements.get(2), null);
        rewrite.getListRewrite((ASTNode)methodDecl.getBody(), Block.STATEMENTS_PROPERTY).insertLast(placeholder, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            foo();\n");
        buf.append("            --i;\n");
        buf.append("            i++; // comment\n");
        buf.append("        }\n");
        buf.append("        foo();\n");
        buf.append("        --i;\n");
        buf.append("        i++; // comment\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testCopyMultipleNodes2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            foo(1);\n");
        buf.append("            foo(2); // comment\n");
        buf.append("            foo(3);\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        List statements = methodDecl.getBody().statements();
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Block thenBlock = (Block)ifStatement.getThenStatement();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)thenBlock, Block.STATEMENTS_PROPERTY);
        List thenStatements = thenBlock.statements();
        ASTNode second = (ASTNode)thenStatements.get(1);
        ASTNode last = (ASTNode)thenStatements.get(2);
        ASTNode placeholder1 = listRewrite.createCopyTarget(second, last);
        rewrite.replace((ASTNode)ifStatement, placeholder1, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        foo(2); // comment\n");
        buf.append("        foo(3);\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testCopyMultipleNodes3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            foo(1);\n");
        buf.append("            foo(2);\n");
        buf.append("            foo(3);\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        List statements = methodDecl.getBody().statements();
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Block thenBlock = (Block)ifStatement.getThenStatement();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)thenBlock, Block.STATEMENTS_PROPERTY);
        List thenStatements = thenBlock.statements();
        ASTNode first = (ASTNode)thenStatements.get(0);
        ASTNode second = (ASTNode)thenStatements.get(1);
        ASTNode last = (ASTNode)thenStatements.get(2);
        ASTNode placeholder1 = listRewrite.createCopyTarget(first, second);
        ASTNode placeholder2 = listRewrite.createCopyTarget(first, last);
        listRewrite.insertAfter(placeholder1, last, null);
        rewrite.getListRewrite((ASTNode)methodDecl.getBody(), Block.STATEMENTS_PROPERTY).insertLast(placeholder2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            foo(1);\n");
        buf.append("            foo(2);\n");
        buf.append("            foo(3);\n");
        buf.append("            foo(1);\n");
        buf.append("            foo(2);\n");
        buf.append("        }\n");
        buf.append("        foo(1);\n");
        buf.append("        foo(2);\n");
        buf.append("        foo(3);\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testCopyMultipleNodes4() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            foo(1);\n");
        buf.append("            foo(2);\n");
        buf.append("            foo(3);\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        List statements = methodDecl.getBody().statements();
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Block thenBlock = (Block)ifStatement.getThenStatement();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)thenBlock, Block.STATEMENTS_PROPERTY);
        List thenStatements = thenBlock.statements();
        ASTNode first = (ASTNode)thenStatements.get(0);
        ASTNode second = (ASTNode)thenStatements.get(1);
        ASTNode last = (ASTNode)thenStatements.get(2);
        ASTNode placeholder1 = listRewrite.createCopyTarget(first, last);
        ASTNode placeholder2 = listRewrite.createCopyTarget(first, second);
        ASTNode placeholder3 = rewrite.createMoveTarget(first);
        listRewrite.insertAfter(placeholder1, last, null);
        rewrite.getListRewrite((ASTNode)methodDecl.getBody(), Block.STATEMENTS_PROPERTY).insertLast(placeholder2, null);
        rewrite.getListRewrite((ASTNode)methodDecl.getBody(), Block.STATEMENTS_PROPERTY).insertFirst(placeholder3, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        foo(1);\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            foo(2);\n");
        buf.append("            foo(3);\n");
        buf.append("            foo(2);\n");
        buf.append("            foo(3);\n");
        buf.append("        }\n");
        buf.append("        foo(2);\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testMultipleCopiesOfSameNodeAndMove() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            foo();\n");
        buf.append("            i++; // comment\n");
        buf.append("            i++;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        List statements = methodDecl.getBody().statements();
        IfStatement ifStatement = (IfStatement)statements.get(0);
        List ifStatementBody = ((Block)ifStatement.getThenStatement()).statements();
        ASTNode node = (ASTNode)ifStatementBody.get(1);
        ASTNode placeholder1 = rewrite.createCopyTarget(node);
        rewrite.getListRewrite((ASTNode)methodDecl.getBody(), Block.STATEMENTS_PROPERTY).insertLast(placeholder1, null);
        ASTNode placeholder2 = rewrite.createCopyTarget(node);
        rewrite.replace((ASTNode)ifStatementBody.get(0), placeholder2, null);
        ASTNode placeholder3 = rewrite.createMoveTarget(node);
        rewrite.getListRewrite((ASTNode)methodDecl.getBody(), Block.STATEMENTS_PROPERTY).insertFirst(placeholder3, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        i++; // comment\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            i++; // comment\n");
        buf.append("            i++;\n");
        buf.append("        }\n");
        buf.append("        i++; // comment\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testMoveMultipleNodes() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            foo();\n");
        buf.append("            i++; // comment\n");
        buf.append("            i++;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        List statements = methodDecl.getBody().statements();
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Block thenBlock = (Block)ifStatement.getThenStatement();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)thenBlock, Block.STATEMENTS_PROPERTY);
        List thenStatements = thenBlock.statements();
        ASTNode first = (ASTNode)thenStatements.get(0);
        ASTNode last = (ASTNode)thenStatements.get(1);
        ASTNode placeholder = listRewrite.createMoveTarget(first, last);
        rewrite.getListRewrite((ASTNode)methodDecl.getBody(), Block.STATEMENTS_PROPERTY).insertLast(placeholder, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            i++;\n");
        buf.append("        }\n");
        buf.append("        foo();\n");
        buf.append("        i++; // comment\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testMoveMultipleNodes2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            foo();\n");
        buf.append("            i++; // comment\n");
        buf.append("            i++;\n");
        buf.append("            i--;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        List statements = methodDecl.getBody().statements();
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Block thenBlock = (Block)ifStatement.getThenStatement();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)thenBlock, Block.STATEMENTS_PROPERTY);
        List thenStatements = thenBlock.statements();
        ASTNode first1 = (ASTNode)thenStatements.get(0);
        ASTNode last1 = (ASTNode)thenStatements.get(1);
        ASTNode placeholder1 = listRewrite.createMoveTarget(first1, last1);
        ASTNode first2 = (ASTNode)thenStatements.get(2);
        ASTNode last2 = (ASTNode)thenStatements.get(3);
        ASTNode placeholder2 = listRewrite.createMoveTarget(first2, last2);
        rewrite.getListRewrite((ASTNode)methodDecl.getBody(), Block.STATEMENTS_PROPERTY).insertFirst(placeholder1, null);
        rewrite.getListRewrite((ASTNode)methodDecl.getBody(), Block.STATEMENTS_PROPERTY).insertLast(placeholder2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        foo();\n");
        buf.append("        i++; // comment\n");
        buf.append("        if (i == 0) {\n");
        buf.append("        }\n");
        buf.append("        i++;\n");
        buf.append("        i--;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testMoveMultipleNodes3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            foo();\n");
        buf.append("            i++; // comment\n");
        buf.append("            i++;\n");
        buf.append("            i--;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        List statements = methodDecl.getBody().statements();
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Block thenBlock = (Block)ifStatement.getThenStatement();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)thenBlock, Block.STATEMENTS_PROPERTY);
        List thenStatements = thenBlock.statements();
        ASTNode first = (ASTNode)thenStatements.get(0);
        ASTNode between = (ASTNode)thenStatements.get(1);
        ASTNode last = (ASTNode)thenStatements.get(3);
        ASTNode placeholder1 = listRewrite.createMoveTarget(first, last);
        ASTNode placeholder2 = listRewrite.createCopyTarget(first, between);
        rewrite.replace((ASTNode)ifStatement, placeholder1, null);
        rewrite.getListRewrite((ASTNode)methodDecl.getBody(), Block.STATEMENTS_PROPERTY).insertFirst(placeholder2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        foo();\n");
        buf.append("        i++; // comment\n");
        buf.append("        foo();\n");
        buf.append("        i++; // comment\n");
        buf.append("        i++;\n");
        buf.append("        i--;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testMoveMultipleNodes4() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            foo();\n");
        buf.append("            i++; // comment\n");
        buf.append("            i++;\n");
        buf.append("            i--;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        List statements = methodDecl.getBody().statements();
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Block thenBlock = (Block)ifStatement.getThenStatement();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)thenBlock, Block.STATEMENTS_PROPERTY);
        List thenStatements = thenBlock.statements();
        ASTNode first1 = (ASTNode)thenStatements.get(0);
        ASTNode last1 = (ASTNode)thenStatements.get(2);
        listRewrite.createMoveTarget(first1, last1);
        ASTNode first2 = (ASTNode)thenStatements.get(2);
        ASTNode last2 = (ASTNode)thenStatements.get(3);
        try {
            listRewrite.createMoveTarget(first2, last2);
            ASTRewritingMoveCodeTest.assertFalse((boolean)true);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testReplaceMoveMultiple() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        foo();\n");
        buf.append("        i++; // comment\n");
        buf.append("        i--;\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        List statements = methodDecl.getBody().statements();
        ASTNode first = (ASTNode)statements.get(0);
        ASTNode last = (ASTNode)statements.get(2);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)methodDecl.getBody(), Block.STATEMENTS_PROPERTY);
        Block newBlock = astRoot.getAST().newBlock();
        ASTNode placeholder1 = listRewrite.createMoveTarget(first, last, (ASTNode)newBlock, null);
        newBlock.statements().add(placeholder1);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        {\n");
        buf.append("            foo();\n");
        buf.append("            i++; // comment\n");
        buf.append("            i--;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testMoveForStatementToForBlockCD() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        for(int i= 0; i < 8; i++)\n");
        buf.append("            foo();\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        List statements = methodDecl.getBody().statements();
        ForStatement forStatement = (ForStatement)statements.get(0);
        Statement body = forStatement.getBody();
        ASTNode placeholder = rewrite.createCopyTarget((ASTNode)body);
        Block newBody = ast.newBlock();
        newBody.statements().add(placeholder);
        rewrite.replace((ASTNode)body, (ASTNode)newBody, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        for(int i= 0; i < 8; i++) {\n");
        buf.append("            foo();\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testMoveForStatementToForBlock() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        for(int i= 0; i < 8; i++)\n");
        buf.append("            foo();\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingMoveCodeTest.assertTrue((String)"Code has errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMoveCodeTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMoveCodeTest.findMethodDeclaration(type, "foo");
        List statements = methodDecl.getBody().statements();
        ForStatement forStatement = (ForStatement)statements.get(0);
        Statement body = forStatement.getBody();
        ASTNode placeholder = rewrite.createMoveTarget((ASTNode)body);
        Block newBody = ast.newBlock();
        newBody.statements().add(placeholder);
        rewrite.replace((ASTNode)body, (ASTNode)newBody, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        for(int i= 0; i < 8; i++) {\n");
        buf.append("            foo();\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMoveCodeTest.assertEqualString(preview, buf.toString());
    }

    public void testNestedCopies() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo(Object o) {\n");
        buf.append("        int i= (String) o.indexOf('1');\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo(Object o) {\n");
        buf.append("        int i= ((String) o).indexOf('1');\n");
        buf.append("    }\n");
        buf.append("}\n");
        String expected = buf.toString();
        ASTRewritingMoveCodeTest.assertEqualString(preview, expected);
    }
}

