/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.protocolparser.test;

import java.util.EnumSet;
import org.eclipse.wst.jsdt.chromium.internal.JsonUtil;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.EnumValueCondition;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonOverrideField;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonParseMethod;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonParserRoot;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonSubtype;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonSubtypeCasting;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonSubtypeCondition;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonSubtypeConditionCustom;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonType;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.test.ParserHolder;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.junit.Assert;
import org.junit.Test;

public class SubtypingAndAggregationTest {
    static final Class<?>[] ALL_JSON_INTERFACES = new Class[]{Ball.class, Color.class, SchemedColor.class, RgbColor.class, CmykColor.class, NamedColor.class};
    private static final ParserHolder<TestParser> PARSER_INSTANCE = new ParserHolder<TestParser>(TestParser.class, ALL_JSON_INTERFACES);

    @Test
    public void testReadNamedColor() throws JsonProtocolParseException {
        String semiJson = "{'color': {'name': 'blue' }}";
        JSONObject json = SubtypingAndAggregationTest.createJsonObject(semiJson);
        TestParser parser = PARSER_INSTANCE.getParser();
        Ball ball = parser.parseBall(json);
        Assert.assertNotNull((Object)ball);
        Color color = ball.color();
        Assert.assertNotNull((Object)color);
        Assert.assertNull((Object)color.asSchemedColor());
        NamedColor namedColor = color.asNamedColor();
        Assert.assertNotNull((Object)namedColor);
        Assert.assertEquals((Object)"blue", (Object)namedColor.name());
    }

    @Test
    public void testReadRgb() throws JsonProtocolParseException {
        String semiJson = "{'color': {'scheme': 'rgb', 'red': 200, 'green': 50, 'blue': 5 }}";
        JSONObject json = SubtypingAndAggregationTest.createJsonObject(semiJson);
        TestParser parser = PARSER_INSTANCE.getParser();
        Ball ball = parser.parseBall(json);
        Assert.assertNotNull((Object)ball);
        Color color = ball.color();
        Assert.assertNotNull((Object)color);
        Assert.assertNull((Object)color.asNamedColor());
        SchemedColor schemedColor = color.asSchemedColor();
        Assert.assertNotNull((Object)schemedColor);
        Assert.assertNull((Object)schemedColor.asCmykColor());
        RgbColor rgbColor = schemedColor.asRgbColor();
        Assert.assertNotNull((Object)rgbColor);
        Assert.assertEquals((long)255L, (long)(rgbColor.red() + rgbColor.green() + rgbColor.blue()));
    }

    @Test
    public void testParseAsSubtype() throws JsonProtocolParseException {
        String semiJson = "{'scheme': 'rgb', 'red': 200, 'green': 50, 'blue': 5 }";
        JSONObject json = SubtypingAndAggregationTest.createJsonObject(semiJson);
        TestParser parser = PARSER_INSTANCE.getParser();
        RgbColor rgbColor = parser.parseRgbColor(json);
        Assert.assertNotNull((Object)rgbColor);
        Assert.assertEquals((long)255L, (long)(rgbColor.red() + rgbColor.green() + rgbColor.blue()));
    }

    @Test
    public void testUnknownSubtype() {
        String semiJson = "{'fish': 'chips' }";
        JSONObject json = SubtypingAndAggregationTest.createJsonObject(semiJson);
        TestParser parser = PARSER_INSTANCE.getParser();
        try {
            parser.parseColor(json);
            Assert.fail((String)"Exception expected");
        }
        catch (JsonProtocolParseException jsonProtocolParseException) {}
    }

    @Test
    public void testAmbiguousSubtype() {
        String semiJson = "{'scheme': 'rgb', 'red': 200, 'green': 50, 'blue': 5, 'name': 'black' }";
        JSONObject json = SubtypingAndAggregationTest.createJsonObject(semiJson);
        TestParser parser = PARSER_INSTANCE.getParser();
        try {
            parser.parseColor(json);
            Assert.fail((String)"Exception expected");
        }
        catch (JsonProtocolParseException jsonProtocolParseException) {}
    }

    private static JSONObject createJsonObject(String semiJson) {
        String jsonString = semiJson.replace('\'', '\"');
        try {
            return JsonUtil.jsonObjectFromJson((String)jsonString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonType
    public static interface Ball {
        public Color color();
    }

    @JsonType
    public static interface CmykColor
    extends JsonSubtype<SchemedColor> {
        @JsonOverrideField
        @JsonSubtypeConditionCustom(condition=CmykSchemeCondition.class)
        public ColorScheme scheme();

        public long cyan();

        public long magenta();

        public long yellow();

        public long key();

        public static class CmykSchemeCondition
        extends EnumValueCondition<ColorScheme> {
            public CmykSchemeCondition() {
                super(EnumSet.of(ColorScheme.CMYK));
            }
        }
    }

    @JsonType
    public static interface Color {
        @JsonSubtypeCasting
        public SchemedColor asSchemedColor();

        @JsonSubtypeCasting
        public NamedColor asNamedColor();
    }

    public static enum ColorScheme {
        RGB,
        CMYK;

    }

    @JsonType
    public static interface NamedColor
    extends JsonSubtype<Color> {
        @JsonSubtypeCondition
        public String name();
    }

    @JsonType
    public static interface RgbColor
    extends JsonSubtype<SchemedColor> {
        @JsonOverrideField
        @JsonSubtypeConditionCustom(condition=RgbSchemeCondition.class)
        public ColorScheme scheme();

        public long red();

        public long green();

        public long blue();

        public static class RgbSchemeCondition
        extends EnumValueCondition<ColorScheme> {
            public RgbSchemeCondition() {
                super(EnumSet.of(ColorScheme.RGB));
            }
        }
    }

    @JsonType
    public static interface SchemedColor
    extends JsonSubtype<Color> {
        @JsonSubtypeCondition
        public ColorScheme scheme();

        @JsonSubtypeCasting
        public RgbColor asRgbColor();

        @JsonSubtypeCasting
        public CmykColor asCmykColor();
    }

    @JsonParserRoot
    public static interface TestParser {
        @JsonParseMethod
        public Ball parseBall(JSONObject var1) throws JsonProtocolParseException;

        @JsonParseMethod
        public Color parseColor(JSONObject var1) throws JsonProtocolParseException;

        @JsonParseMethod
        public RgbColor parseRgbColor(JSONObject var1) throws JsonProtocolParseException;
    }
}

