/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.coap.common.templates;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class PomFileTemplate
implements IFileTemplate<InformationModel> {
    private String artefactId;
    private String mainClass;
    private String projectName;

    public PomFileTemplate(String artefactId, String mainClass, String projectName) {
        this.artefactId = artefactId;
        this.mainClass = mainClass;
        this.projectName = projectName;
    }

    public String getContent(InformationModel model, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<modelVersion>4.0.0</modelVersion>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<groupId>org.eclipse.vorto.examples</groupId>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<artifactId>");
        _builder.append((Object)this.artefactId, "\t");
        _builder.append((Object)"</artifactId>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<version>");
        String _version = model.getVersion();
        _builder.append((Object)_version, "\t");
        _builder.append((Object)"</version>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<name>Sample project generated from ");
        String _name = model.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"</name>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<packaging>jar</packaging>");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<properties>");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<app.main.class>");
        _builder.append((Object)this.mainClass, "\t\t");
        _builder.append((Object)"</app.main.class>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<!-- Use the latest version whenever possible. -->");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<jackson.version>2.5.0</jackson.version>");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<californium.version>1.0.1</californium.version>");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<shade.version>2.4.3</shade.version>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"</properties>");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<dependencies>");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<dependency>");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"<groupId>org.eclipse.californium</groupId>");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"<artifactId>californium-core</artifactId>");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"<version>${californium.version}</version>");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"</dependency>");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<dependency>");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"<groupId>com.fasterxml.jackson.core</groupId>");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"<artifactId>jackson-databind</artifactId>");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"<version>${jackson.version}</version>");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"</dependency>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"</dependencies>");
        _builder.newLine();
        _builder.append((Object)"</project>");
        _builder.newLine();
        return _builder.toString();
    }

    public String getFileName(InformationModel context) {
        return String.valueOf(this.projectName) + "/pom.xml";
    }

    public String getPath(InformationModel context) {
        return null;
    }
}

