/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobPersistenceException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.JobRunShell;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.core.SchedulingContext;
import org.quartz.spi.TriggerFiredBundle;

public class QuartzSchedulerThread
extends Thread {
    private QuartzScheduler qs;
    private QuartzSchedulerResources qsRsrcs;
    private Object pauseLock = new Object();
    private Object idleLock = new Object();
    private boolean signaled;
    private boolean paused;
    private boolean halted;
    private SchedulingContext ctxt = null;
    private Random random = new Random(System.currentTimeMillis());
    private static long DEFAULT_IDLE_WAIT_TIME = 30000L;
    private long idleWaitTime = DEFAULT_IDLE_WAIT_TIME;
    private int idleWaitVariablness = 7000;
    private long dbFailureRetryInterval = 15000L;
    private final Log log = LogFactory.getLog(this.getClass());

    QuartzSchedulerThread(QuartzScheduler qs, QuartzSchedulerResources qsRsrcs, SchedulingContext ctxt) {
        this(qs, qsRsrcs, ctxt, qsRsrcs.getMakeSchedulerThreadDaemon(), 5);
    }

    QuartzSchedulerThread(QuartzScheduler qs, QuartzSchedulerResources qsRsrcs, SchedulingContext ctxt, boolean setDaemon, int threadPrio) {
        super(qs.getSchedulerThreadGroup(), qsRsrcs.getThreadName());
        this.qs = qs;
        this.qsRsrcs = qsRsrcs;
        this.ctxt = ctxt;
        this.setDaemon(setDaemon);
        this.setPriority(threadPrio);
        this.paused = true;
        this.halted = false;
        this.start();
    }

    void setIdleWaitTime(long waitTime) {
        this.idleWaitTime = waitTime;
        this.idleWaitVariablness = (int)((double)waitTime * 0.2);
    }

    private long getDbFailureRetryInterval() {
        return this.dbFailureRetryInterval;
    }

    public void setDbFailureRetryInterval(long dbFailureRetryInterval) {
        this.dbFailureRetryInterval = dbFailureRetryInterval;
    }

    private long getRandomizedIdleWaitTime() {
        return this.idleWaitTime - (long)this.random.nextInt(this.idleWaitVariablness);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void togglePause(boolean pause) {
        Object object = this.pauseLock;
        synchronized (object) {
            this.paused = pause;
            if (this.paused) {
                this.signalSchedulingChange();
            } else {
                this.pauseLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void halt() {
        Object object = this.pauseLock;
        synchronized (object) {
            this.halted = true;
            if (this.paused) {
                this.pauseLock.notify();
            } else {
                this.signalSchedulingChange();
            }
        }
    }

    boolean isPaused() {
        return this.paused;
    }

    void signalSchedulingChange() {
        this.signaled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean lastAcquireFailed = false;
        while (!this.halted) {
            try {
                Object object = this.pauseLock;
                synchronized (object) {
                    while (this.paused && !this.halted) {
                        try {
                            this.pauseLock.wait(100L);
                        }
                        catch (InterruptedException ignore) {}
                    }
                    if (this.halted) {
                        break;
                    }
                }
                int availTreadCount = this.qsRsrcs.getThreadPool().blockForAvailableThreads();
                if (availTreadCount <= 0) continue;
                Trigger trigger = null;
                long now = System.currentTimeMillis();
                this.signaled = false;
                try {
                    trigger = this.qsRsrcs.getJobStore().acquireNextTrigger(this.ctxt, now + this.idleWaitTime);
                    lastAcquireFailed = false;
                }
                catch (JobPersistenceException jpe) {
                    if (!lastAcquireFailed) {
                        this.qs.notifySchedulerListenersError("An error occured while scanning for the next trigger to fire.", jpe);
                    }
                    lastAcquireFailed = true;
                }
                catch (RuntimeException e) {
                    if (!lastAcquireFailed) {
                        this.getLog().error((Object)("quartzSchedulerThreadLoop: RuntimeException " + e.getMessage()), (Throwable)e);
                    }
                    lastAcquireFailed = true;
                }
                if (trigger != null) {
                    now = System.currentTimeMillis();
                    long triggerTime = trigger.getNextFireTime().getTime();
                    long timeUntilTrigger = triggerTime - now;
                    long spinInterval = 10L;
                    int numPauses = (int)(timeUntilTrigger / spinInterval);
                    while (numPauses >= 0 && !this.signaled) {
                        try {
                            Thread.sleep(spinInterval);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        now = System.currentTimeMillis();
                        timeUntilTrigger = triggerTime - now;
                        numPauses = (int)(timeUntilTrigger / spinInterval);
                    }
                    if (this.signaled) {
                        try {
                            this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                        }
                        catch (JobPersistenceException jpe) {
                            this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
                            this.releaseTriggerRetryLoop(trigger);
                        }
                        catch (RuntimeException e) {
                            this.getLog().error((Object)("releaseTriggerRetryLoop: RuntimeException " + e.getMessage()), (Throwable)e);
                            this.releaseTriggerRetryLoop(trigger);
                        }
                        this.signaled = false;
                        continue;
                    }
                    TriggerFiredBundle bndle = null;
                    Object object2 = this.pauseLock;
                    synchronized (object2) {
                        if (!this.halted) {
                            try {
                                bndle = this.qsRsrcs.getJobStore().triggerFired(this.ctxt, trigger);
                            }
                            catch (SchedulerException se) {
                                this.qs.notifySchedulerListenersError("An error occured while firing trigger '" + trigger.getFullName() + "'", se);
                            }
                            catch (RuntimeException e) {
                                this.getLog().error((Object)("RuntimeException while firing trigger " + trigger.getFullName()), (Throwable)e);
                                this.releaseTriggerRetryLoop(trigger);
                            }
                        }
                        if (bndle == null) {
                            try {
                                this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                            }
                            catch (SchedulerException se) {
                                this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", se);
                                this.releaseTriggerRetryLoop(trigger);
                            }
                            continue;
                        }
                        JobRunShell shell = null;
                        try {
                            shell = this.qsRsrcs.getJobRunShellFactory().borrowJobRunShell();
                            shell.initialize(this.qs, bndle);
                        }
                        catch (SchedulerException se) {
                            try {
                                this.qsRsrcs.getJobStore().triggeredJobComplete(this.ctxt, trigger, bndle.getJobDetail(), 6);
                            }
                            catch (SchedulerException se2) {
                                this.qs.notifySchedulerListenersError("An error occured while placing job's triggers in error state '" + trigger.getFullName() + "'", se2);
                                this.errorTriggerRetryLoop(bndle);
                            }
                            continue;
                        }
                        if (!this.qsRsrcs.getThreadPool().runInThread(shell)) {
                            try {
                                this.getLog().error((Object)"ThreadPool.runInThread() return false!");
                                this.qsRsrcs.getJobStore().triggeredJobComplete(this.ctxt, trigger, bndle.getJobDetail(), 6);
                            }
                            catch (SchedulerException se2) {
                                this.qs.notifySchedulerListenersError("An error occured while placing job's triggers in error state '" + trigger.getFullName() + "'", se2);
                                this.releaseTriggerRetryLoop(trigger);
                            }
                        }
                        continue;
                    }
                }
                long now2 = System.currentTimeMillis();
                long waitTime = now2 + this.getRandomizedIdleWaitTime();
                long timeUntilContinue = waitTime - now2;
                long spinInterval = 10L;
                int numPauses = (int)(timeUntilContinue / spinInterval);
                while (numPauses > 0 && !this.signaled) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    now2 = System.currentTimeMillis();
                    timeUntilContinue = waitTime - now2;
                    numPauses = (int)(timeUntilContinue / spinInterval);
                }
            }
            catch (RuntimeException re) {
                this.getLog().error((Object)"Runtime error occured in main trigger firing loop.", (Throwable)re);
            }
        }
        this.qs = null;
        this.qsRsrcs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorTriggerRetryLoop(TriggerFiredBundle bndle) {
        int retryCount = 0;
        try {
            while (!this.halted) {
                try {
                    Thread.sleep(this.getDbFailureRetryInterval());
                    ++retryCount;
                    this.qsRsrcs.getJobStore().triggeredJobComplete(this.ctxt, bndle.getTrigger(), bndle.getJobDetail(), 6);
                    retryCount = 0;
                    break;
                }
                catch (JobPersistenceException jpe) {
                    if (retryCount % 4 != 0) continue;
                    this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + bndle.getTrigger().getFullName() + "'", jpe);
                }
                catch (RuntimeException e) {
                    this.getLog().error((Object)("releaseTriggerRetryLoop: RuntimeException " + e.getMessage()), (Throwable)e);
                }
                catch (InterruptedException e) {
                    this.getLog().error((Object)("releaseTriggerRetryLoop: InterruptedException " + e.getMessage()), (Throwable)e);
                }
            }
        }
        finally {
            if (retryCount == 0) {
                this.getLog().info((Object)"releaseTriggerRetryLoop: connection restored.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTriggerRetryLoop(Trigger trigger) {
        int retryCount = 0;
        try {
            while (!this.halted) {
                try {
                    Thread.sleep(this.getDbFailureRetryInterval());
                    ++retryCount;
                    this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                    retryCount = 0;
                    break;
                }
                catch (JobPersistenceException jpe) {
                    if (retryCount % 4 != 0) continue;
                    this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
                }
                catch (RuntimeException e) {
                    this.getLog().error((Object)("releaseTriggerRetryLoop: RuntimeException " + e.getMessage()), (Throwable)e);
                }
                catch (InterruptedException e) {
                    this.getLog().error((Object)("releaseTriggerRetryLoop: InterruptedException " + e.getMessage()), (Throwable)e);
                }
            }
        }
        finally {
            if (retryCount == 0) {
                this.getLog().info((Object)"releaseTriggerRetryLoop: connection restored.");
            }
        }
    }

    public Log getLog() {
        return this.log;
    }
}

