/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.providers;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.virgo.ide.runtime.core.artefacts.Artefact;
import org.eclipse.virgo.ide.runtime.core.artefacts.ArtefactRepository;
import org.eclipse.virgo.ide.runtime.core.artefacts.ArtefactSet;
import org.eclipse.virgo.ide.runtime.core.artefacts.IArtefact;
import org.eclipse.virgo.ide.runtime.core.artefacts.ILocalArtefact;
import org.eclipse.virgo.ide.runtime.core.artefacts.LocalArtefactRepository;
import org.eclipse.virgo.ide.runtime.core.provisioning.RepositoryUtils;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

public class RepositoryContentProvider
implements ITreeContentProvider {
    private ArtefactRepository repository;

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IServer) {
            IServer server = (IServer)inputElement;
            this.repository = RepositoryUtils.getRepositoryContents((IRuntime)server.getRuntime());
            this.repository.setServer(server);
            ArrayList<ArtefactSet> children = new ArrayList<ArtefactSet>();
            HashMap<File, LocalArtefactRepository> setForFile = new HashMap<File, LocalArtefactRepository>();
            for (IArtefact bundle : this.repository.getAllArtefacts().getArtefacts()) {
                if (!(bundle instanceof ILocalArtefact)) continue;
                File file = ((ILocalArtefact)bundle).getFile().getParentFile();
                if (file.getParentFile().getName().equals("subsystems")) {
                    file = file.getParentFile();
                }
                if (setForFile.containsKey(file)) {
                    ((ArtefactRepository)setForFile.get(file)).add(bundle);
                    continue;
                }
                LocalArtefactRepository localRepository = new LocalArtefactRepository(file);
                localRepository.setServer(server);
                localRepository.add(bundle);
                setForFile.put(file, localRepository);
            }
            for (ArtefactRepository repos : setForFile.values()) {
                if (repos.getBundleSet().getArtefacts().iterator().hasNext()) {
                    children.add(repos.getBundleSet());
                }
                if (!repos.getLibrarySet().getArtefacts().iterator().hasNext()) continue;
                children.add(repos.getLibrarySet());
            }
            return children.toArray();
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ArtefactSet) {
            return ((ArtefactSet)parentElement).toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof Artefact) {
            Artefact artefact = (Artefact)element;
            return artefact.getSet();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public ArtefactRepository getRepository() {
        return this.repository;
    }
}

