/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.jdt.internal.core.util;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.virgo.ide.jdt.core.JdtCorePlugin;
import org.eclipse.virgo.ide.jdt.internal.core.classpath.ServerClasspathContainer;
import org.eclipse.virgo.ide.jdt.internal.core.classpath.ServerClasspathContainerUpdateJob;
import org.eclipse.virgo.ide.manifest.core.BundleManifestCorePlugin;
import org.eclipse.virgo.ide.manifest.core.BundleManifestUtils;
import org.eclipse.virgo.ide.manifest.core.IBundleManifestChangeListener;
import org.eclipse.virgo.ide.manifest.internal.core.BundleManifestManager;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.ImportedPackage;
import org.eclipse.virgo.util.osgi.manifest.RequiredBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathUtils {
    public static void adjustLastModifiedDate(IJavaProject javaProject, boolean testBundle) {
        File manifest = BundleManifestUtils.locateManifestFile((IJavaProject)javaProject, (boolean)testBundle);
        if (manifest != null && manifest.canRead()) {
            long lastmodified = manifest.lastModified();
            File metaInfFolder = manifest.getParentFile();
            if (metaInfFolder != null && metaInfFolder.getName().equals("META-INF") && metaInfFolder.canWrite()) {
                metaInfFolder.setLastModified(lastmodified);
                File srcFolder = metaInfFolder.getParentFile();
                if (srcFolder != null && srcFolder.canWrite()) {
                    srcFolder.setLastModified(lastmodified);
                }
            }
        }
    }

    public static boolean hasClasspathContainer(IJavaProject javaProject) {
        boolean hasContainer = false;
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getPath().equals((Object)ServerClasspathContainer.CLASSPATH_CONTAINER_PATH)) {
                    hasContainer = true;
                    break;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JdtCorePlugin.log(e);
        }
        return hasContainer;
    }

    public static ServerClasspathContainer getClasspathContainer(IJavaProject javaProject) {
        try {
            IClasspathContainer container;
            if (ClasspathUtils.hasClasspathContainer(javaProject) && (container = JavaCore.getClasspathContainer((IPath)ServerClasspathContainer.CLASSPATH_CONTAINER_PATH, (IJavaProject)javaProject)) instanceof ServerClasspathContainer) {
                return (ServerClasspathContainer)container;
            }
        }
        catch (JavaModelException e) {
            JdtCorePlugin.log(e);
        }
        return null;
    }

    public static IPath getSourceAttachment(IJavaProject project, File file) {
        IEclipsePreferences preferences = JdtCorePlugin.getDefault().getProjectPreferences(project.getProject());
        String value = preferences.get("source.attachment-" + file.getName(), null);
        if (value != null) {
            return new Path(value);
        }
        return null;
    }

    public static void storeSourceAttachments(IJavaProject project, IClasspathContainer containerSuggestion) {
        IEclipsePreferences preferences = JdtCorePlugin.getDefault().getProjectPreferences(project.getProject());
        IClasspathEntry[] iClasspathEntryArray = containerSuggestion.getClasspathEntries();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            IPath path = entry.getPath();
            IPath sourcePath = entry.getSourceAttachmentPath();
            if (sourcePath != null) {
                preferences.put("source.attachment-" + path.lastSegment().toString(), sourcePath.toString());
            }
            ++n2;
        }
    }

    public static IStatus updateClasspathContainer(IJavaProject javaProject, Set<IBundleManifestChangeListener.Type> types, IProgressMonitor monitor) {
        try {
            ServerClasspathContainer oldContainer;
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if ((types.contains(IBundleManifestChangeListener.Type.IMPORT_BUNDLE) || types.contains(IBundleManifestChangeListener.Type.IMPORT_LIBRARY) || types.contains(IBundleManifestChangeListener.Type.IMPORT_PACKAGE) || types.contains(IBundleManifestChangeListener.Type.REQUIRE_BUNDLE)) && (oldContainer = ClasspathUtils.getClasspathContainer(javaProject)) != null) {
                ServerClasspathContainer container = new ServerClasspathContainer(javaProject);
                container.refreshClasspathEntries();
                if (!Arrays.deepEquals(oldContainer.getClasspathEntries(), container.getClasspathEntries())) {
                    JavaCore.setClasspathContainer((IPath)ServerClasspathContainer.CLASSPATH_CONTAINER_PATH, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{container}, (IProgressMonitor)monitor);
                }
            }
            if (types.contains(IBundleManifestChangeListener.Type.EXPORT_PACKAGE)) {
                ClasspathUtils.updateClasspathContainerForDependingBundles(javaProject);
            }
        }
        catch (JavaModelException e) {
            JdtCorePlugin.log(e);
        }
        return Status.OK_STATUS;
    }

    private static void updateClasspathContainerForDependingBundles(IJavaProject javaProject) {
        BundleManifest updatedBundleManifest = BundleManifestCorePlugin.getBundleManifestManager().getBundleManifest(javaProject);
        Set updatedPackageExports = BundleManifestCorePlugin.getBundleManifestManager().getPackageExports(javaProject);
        if (updatedBundleManifest != null && updatedBundleManifest.getBundleSymbolicName() != null) {
            String bundleSymbolicName = updatedBundleManifest.getBundleSymbolicName().getSymbolicName();
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                try {
                    if (!javaProject.getProject().equals((Object)project) && FacetUtils.isBundleProject((IResource)project)) {
                        IJavaProject jp = JavaCore.create((IProject)project);
                        BundleManifest manifest = BundleManifestCorePlugin.getBundleManifestManager().getBundleManifest(jp);
                        boolean refreshClasspath = false;
                        if (manifest != null) {
                            if (manifest.getRequireBundle() != null) {
                                for (RequiredBundle requiredBundle : manifest.getRequireBundle().getRequiredBundles()) {
                                    if (bundleSymbolicName == null || !bundleSymbolicName.equals(requiredBundle.getBundleSymbolicName())) continue;
                                    refreshClasspath = true;
                                    break;
                                }
                            }
                            if (manifest.getImportPackage() != null) {
                                for (ImportedPackage packageImport : manifest.getImportPackage().getImportedPackages()) {
                                    if (!updatedPackageExports.contains(packageImport.getPackageName())) continue;
                                    refreshClasspath = true;
                                    break;
                                }
                            }
                            String[] stringArray = jp.getRequiredProjectNames();
                            int n3 = stringArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String requiredProjectName = stringArray[n4];
                                if (requiredProjectName.equals(javaProject.getElementName())) {
                                    refreshClasspath = true;
                                    break;
                                }
                                ++n4;
                            }
                            if (refreshClasspath) {
                                ServerClasspathContainerUpdateJob.scheduleClasspathContainerUpdateJob(jp, BundleManifestManager.IMPORTS_CHANGED);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    JdtCorePlugin.log(e);
                }
                ++n2;
            }
        }
    }
}

