/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.support.partialmanifest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.virgo.bundlor.support.PartialManifestResolver;
import org.eclipse.virgo.bundlor.support.TemplateHeaderReader;
import org.eclipse.virgo.bundlor.support.partialmanifest.ReadablePartialManifest;
import org.eclipse.virgo.bundlor.util.MatchUtils;
import org.eclipse.virgo.bundlor.util.SimpleParserLogger;
import org.eclipse.virgo.bundlor.util.StringUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.ExportedPackage;
import org.eclipse.virgo.util.osgi.manifest.ImportedPackage;
import org.eclipse.virgo.util.osgi.manifest.Resolution;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderDeclaration;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParserFactory;
import org.eclipse.virgo.util.osgi.manifest.parse.ParserLogger;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;

public final class StandardPartialManifestResolver
implements TemplateHeaderReader,
PartialManifestResolver {
    private static final String ATTR_BUNDLE_VERSION = "Bundle-Version";
    private static final String ATTR_EXPORT_TEMPLATE = "Export-Template";
    private static final String ATTR_IMPORT_TEMPLATE = "Import-Template";

    @Override
    public List<String> getTemplateOnlyHeaderNames() {
        return Arrays.asList(ATTR_EXPORT_TEMPLATE, ATTR_IMPORT_TEMPLATE);
    }

    @Override
    public BundleManifest resolve(ManifestContents templateManifest, ReadablePartialManifest partial) {
        BundleManifest result = BundleManifestFactory.createBundleManifest((ParserLogger)new SimpleParserLogger());
        this.processImports(result, templateManifest, partial);
        this.processExports(result, templateManifest, partial);
        return result;
    }

    private void processExports(BundleManifest result, ManifestContents templateManifest, ReadablePartialManifest partial) {
        String bundleVersion = (String)templateManifest.getMainAttributes().get(ATTR_BUNDLE_VERSION);
        String exportTemplate = (String)templateManifest.getMainAttributes().get(ATTR_EXPORT_TEMPLATE);
        List<HeaderDeclaration> exportTemplateDeclarations = this.parseTemplate(exportTemplate);
        ArrayList<ExportedPackage> packageExports = new ArrayList<ExportedPackage>();
        for (String exportedPackage : partial.getExportedPackages()) {
            HeaderDeclaration declaration = this.findMostSpecificDeclaration(exportTemplateDeclarations, exportedPackage);
            ExportedPackage export = result.getExportPackage().addExportedPackage(exportedPackage);
            if (declaration != null) {
                export.getAttributes().putAll(declaration.getAttributes());
                Map directives = declaration.getDirectives();
                this.addCommaSeparated(export.getExclude(), (String)directives.get("excluded"));
                this.addCommaSeparated(export.getInclude(), (String)directives.get("include"));
                this.addCommaSeparated(export.getMandatory(), (String)directives.get("mandatory"));
                this.addCommaSeparated(export.getUses(), (String)directives.get("uses"));
            }
            Set<String> uses = partial.getUses(exportedPackage);
            export.getUses().addAll(uses);
            String version = this.resolveVersion(declaration, bundleVersion);
            if (StringUtils.hasText(version)) {
                export.getAttributes().put("version", version);
            }
            packageExports.add(export);
        }
    }

    private void processImports(BundleManifest result, ManifestContents template, ReadablePartialManifest partial) {
        String importTemplate = (String)template.getMainAttributes().get(ATTR_IMPORT_TEMPLATE);
        List<HeaderDeclaration> importTemplateDeclarations = this.parseTemplate(importTemplate);
        ArrayList<ImportedPackage> packageImports = new ArrayList<ImportedPackage>();
        for (String importedPackage : partial.getImportedPackages()) {
            HeaderDeclaration match = this.findMostSpecificDeclaration(importTemplateDeclarations, importedPackage);
            ImportedPackage packageImport = result.getImportPackage().addImportedPackage(importedPackage);
            if (match != null) {
                packageImport.getAttributes().putAll(match.getAttributes());
                packageImport.setResolution(this.parseResolution(match));
            }
            packageImports.add(packageImport);
        }
    }

    private void addCommaSeparated(Collection<String> target, String value) {
        if (value != null) {
            if (value.startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
        }
        String[] array = StringUtils.commaDelimitedListToStringArray(value);
        Collections.addAll(target, array);
    }

    private HeaderDeclaration findMostSpecificDeclaration(List<HeaderDeclaration> declarations, String packageName) {
        HeaderDeclaration match = null;
        int matchSpecificity = -1;
        for (HeaderDeclaration headerDeclaration : declarations) {
            for (String stem : headerDeclaration.getNames()) {
                int m = MatchUtils.rankedMatch(packageName, stem);
                if (m <= matchSpecificity) continue;
                match = headerDeclaration;
                matchSpecificity = m;
            }
        }
        return match;
    }

    private String resolveVersion(HeaderDeclaration declaration, String defaultVersion) {
        String version;
        String string = version = declaration != null ? (String)declaration.getAttributes().get("version") : null;
        if (!StringUtils.hasText(version)) {
            version = defaultVersion;
        }
        return version;
    }

    private Resolution parseResolution(HeaderDeclaration declaration) {
        if ("optional".equals(declaration.getDirectives().get("resolution"))) {
            return Resolution.OPTIONAL;
        }
        return Resolution.MANDATORY;
    }

    private List<HeaderDeclaration> parseTemplate(String template) {
        if (StringUtils.hasText(template)) {
            return HeaderParserFactory.newHeaderParser((ParserLogger)new SimpleParserLogger()).parseHeader(template);
        }
        return new ArrayList<HeaderDeclaration>(0);
    }
}

