/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.ui.internal.dependencies;

import org.eclipse.libra.framework.editor.core.model.IBundle;

public abstract class BundleDependency {
    private final IBundle exportingBundle;
    private final IBundle importingBundle;

    public BundleDependency(IBundle exportingBundle, IBundle importingBundle) {
        this.exportingBundle = exportingBundle;
        this.importingBundle = importingBundle;
    }

    public IBundle getExportingBundle() {
        return this.exportingBundle;
    }

    public IBundle getImportingBundle() {
        return this.importingBundle;
    }

    public int hashCode() {
        int hashCode = 17;
        if (this.exportingBundle != null) {
            hashCode = 31 * hashCode + this.exportingBundle.hashCode();
        }
        if (this.importingBundle != null) {
            hashCode = 31 * hashCode + this.importingBundle.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BundleDependency)) {
            return false;
        }
        BundleDependency that = (BundleDependency)other;
        if (this.exportingBundle != that.exportingBundle) {
            return false;
        }
        if (this.exportingBundle != null && !this.exportingBundle.equals(that.exportingBundle)) {
            return false;
        }
        if (this.importingBundle != that.importingBundle) {
            return false;
        }
        return this.importingBundle == null || this.importingBundle.equals(that.importingBundle);
    }
}

