/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.crossovers;

import java.util.Random;
import org.eclipse.viatra.dse.base.DesignSpaceManager;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.designspace.api.TrajectoryInfo;
import org.eclipse.viatra.dse.evolutionary.GeneticHelper;
import org.eclipse.viatra.dse.evolutionary.interfaces.ICrossover;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class PermutationCrossover
implements ICrossover {
    private Random random = new Random();
    private Object[] parent1t;
    private Object[] parent2t;
    private int p1Size;
    private int p2Size;
    private int index;

    @Override
    public boolean mutate(TrajectoryFitness parent1, TrajectoryFitness parent2, ThreadContext context) {
        DesignSpaceManager dsm = context.getDesignSpaceManager();
        TrajectoryInfo trajectoryInfo = dsm.getTrajectoryInfo();
        this.parent1t = parent1.trajectory;
        this.parent2t = parent2.trajectory;
        this.p1Size = this.parent1t.length;
        this.p2Size = this.parent2t.length;
        if (this.p1Size < 2 || this.p2Size < 2) {
            return false;
        }
        int minSize = Math.min(this.p1Size, this.p2Size);
        this.index = this.random.nextInt(minSize);
        dsm.executeTrajectoryWithMinimalBacktrackWithoutStateCoding(this.parent1t, this.index);
        this.addPermutation(dsm, trajectoryInfo, this.parent2t);
        return true;
    }

    private void addPermutation(DesignSpaceManager dsm, TrajectoryInfo trajectoryInfo, Object[] parent) {
        Object[] objectArray = parent;
        int n = parent.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                Object transitionToAddId = objectArray[n2];
                for (Object childTransition : trajectoryInfo.getTrajectory()) {
                    Object id = childTransition;
                    if (!transitionToAddId.equals(id)) {
                        continue;
                    }
                    break block3;
                }
                GeneticHelper.tryFireRightTransition(dsm, transitionToAddId);
            }
            ++n2;
        }
    }

    @Override
    public boolean mutateAlternate(TrajectoryFitness parent1, TrajectoryFitness parent2, ThreadContext context) {
        DesignSpaceManager dsm = context.getDesignSpaceManager();
        dsm.executeTrajectoryWithMinimalBacktrackWithoutStateCoding(this.parent2t, this.index);
        this.addPermutation(dsm, dsm.getTrajectoryInfo(), this.parent1t);
        return true;
    }

    @Override
    public ICrossover createNew() {
        return new PermutationCrossover();
    }
}

