/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.DefaultActivationNotificationListener;
import org.eclipse.viatra.transformation.evm.api.event.ActivationState;
import org.eclipse.viatra.transformation.evm.api.resolver.ChangeableConflictSet;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictResolver;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictSetUpdater;
import org.eclipse.viatra.transformation.evm.notification.IActivationNotificationListener;
import org.eclipse.viatra.transformation.evm.specific.resolver.ArbitraryOrderConflictResolver;

public class Agenda {
    private final Map<ActivationState, Set<Activation<?>>> activations;
    private ChangeableConflictSet conflictSet;
    private IActivationNotificationListener activationListener;
    private ConflictSetUpdater updatingListener;
    private final Logger logger = Logger.getLogger((String)this.toString());

    public Agenda() {
        this(new ArbitraryOrderConflictResolver());
    }

    public Agenda(ConflictResolver conflictResolver) {
        this.activations = new HashMap();
        this.conflictSet = conflictResolver.createConflictSet();
        this.updatingListener = new ConflictSetUpdater(this.conflictSet);
        this.setActivationListener(new DefaultActivationNotificationListener(this));
    }

    public Agenda(ConflictResolver conflictResolver, IActivationNotificationListener activationListener) {
        this.setActivationListener(activationListener);
        Preconditions.checkState((this.getActivationListener() != null ? 1 : 0) != 0, (String)"Activation Listener is null!");
        this.activations = new HashMap();
        this.conflictSet = conflictResolver.createConflictSet();
        this.updatingListener = new ConflictSetUpdater(this.conflictSet);
    }

    public Map<ActivationState, Set<Activation<?>>> getActivations() {
        return this.activations;
    }

    public Collection<Activation<?>> getActivations(ActivationState state) {
        return this.getActivations().get(state);
    }

    public Collection<Activation<?>> getAllActivations() {
        return this.getActivations().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public IActivationNotificationListener getActivationListener() {
        return this.activationListener;
    }

    public void setConflictResolver(ConflictResolver resolver) {
        ChangeableConflictSet set = resolver.createConflictSet();
        for (Activation<?> act : this.conflictSet.getConflictingActivations()) {
            set.addActivation(act);
        }
        this.updatingListener = new ConflictSetUpdater(set);
        this.conflictSet = set;
    }

    public void setActivationListener(IActivationNotificationListener activationListener) {
        this.activationListener = activationListener;
    }

    public ChangeableConflictSet getConflictSet() {
        return this.conflictSet;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected ConflictSetUpdater getConflictSetUpdater() {
        return this.updatingListener;
    }
}

