/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.internal.apiimpl.QueryResultWrapper;
import org.eclipse.viatra.query.runtime.matchers.backend.IMatcherCapability;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public abstract class BaseMatcher<Match extends IPatternMatch>
extends QueryResultWrapper
implements ViatraQueryMatcher<Match> {
    protected ViatraQueryEngine engine;
    protected IQuerySpecification<? extends BaseMatcher<Match>> querySpecification;
    private IMatcherCapability capabilities;
    private Object[] fEmptyArray;

    public BaseMatcher(IQuerySpecification<? extends BaseMatcher<Match>> querySpecification) {
        this.querySpecification = querySpecification;
        this.querySpecification.getInternalQueryRepresentation().ensureInitialized();
    }

    @Override
    protected void setBackend(ViatraQueryEngine engine, IQueryResultProvider resultProvider, IMatcherCapability capabilities) {
        this.backend = resultProvider;
        this.engine = engine;
        this.capabilities = capabilities;
    }

    protected abstract Match arrayToMatch(Object[] var1);

    protected abstract Match arrayToMatchMutable(Object[] var1);

    protected Object[] matchToArray(Match partialMatch) {
        return partialMatch.toArray();
    }

    protected abstract Match tupleToMatch(Tuple var1);

    protected Object[] emptyArray() {
        if (this.fEmptyArray == null) {
            this.fEmptyArray = new Object[this.getSpecification().getParameterNames().size()];
        }
        return this.fEmptyArray;
    }

    @Override
    public Integer getPositionOfParameter(String parameterName) {
        return this.getSpecification().getPositionOfParameter(parameterName);
    }

    @Override
    public List<String> getParameterNames() {
        return this.getSpecification().getParameterNames();
    }

    @Override
    public Collection<Match> getAllMatches() {
        return this.rawGetAllMatches(this.emptyArray());
    }

    protected Collection<Match> rawGetAllMatches(Object[] parameters) {
        Collection m = this.backend.getAllMatches(parameters);
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Tuple t : m) {
            matches.add(this.tupleToMatch(t));
        }
        return matches;
    }

    @Override
    public Collection<Match> getAllMatches(Match partialMatch) {
        return this.rawGetAllMatches(partialMatch.toArray());
    }

    @Override
    public Match getOneArbitraryMatch() {
        return this.rawGetOneArbitraryMatch(this.emptyArray());
    }

    protected Match rawGetOneArbitraryMatch(Object[] parameters) {
        Tuple t = this.backend.getOneArbitraryMatch(parameters);
        if (t != null) {
            return this.tupleToMatch(t);
        }
        return null;
    }

    @Override
    public Match getOneArbitraryMatch(Match partialMatch) {
        return this.rawGetOneArbitraryMatch(partialMatch.toArray());
    }

    protected boolean rawHasMatch(Object[] parameters) {
        return this.backend.hasMatch(parameters);
    }

    @Override
    public boolean hasMatch() {
        return this.rawHasMatch(this.emptyArray());
    }

    @Override
    public boolean hasMatch(Match partialMatch) {
        return this.rawHasMatch(partialMatch.toArray());
    }

    @Override
    public int countMatches() {
        return this.rawCountMatches(this.emptyArray());
    }

    protected int rawCountMatches(Object[] parameters) {
        return this.backend.countMatches(parameters);
    }

    @Override
    public int countMatches(Match partialMatch) {
        return this.rawCountMatches(partialMatch.toArray());
    }

    protected void rawForEachMatch(Object[] parameters, IMatchProcessor<? super Match> processor) {
        Collection m = this.backend.getAllMatches(parameters);
        for (Tuple t : m) {
            processor.process(this.tupleToMatch(t));
        }
    }

    @Override
    public void forEachMatch(IMatchProcessor<? super Match> processor) {
        this.rawForEachMatch(this.emptyArray(), processor);
    }

    @Override
    public void forEachMatch(Match match, IMatchProcessor<? super Match> processor) {
        this.rawForEachMatch(match.toArray(), processor);
    }

    @Override
    public boolean forOneArbitraryMatch(IMatchProcessor<? super Match> processor) {
        return this.rawForOneArbitraryMatch(this.emptyArray(), processor);
    }

    @Override
    public boolean forOneArbitraryMatch(Match partialMatch, IMatchProcessor<? super Match> processor) {
        return this.rawForOneArbitraryMatch(partialMatch.toArray(), processor);
    }

    protected boolean rawForOneArbitraryMatch(Object[] parameters, IMatchProcessor<? super Match> processor) {
        Tuple t = this.backend.getOneArbitraryMatch(parameters);
        if (t != null) {
            processor.process(this.tupleToMatch(t));
            return true;
        }
        return false;
    }

    @Override
    public Match newEmptyMatch() {
        return this.arrayToMatchMutable(new Object[this.getParameterNames().size()]);
    }

    @Override
    public Match newMatch(Object ... parameters) {
        return this.arrayToMatch(parameters);
    }

    @Override
    public Set<Object> getAllValues(String parameterName) {
        return this.rawGetAllValues(this.getPositionOfParameter(parameterName), this.emptyArray());
    }

    @Override
    public Set<Object> getAllValues(String parameterName, Match partialMatch) {
        return this.rawGetAllValues(this.getPositionOfParameter(parameterName), partialMatch.toArray());
    }

    protected Set<Object> rawGetAllValues(int position, Object[] parameters) {
        if (position >= 0 && position < this.getParameterNames().size() && parameters.length == this.getParameterNames().size() && parameters[position] == null) {
            HashSet<Object> results = new HashSet<Object>();
            this.rawAccumulateAllValues(position, parameters, results);
            return results;
        }
        return null;
    }

    protected <T> void rawAccumulateAllValues(int position, Object[] parameters, Set<T> accumulator) {
        this.rawForEachMatch(parameters, match -> {
            boolean bl = accumulator.add(match.get(position));
        });
    }

    @Override
    public ViatraQueryEngine getEngine() {
        return this.engine;
    }

    @Override
    public IQuerySpecification<? extends BaseMatcher<Match>> getSpecification() {
        return this.querySpecification;
    }

    @Override
    public String getPatternName() {
        return this.querySpecification.getFullyQualifiedName();
    }

    public IMatcherCapability getCapabilities() {
        return this.capabilities;
    }
}

