/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.rete.network.CommunicationTracker;
import org.eclipse.viatra.query.runtime.rete.network.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.MessageKind;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.RederivableNode;

public abstract class CommunicationGroup
implements Comparable<CommunicationGroup> {
    public boolean isEnqueued = false;
    protected final Node representative;
    protected int identifier;
    protected CommunicationTracker tracker;

    public CommunicationGroup(CommunicationTracker tracker, Node representative, int identifier) {
        this.tracker = tracker;
        this.representative = representative;
        this.identifier = identifier;
    }

    public abstract void deliverMessages();

    public Node getRepresentative() {
        return this.representative;
    }

    public abstract boolean isEmpty();

    public abstract void notifyLostAllMessages(Mailbox var1, MessageKind var2);

    public abstract void notifyHasMessage(Mailbox var1, MessageKind var2);

    public abstract void addRederivable(RederivableNode var1);

    public abstract void removeRederivable(RederivableNode var1);

    public abstract Map<MessageKind, Collection<Mailbox>> getMailboxes();

    public abstract Collection<RederivableNode> getRederivables();

    public int hashCode() {
        return this.identifier;
    }

    public String toString() {
        return "Group " + this.identifier + " - representative: " + this.representative + " - isEmpty: " + this.isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CommunicationGroup that = (CommunicationGroup)obj;
        return this.identifier == that.identifier;
    }

    @Override
    public int compareTo(CommunicationGroup that) {
        return this.identifier - that.identifier;
    }

    public static final class Recursive
    extends CommunicationGroup {
        private final Set<Mailbox> antiMonotoneMailboxes = new HashSet<Mailbox>();
        private final Set<Mailbox> monotoneMailboxes = new HashSet<Mailbox>();
        private final Set<Mailbox> defaultMailboxes = new HashSet<Mailbox>();
        private final Set<RederivableNode> rederivables = new LinkedHashSet<RederivableNode>();

        public Recursive(CommunicationTracker tracker, Node representative, int identifier) {
            super(tracker, representative, identifier);
        }

        /*
         * Exception decompiling
         */
        @Override
        public void deliverMessages() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AnonBreakTarget
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getStructuredStatement(GotoStatement.java:116)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isEmpty() {
            return this.rederivables.isEmpty() && this.antiMonotoneMailboxes.isEmpty() && this.monotoneMailboxes.isEmpty() && this.defaultMailboxes.isEmpty();
        }

        @Override
        public void notifyHasMessage(Mailbox mailbox, MessageKind kind) {
            Collection<Mailbox> mailboxes = this.getMailboxContainer(kind);
            mailboxes.add(mailbox);
            if (!this.isEnqueued) {
                this.tracker.activateUnenqueued(this);
            }
        }

        @Override
        public void notifyLostAllMessages(Mailbox mailbox, MessageKind kind) {
            Collection<Mailbox> mailboxes = this.getMailboxContainer(kind);
            mailboxes.remove(mailbox);
            if (this.isEmpty()) {
                this.tracker.deactivate(this);
            }
        }

        private Collection<Mailbox> getMailboxContainer(MessageKind kind) {
            if (kind == MessageKind.ANTI_MONOTONE) {
                return this.antiMonotoneMailboxes;
            }
            if (kind == MessageKind.MONOTONE) {
                return this.monotoneMailboxes;
            }
            return this.defaultMailboxes;
        }

        @Override
        public void addRederivable(RederivableNode node) {
            this.rederivables.add(node);
            if (!this.isEnqueued) {
                this.tracker.activateUnenqueued(this);
            }
        }

        @Override
        public void removeRederivable(RederivableNode node) {
            this.rederivables.remove(node);
            if (this.isEmpty()) {
                this.tracker.deactivate(this);
            }
        }

        @Override
        public Collection<RederivableNode> getRederivables() {
            return this.rederivables;
        }

        @Override
        public Map<MessageKind, Collection<Mailbox>> getMailboxes() {
            EnumMap<MessageKind, Set<Mailbox>> map = new EnumMap<MessageKind, Set<Mailbox>>(MessageKind.class);
            map.put(MessageKind.ANTI_MONOTONE, this.antiMonotoneMailboxes);
            map.put(MessageKind.MONOTONE, this.monotoneMailboxes);
            map.put(MessageKind.DEFAULT, this.defaultMailboxes);
            return Collections.unmodifiableMap(map);
        }
    }

    public static final class Singleton
    extends CommunicationGroup {
        private Mailbox mailbox;

        public Singleton(CommunicationTracker tracker, Node representative, int identifier) {
            super(tracker, representative, identifier);
        }

        @Override
        public void deliverMessages() {
            this.mailbox.deliverAll(null);
        }

        @Override
        public boolean isEmpty() {
            return this.mailbox == null;
        }

        @Override
        public void notifyHasMessage(Mailbox mailbox, MessageKind kind) {
            if (kind == MessageKind.DEFAULT) {
                this.mailbox = mailbox;
                if (!this.isEnqueued) {
                    this.tracker.activateUnenqueued(this);
                }
            } else {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public void notifyLostAllMessages(Mailbox mailbox, MessageKind kind) {
            if (kind != MessageKind.DEFAULT) {
                throw new IllegalArgumentException();
            }
            this.mailbox = null;
            this.tracker.deactivate(this);
        }

        @Override
        public void addRederivable(RederivableNode node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRederivable(RederivableNode node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<RederivableNode> getRederivables() {
            return Collections.emptySet();
        }

        @Override
        public Map<MessageKind, Collection<Mailbox>> getMailboxes() {
            if (this.mailbox != null) {
                return Collections.singletonMap(MessageKind.DEFAULT, Collections.singleton(this.mailbox));
            }
            return Collections.emptyMap();
        }
    }
}

