/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.application.ui.transformationview;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.viatra.examples.cps.application.ui.transformationview.ITransformationRegistryListener;
import org.eclipse.viatra.examples.cps.application.ui.transformationview.util.TransformationConnector;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.TransformationType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

public class TransformationRegistry {
    @Accessors
    private TransformationType newTransformationType = TransformationType.BATCH_VIATRA_TRANSFORMATION;
    private Map<IEditorPart, TransformationConnector> transformationMap = new HashMap<IEditorPart, TransformationConnector>();
    private final Set<ITransformationRegistryListener> listeners = new HashSet<ITransformationRegistryListener>();

    protected TransformationRegistry() {
    }

    public void setNewTransformationType(TransformationType newTransformationType) {
        this.newTransformationType = newTransformationType;
        Consumer<ITransformationRegistryListener> _function = it -> it.transformationTypeChanged(newTransformationType);
        this.listeners.forEach(_function);
    }

    public static TransformationRegistry getInstance() {
        return LazyHolder.INSTANCE;
    }

    public TransformationConnector get(IEditorPart part) {
        return this.transformationMap.get(part);
    }

    public boolean containsKey(IEditorPart part) {
        return this.transformationMap.containsKey(part);
    }

    public void put(IEditorPart part, TransformationConnector connector) {
        this.transformationMap.put(part, connector);
        Consumer<ITransformationRegistryListener> _function = it -> it.transformationAdded(connector);
        this.listeners.forEach(_function);
    }

    public void remove(IEditorPart part) {
        TransformationConnector removed = this.transformationMap.remove(part);
        Consumer<ITransformationRegistryListener> _function = it -> it.transformationRemoved(removed);
        this.listeners.forEach(_function);
    }

    public boolean addListener(ITransformationRegistryListener listener, boolean notifyForCurrentElements) {
        boolean added = this.listeners.add(listener);
        if (notifyForCurrentElements) {
            Consumer<TransformationConnector> _function = it -> listener.transformationAdded((TransformationConnector)it);
            this.transformationMap.values().forEach(_function);
            listener.transformationTypeChanged(this.newTransformationType);
        }
        return added;
    }

    public boolean removeListener(ITransformationRegistryListener listener) {
        return this.listeners.remove(listener);
    }

    @Pure
    public TransformationType getNewTransformationType() {
        return this.newTransformationType;
    }

    private static class LazyHolder {
        private static final TransformationRegistry INSTANCE = new TransformationRegistry();

        private LazyHolder() {
        }
    }
}

