/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.application.ui.transformationview;

import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.viatra.examples.cps.application.ui.transformationview.TransformationManagerView;
import org.eclipse.viatra.examples.cps.application.ui.transformationview.TransformationRegistry;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.IModelConnector;

public class EditorSelectionListener
implements INullSelectionListener,
IPartListener {
    private ISelection lastSelection;
    private IEditorPart lastEditor;
    private final TransformationManagerView transformationsView;

    public EditorSelectionListener(TransformationManagerView transformationsView) {
        this.transformationsView = transformationsView;
    }

    public void init(IEditorPart editorPart) {
        if (editorPart instanceof ISelectionProvider) {
            ISelection _selection = null;
            if ((ISelectionProvider)editorPart != null) {
                _selection = ((ISelectionProvider)editorPart).getSelection();
            }
            this.selectionChanged((IWorkbenchPart)editorPart, _selection);
        } else {
            this.updateTransformationViewEnablement(false);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof IEditorPart) {
            this.lastEditor = (IEditorPart)part;
            this.lastSelection = selection;
            this.refreshState();
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.updateTransformationViewEnablement(false);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.lastEditor) {
            this.updateTransformationViewEnablement(false);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void refreshState() {
        if (this.lastEditor == null) {
            this.updateTransformationViewEnablement(false);
        } else if (this.lastSelection instanceof IStructuredSelection) {
            boolean newEnabledState;
            boolean bl = newEnabledState = ((IStructuredSelection)this.lastSelection).size() == 1 && ((IStructuredSelection)this.lastSelection).getFirstElement() instanceof CPSToDeployment && Adapters.adapt((Object)this.lastEditor, IModelConnector.class) != null;
            if (newEnabledState && TransformationRegistry.getInstance().containsKey(this.lastEditor)) {
                this.updateTransformationViewEnablement(false, false);
            } else {
                this.updateTransformationViewEnablement(newEnabledState);
            }
        } else {
            this.updateTransformationViewEnablement(false);
        }
    }

    private void updateTransformationViewEnablement(boolean viewEnablement) {
        this.updateTransformationViewEnablement(viewEnablement, true);
    }

    private void updateTransformationViewEnablement(boolean viewEnablement, boolean unsetLastValues) {
        this.transformationsView.setTransformationEnabled(viewEnablement);
        if (!viewEnablement && unsetLastValues) {
            this.lastSelection = null;
            this.lastEditor = null;
        }
    }
}

