/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.xml.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.uomo.core.UOMoException;
import org.eclipse.uomo.xml.impl.XMLWriter;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMLPullWriter {
    private XMLWriter xml;

    public XMLPullWriter(OutputStream stream) throws UnsupportedEncodingException, IOException {
        this.xml = new XMLWriter(stream, "UTF-8");
        this.xml.start();
    }

    public XMLPullWriter(XMLWriter writer) throws UnsupportedEncodingException {
        this.xml = writer;
    }

    public void write(XmlPullParser xpp, boolean rootElement, String elementName, String defaultNamespace) throws UOMoException, IOException, XmlPullParserException {
        if (defaultNamespace != null) {
            if (!this.xml.namespaceDefined(defaultNamespace)) {
                this.xml.setDefaultNamespace(defaultNamespace);
            }
        } else if (rootElement) {
            this.xml.setDefaultNamespace(xpp.getNamespace());
        }
        if (elementName != null) {
            this.xml.open(defaultNamespace, elementName);
        }
        if (rootElement) {
            this.processElement(xpp);
        } else {
            this.processContents(xpp);
            if (xpp.getEventType() != 1) {
                xpp.next();
            }
        }
        if (elementName != null) {
            this.xml.close();
        }
        this.xml.flush();
    }

    private void processContents(XmlPullParser xpp) throws XmlPullParserException, UOMoException, IOException {
        while (xpp.getEventType() != 3 && xpp.getEventType() != 1) {
            if (xpp.getEventType() == 2) {
                this.processElement(xpp);
                continue;
            }
            if (xpp.getEventType() == 4) {
                this.processText(xpp);
                continue;
            }
            throw new UOMoException("unhandled event type " + Integer.toString(xpp.getEventType()));
        }
    }

    private void processElement(XmlPullParser xpp) throws UOMoException, XmlPullParserException, IOException {
        this.xml.namespace(xpp.getNamespace());
        this.processAttributes(xpp);
        this.xml.open(xpp.getNamespace(), xpp.getName());
        xpp.next();
        this.processContents(xpp);
        this.xml.close();
        if (xpp.getEventType() != 1) {
            xpp.next();
        }
    }

    private void processText(XmlPullParser xpp) throws UOMoException, XmlPullParserException, IOException {
        this.xml.text(xpp.getText());
        xpp.next();
    }

    private void processAttributes(XmlPullParser xpp) throws IOException {
        int i = 0;
        while (i < xpp.getAttributeCount()) {
            String ns = xpp.getAttributeNamespace(i);
            if (!"".equals(ns)) {
                this.xml.namespace(ns);
                this.xml.attribute(ns, xpp.getAttributeName(i), xpp.getAttributeValue(i));
            } else {
                this.xml.attribute(xpp.getAttributeName(i), xpp.getAttributeValue(i));
            }
            ++i;
        }
    }
}

