/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.ucum.special;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.uomo.ucum.special.CelsiusHandler;
import org.eclipse.uomo.ucum.special.FahrenheitHandler;
import org.eclipse.uomo.ucum.special.HoldingHandler;
import org.eclipse.uomo.ucum.special.SpecialUnitHandler;
import org.eclipse.uomo.util.Registry;

public class SpecialUnitRegistry
implements Registry<SpecialUnitHandler> {
    final Map<String, SpecialUnitHandler> handlers = new HashMap<String, SpecialUnitHandler>();

    public SpecialUnitRegistry() {
        this.init();
    }

    private void register(SpecialUnitHandler handler) {
        this.handlers.put(handler.getCode(), handler);
    }

    private void init() {
        this.register(new CelsiusHandler());
        this.register(new FahrenheitHandler());
        this.register(new HoldingHandler("[p'diop]", "deg"));
        this.register(new HoldingHandler("%[slope]", "deg"));
        this.register(new HoldingHandler("[hp_X]", "1"));
        this.register(new HoldingHandler("[hp_C]", "1"));
        this.register(new HoldingHandler("[pH]", "mol/l"));
        this.register(new HoldingHandler("Np", "1"));
        this.register(new HoldingHandler("B", "1"));
        this.register(new HoldingHandler("B[SPL]", "10*-5.Pa", new BigDecimal(2)));
        this.register(new HoldingHandler("B[V]", "V"));
        this.register(new HoldingHandler("B[mV]", "mV"));
        this.register(new HoldingHandler("B[uV]", "uV"));
        this.register(new HoldingHandler("B[W]", "W"));
        this.register(new HoldingHandler("B[kW]", "kW"));
        this.register(new HoldingHandler("bit_s", "1"));
    }

    public boolean exists(String code) {
        return this.handlers.containsKey(code);
    }

    public SpecialUnitHandler get(String code) {
        return this.handlers.get(code);
    }
}

