/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.ucum.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.uomo.ucum.Search;
import org.eclipse.uomo.ucum.model.Concept;
import org.eclipse.uomo.ucum.model.ConceptKind;
import org.eclipse.uomo.ucum.model.Prefix;
import org.eclipse.uomo.ucum.model.UcumModel;
import org.eclipse.uomo.ucum.model.UcumUnit;

class SearchImpl
implements Search {
    SearchImpl() {
    }

    @Override
    public List<Concept> doSearch(UcumModel model, ConceptKind kind, String text, boolean isRegex) {
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        if (kind == null || kind == ConceptKind.PREFIX) {
            this.searchPrefixes(concepts, model.getPrefixes(), text, isRegex);
        }
        if (kind == null || kind == ConceptKind.BASEUNIT) {
            this.searchUnits(concepts, model.getBaseUnits(), text, isRegex);
        }
        if (kind == null || kind == ConceptKind.UNIT) {
            this.searchUnits(concepts, model.getDefinedUnits(), text, isRegex);
        }
        return concepts;
    }

    private void searchUnits(List<Concept> concepts, List<? extends UcumUnit> units, String text, boolean isRegex) {
        for (UcumUnit ucumUnit : units) {
            if (!this.matchesUnit(ucumUnit, text, isRegex)) continue;
            concepts.add(ucumUnit);
        }
    }

    private boolean matchesUnit(UcumUnit unit, String text, boolean isRegex) {
        return this.matches(unit.getProperty(), text, isRegex) || this.matchesConcept(unit, text, isRegex);
    }

    private void searchPrefixes(List<Concept> concepts, List<? extends Prefix> prefixes, String text, boolean isRegex) {
        for (Concept concept : prefixes) {
            if (!this.matchesConcept(concept, text, isRegex)) continue;
            concepts.add(concept);
        }
    }

    private boolean matchesConcept(Concept concept, String text, boolean isRegex) {
        for (String name : concept.getNames()) {
            if (!this.matches(name, text, isRegex)) continue;
            return true;
        }
        if (this.matches(concept.getCode(), text, isRegex)) {
            return true;
        }
        if (this.matches(concept.getCodeUC(), text, isRegex)) {
            return true;
        }
        return this.matches(concept.getPrintSymbol(), text, isRegex);
    }

    private boolean matches(String value, String text, boolean isRegex) {
        return value != null && (isRegex && value.matches(text) || !isRegex && value.toLowerCase().contains(text.toLowerCase()));
    }
}

