/*
 * Decompiled with CFR 0.152.
 */
package si.uom;

import java.util.Set;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import si.uom.quantity.Action;
import si.uom.quantity.DynamicViscosity;
import si.uom.quantity.ElectricPermittivity;
import si.uom.quantity.IonizingRadiation;
import si.uom.quantity.KinematicViscosity;
import si.uom.quantity.Luminance;
import si.uom.quantity.MagneticFieldStrength;
import si.uom.quantity.MagneticPermeability;
import si.uom.quantity.MagnetomotiveForce;
import si.uom.quantity.Radiance;
import si.uom.quantity.RadiantIntensity;
import si.uom.quantity.WaveNumber;
import tec.uom.se.AbstractConverter;
import tec.uom.se.AbstractSystemOfUnits;
import tec.uom.se.AbstractUnit;
import tec.uom.se.format.SimpleUnitFormat;
import tec.uom.se.function.MultiplyConverter;
import tec.uom.se.function.PiMultiplierConverter;
import tec.uom.se.function.RationalConverter;
import tec.uom.se.unit.AlternateUnit;
import tec.uom.se.unit.MetricPrefix;
import tec.uom.se.unit.ProductUnit;
import tec.uom.se.unit.TransformedUnit;
import tec.uom.se.unit.Units;

public final class SI
extends Units {
    private static final SI INSTANCE = new SI();
    public static final Unit<MagnetomotiveForce> AMPERE_TURN = SI.addUnit(new AlternateUnit((Unit)AMPERE, "At"), MagnetomotiveForce.class);
    public static final Unit<Acceleration> METRE_PER_SQUARE_SECOND = SI.addUnit(new ProductUnit(METRE_PER_SECOND.divide(SECOND)), Acceleration.class);
    public static final Unit<Acceleration> METRES_PER_SQUARE_SECOND = METRE_PER_SQUARE_SECOND;
    public static final Unit<Action> JOULE_SECOND = SI.addUnit(new ProductUnit(JOULE.multiply(SECOND)), Action.class);
    public static final Unit<ElectricPermittivity> FARAD_PER_METRE = SI.addUnit(new AlternateUnit(FARAD.divide(METRE), "\u03b5"), ElectricPermittivity.class);
    public static final Unit<ElectricPermittivity> FARADS_PER_METRE = FARAD_PER_METRE;
    public static final Unit<MagneticPermeability> NEWTON_PER_SQUARE_AMPERE = SI.addUnit(new ProductUnit(NEWTON.divide(AMPERE.pow(2))), MagneticPermeability.class);
    public static final Unit<WaveNumber> RECIPROCAL_METRE = SI.addUnit(new ProductUnit(METRE.pow(-1)), WaveNumber.class);
    public static final Unit<DynamicViscosity> PASCAL_SECOND = SI.addUnit(new ProductUnit(PASCAL.multiply(SECOND)), DynamicViscosity.class);
    public static final Unit<Luminance> CANDELA_PER_SQUARE_METRE = SI.addUnit(new ProductUnit(CANDELA.divide(SQUARE_METRE)), Luminance.class);
    public static final Unit<KinematicViscosity> SQUARE_METRE_PER_SECOND = SI.addUnit(new ProductUnit(SQUARE_METRE.divide(SECOND)), KinematicViscosity.class);
    public static final Unit<KinematicViscosity> SQUARE_METRES_PER_SECOND = SQUARE_METRE_PER_SECOND;
    public static final Unit<MagneticFieldStrength> AMPERE_PER_METRE = SI.addUnit(new ProductUnit(AMPERE.divide(METRE)), MagneticFieldStrength.class);
    public static final Unit<MagneticFieldStrength> AMPERES_PER_METRE = AMPERE_PER_METRE;
    public static final Unit<IonizingRadiation> COULOMB_PER_KILOGRAM = SI.addUnit(new ProductUnit(COULOMB.divide((AbstractUnit)KILOGRAM)), IonizingRadiation.class);
    public static final Unit<IonizingRadiation> COULOMBS_PER_KILOGRAM = COULOMB_PER_KILOGRAM;
    public static final Unit<RadiantIntensity> WATT_PER_STERADIAN = SI.addUnit(WATT.divide((AbstractUnit)STERADIAN).asType(RadiantIntensity.class));
    public static final Unit<Radiance> WATT_PER_STERADIAN_PER_SQUARE_METRE = SI.addUnit(WATT_PER_STERADIAN.divide(SQUARE_METRE).asType(Radiance.class));
    public static final Unit<Angle> DEGREE_ANGLE = SI.addUnit(new TransformedUnit(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1L, 180L))));
    public static final Unit<Angle> MINUTE_ANGLE = SI.addUnit(new TransformedUnit(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1L, 10800L))));
    public static final Unit<Angle> SECOND_ANGLE = SI.addUnit(new TransformedUnit(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1L, 648000L))));
    public static final Unit<Mass> TONNE = AbstractSystemOfUnits.Helper.addUnit((Set)SI.INSTANCE.units, (Unit)new TransformedUnit((Unit)KILOGRAM, (UnitConverter)new RationalConverter(1000L, 1L)), (String)"Tonne", (String)"t");
    public static final Unit<Energy> ELECTRON_VOLT = new TransformedUnit((Unit)JOULE, (UnitConverter)new MultiplyConverter(1.602176487E-19));
    public static final Unit<Mass> UNIFIED_ATOMIC_MASS = SI.addUnit(new TransformedUnit((Unit)KILOGRAM, (UnitConverter)new MultiplyConverter(1.660538782E-27)), "Unified atomic mass", "u", true);
    public static final Unit<Length> ASTRONOMICAL_UNIT = SI.addUnit(new TransformedUnit(METRE, (UnitConverter)new MultiplyConverter(1.49597871E11)));
    public static final Unit<Angle> REVOLUTION = SI.addUnit(new TransformedUnit(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(2L, 1L))));
    public static final Unit<Area> HECTARE = new TransformedUnit(SQUARE_METRE, (UnitConverter)new RationalConverter(10000L, 1L));

    private SI() {
    }

    public static SI getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return SI.class.getSimpleName();
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text, boolean isLabel) {
        if (isLabel) {
            SimpleUnitFormat.getInstance().label(unit, text);
        }
        if (name != null && unit instanceof AbstractUnit) {
            return (U)AbstractSystemOfUnits.Helper.addUnit((Set)SI.INSTANCE.units, unit, (String)name);
        }
        SI.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String text, boolean isLabel) {
        return SI.addUnit(unit, null, text, isLabel);
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        SI.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, Class<? extends Quantity<?>> type) {
        SI.INSTANCE.units.add(unit);
        SI.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }

    static {
        SimpleUnitFormat.getInstance().label(TONNE, "t");
        SimpleUnitFormat.getInstance().label(MetricPrefix.MEGA(TONNE), "Mt");
    }
}

