/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl;

import com.ibm.icu.util.Measure;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.impl.DimensionImpl;
import org.unitsofmeasurement.quantity.Quantity;
import org.unitsofmeasurement.unit.Dimension;
import org.unitsofmeasurement.unit.IncommensurableException;
import org.unitsofmeasurement.unit.UnconvertibleException;
import org.unitsofmeasurement.unit.Unit;
import org.unitsofmeasurement.unit.UnitConverter;

public final class ProductUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q>
implements Unit<Q> {
    private static final long serialVersionUID = -736056598162783537L;
    private final Element[] elements;
    private int hashCode;

    public ProductUnit() {
        this.elements = new Element[0];
    }

    public ProductUnit(Unit<?> productUnit) {
        this.elements = ((ProductUnit)productUnit).elements;
    }

    private ProductUnit(Element[] elements) {
        this.elements = elements;
    }

    private static Unit<?> getInstance(Element[] leftElems, Element[] rightElems) {
        Unit unit;
        Element[] result = new Element[leftElems.length + rightElems.length];
        int resultIndex = 0;
        int i = 0;
        while (i < leftElems.length) {
            unit = leftElems[i].unit;
            int p1 = leftElems[i].pow;
            int r1 = leftElems[i].root;
            int p2 = 0;
            int r2 = 1;
            int j = 0;
            while (j < rightElems.length) {
                if (unit.equals(rightElems[j].unit)) {
                    p2 = rightElems[j].pow;
                    r2 = rightElems[j].root;
                    break;
                }
                ++j;
            }
            int pow = p1 * r2 + p2 * r1;
            int root = r1 * r2;
            if (pow != 0) {
                int gcd = ProductUnit.gcd(Math.abs(pow), root);
                result[resultIndex++] = new Element(unit, pow / gcd, root / gcd);
            }
            ++i;
        }
        i = 0;
        while (i < rightElems.length) {
            unit = (AbstractUnit)rightElems[i].unit;
            boolean hasBeenMerged = false;
            int j = 0;
            while (j < leftElems.length) {
                if (unit.equals(leftElems[j].unit)) {
                    hasBeenMerged = true;
                    break;
                }
                ++j;
            }
            if (!hasBeenMerged) {
                result[resultIndex++] = rightElems[i];
            }
            ++i;
        }
        if (resultIndex == 0) {
            return AbstractUnit.ONE;
        }
        if (resultIndex == 1 && result[0].pow == result[0].root) {
            return result[0].unit;
        }
        Element[] elems = new Element[resultIndex];
        int i2 = 0;
        while (i2 < resultIndex) {
            elems[i2] = result[i2];
            ++i2;
        }
        return new ProductUnit(elems);
    }

    public static Unit<?> getProductInstance(Unit<?> left, Unit<?> right) {
        Element[] leftElems = left instanceof ProductUnit ? ((ProductUnit)left).elements : new Element[]{new Element(left, 1, 1)};
        Element[] rightElems = right instanceof ProductUnit ? ((ProductUnit)right).elements : new Element[]{new Element(right, 1, 1)};
        return ProductUnit.getInstance(leftElems, rightElems);
    }

    public static Unit<?> getQuotientInstance(Unit<?> left, Unit<?> right) {
        Element[] rightElems;
        Element[] leftElems = left instanceof ProductUnit ? ((ProductUnit)left).elements : new Element[]{new Element(left, 1, 1)};
        if (right instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)right).elements;
            rightElems = new Element[elems.length];
            int i = 0;
            while (i < elems.length) {
                rightElems[i] = new Element(elems[i].unit, -elems[i].pow, elems[i].root);
                ++i;
            }
        } else {
            rightElems = new Element[]{new Element(right, -1, 1)};
        }
        return (AbstractUnit)ProductUnit.getInstance(leftElems, rightElems);
    }

    public static Unit<?> getRootInstance(Unit<?> unit, int n) {
        Element[] unitElems;
        if (unit instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)unit).elements;
            unitElems = new Element[elems.length];
            int i = 0;
            while (i < elems.length) {
                int gcd = ProductUnit.gcd(Math.abs(elems[i].pow), elems[i].root * n);
                unitElems[i] = new Element(elems[i].unit, elems[i].pow / gcd, elems[i].root * n / gcd);
                ++i;
            }
        } else {
            unitElems = new Element[]{new Element(unit, 1, n)};
        }
        return ProductUnit.getInstance(unitElems, new Element[0]);
    }

    static Unit<?> getPowInstance(AbstractUnit<?> unit, int n) {
        Element[] unitElems;
        if (unit instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)unit).elements;
            unitElems = new Element[elems.length];
            int i = 0;
            while (i < elems.length) {
                int gcd = ProductUnit.gcd(Math.abs(elems[i].pow * n), elems[i].root);
                unitElems[i] = new Element(elems[i].unit, elems[i].pow * n / gcd, elems[i].root / gcd);
                ++i;
            }
        } else {
            unitElems = new Element[]{new Element(unit, n, 1)};
        }
        return ProductUnit.getInstance(unitElems, new Element[0]);
    }

    public int getUnitCount() {
        return this.elements.length;
    }

    public Unit<? extends Measure> getUnit(int index) {
        return this.elements[index].getUnit();
    }

    public int getUnitPow(int index) {
        return this.elements[index].getPow();
    }

    public int getUnitRoot(int index) {
        return this.elements[index].getRoot();
    }

    @Override
    public Map<Unit<?>, Integer> getProductUnits() {
        HashMap units = new HashMap();
        int i = 0;
        while (i < this.getUnitCount()) {
            units.put(this.getUnit(i), this.getUnitPow(i));
            ++i;
        }
        return units;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof ProductUnit)) {
            return false;
        }
        Element[] elems = ((ProductUnit)that).elements;
        if (this.elements.length != elems.length) {
            return false;
        }
        int i = 0;
        while (i < this.elements.length) {
            boolean unitFound = false;
            Element e = this.elements[i];
            int j = 0;
            while (j < elems.length) {
                if (e.unit.equals(elems[j].unit)) {
                    if (e.pow != elems[j].pow || e.root != elems[j].root) {
                        return false;
                    }
                    unitFound = true;
                    break;
                }
                ++j;
            }
            if (!unitFound) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int code = 0;
        int i = 0;
        while (i < this.elements.length) {
            code += this.elements[i].unit.hashCode() * (this.elements[i].pow * 3 - this.elements[i].root * 2);
            ++i;
        }
        this.hashCode = code;
        return code;
    }

    @Override
    public final UnitConverter getConverterToMetric() {
        if (this.hasOnlyUnscaledMetricUnits()) {
            return AbstractConverter.IDENTITY;
        }
        UnitConverter converter = AbstractConverter.IDENTITY;
        int i = 0;
        while (i < this.elements.length) {
            Element e = this.elements[i];
            UnitConverter cvtr = ((AbstractUnit)e.unit).getConverterToMetric();
            if (!cvtr.isLinear()) {
                throw new UnsupportedOperationException(e.unit + " is non-linear, cannot convert");
            }
            if (e.root != 1) {
                throw new UnsupportedOperationException(e.unit + " holds a base unit with fractional exponent");
            }
            int pow = e.pow;
            if (pow < 0) {
                pow = -pow;
                cvtr = cvtr.inverse();
            }
            int j = 0;
            while (j < pow) {
                converter = converter.concatenate(cvtr);
                ++j;
            }
            ++i;
        }
        return converter;
    }

    private boolean hasOnlyUnscaledMetricUnits() {
        int i = 0;
        while (i < this.elements.length) {
            AbstractUnit u = (AbstractUnit)this.elements[i].unit;
            if (!u.isUnscaledMetric()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Dimension getDimension() {
        Dimension dimension = DimensionImpl.NONE;
        int i = 0;
        while (i < this.getUnitCount()) {
            Unit<Measure> unit = this.getUnit(i);
            Dimension d = unit.getDimension().pow(this.getUnitPow(i)).root(this.getUnitRoot(i));
            dimension = dimension.multiply(d);
            ++i;
        }
        return dimension;
    }

    @Override
    public UnitConverter getDimensionalTransform() {
        UnitConverter converter = AbstractConverter.IDENTITY;
        int i = 0;
        while (i < this.getUnitCount()) {
            AbstractUnit unit = (AbstractUnit)this.getUnit(i);
            UnitConverter cvtr = unit.getDimensionalTransform();
            if (!cvtr.isLinear()) {
                throw new UnsupportedOperationException(cvtr.getClass() + " is non-linear, cannot convert product unit");
            }
            if (this.getUnitRoot(i) != 1) {
                throw new UnsupportedOperationException(this + " holds a unit with fractional exponent");
            }
            int pow = this.getUnitPow(i);
            if (pow < 0) {
                pow = -pow;
                cvtr = cvtr.inverse();
            }
            int j = 0;
            while (j < pow) {
                converter = converter.concatenate(cvtr);
                ++j;
            }
            ++i;
        }
        return converter;
    }

    private static int gcd(int m, int n) {
        if (n == 0) {
            return m;
        }
        return ProductUnit.gcd(n, m % n);
    }

    @Override
    public UnitConverter getConverterToAny(Unit<?> arg0) {
        if (this.hasOnlyUnscaledMetricUnits()) {
            return AbstractConverter.IDENTITY;
        }
        UnitConverter converter = AbstractConverter.IDENTITY;
        int i = 0;
        while (i < this.elements.length) {
            UnitConverter cvtr;
            Element e = this.elements[i];
            try {
                cvtr = e.unit.getConverterToAny((Unit)this);
            }
            catch (UnconvertibleException e1) {
                throw e1;
            }
            catch (IncommensurableException e1) {
                throw new UnsupportedOperationException(e1);
            }
            if (!cvtr.isLinear()) {
                throw new UnsupportedOperationException(e.unit + " is non-linear, cannot convert");
            }
            if (e.root != 1) {
                throw new UnsupportedOperationException(e.unit + " holds a base unit with fractional exponent");
            }
            int pow = e.pow;
            if (pow < 0) {
                pow = -pow;
                cvtr = cvtr.inverse();
            }
            int j = 0;
            while (j < pow) {
                converter = converter.concatenate(cvtr);
                ++j;
            }
            ++i;
        }
        return converter;
    }

    @Override
    protected Unit<Q> toMetric() {
        if (this.hasOnlyUnscaledMetricUnits()) {
            return this;
        }
        Unit systemUnit = AbstractUnit.ONE;
        int i = 0;
        while (i < this.elements.length) {
            Unit unit = this.elements[i].unit.getSystemUnit();
            unit = unit.pow(this.elements[i].pow);
            unit = unit.root(this.elements[i].root);
            systemUnit = systemUnit.multiply(unit);
            ++i;
        }
        return systemUnit;
    }

    public Unit<Q> getSystemUnit() {
        return this.toMetric();
    }

    private static final class Element
    implements Serializable {
        private static final long serialVersionUID = 1649532173171667701L;
        private final Unit<?> unit;
        private final int pow;
        private final int root;

        private Element(Unit<?> unit, int pow, int root) {
            this.unit = unit;
            this.pow = pow;
            this.root = root;
        }

        public Unit<?> getUnit() {
            return this.unit;
        }

        public int getPow() {
            return this.pow;
        }

        public int getRoot() {
            return this.root;
        }
    }
}

