/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units;

import java.math.BigInteger;
import org.eclipse.uomo.units.impl.converter.RationalConverter;
import org.unitsofmeasurement.quantity.Quantity;
import org.unitsofmeasurement.unit.Unit;
import org.unitsofmeasurement.unit.UnitConverter;

public final class BinaryPrefix {
    private static int K = 1024;
    private static int K2 = 0x100000;
    private static int K3 = 0x40000000;
    private static RationalConverter K70 = new RationalConverter(BigInteger.valueOf(2L).pow(70), BigInteger.ONE);
    private static RationalConverter K80 = new RationalConverter(BigInteger.valueOf(2L).pow(80), BigInteger.ONE);

    private BinaryPrefix() {
    }

    public static <Q extends Quantity<Q>> Unit<?> KIBI(Unit<?> unit) {
        return unit.multiply((double)K);
    }

    public static <Q extends Quantity<Q>> Unit<?> MEBI(Unit<?> unit) {
        return unit.multiply((double)K2);
    }

    public static final <Q extends Quantity<Q>> Unit<?> GIBI(Unit<?> unit) {
        return unit.multiply((double)K3);
    }

    public static <Q extends Quantity<Q>> Unit<?> TEBI(Unit<?> unit) {
        return unit.multiply(1.099511627776E12);
    }

    public static <Q extends Quantity<Q>> Unit<?> PEBI(Unit<?> unit) {
        return unit.multiply(1.125899906842624E15);
    }

    public static <Q extends Quantity<Q>> Unit<?> EXBI(Unit<?> unit) {
        return unit.multiply(1.152921504606847E18);
    }

    public static <Q extends Quantity<Q>> Unit<?> ZEBI(Unit<?> unit) {
        return unit.transform((UnitConverter)K70);
    }

    public static <Q extends Quantity<Q>> Unit<?> YOBI(Unit<?> unit) {
        return unit.transform((UnitConverter)K80);
    }

    public static <Q extends Quantity<Q>> Unit<?> JEDEC_KILO(Unit<?> unit) {
        return unit.multiply((double)K);
    }

    public static <Q extends Quantity<Q>> Unit<?> JEDEC_MEGA(Unit<?> unit) {
        return unit.multiply((double)K2);
    }

    public static <Q extends Quantity<Q>> Unit<?> JEDEC_GIGA(Unit<?> unit) {
        return unit.multiply((double)K3);
    }
}

