/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class CtfCoreLoggerUtil {
    public static final boolean IS_PLATFORM_RUNNING;
    private static Logger LOGGER;
    public static final String PLUGIN_ID = "org.eclipse.tracecompass.ctf.core";

    static {
        boolean result = false;
        try {
            result = Platform.isRunning();
        }
        catch (Exception exception) {
            // empty catch block
        }
        IS_PLATFORM_RUNNING = result;
        if (!result) {
            LOGGER = Logger.getLogger(CtfCoreLoggerUtil.class.getName());
        }
    }

    private CtfCoreLoggerUtil() {
    }

    public static void logInfo(String msg) {
        if (IS_PLATFORM_RUNNING) {
            Platform.getLog(CtfCoreLoggerUtil.class).log((IStatus)new Status(1, PLUGIN_ID, msg));
        } else {
            LOGGER.log(Level.INFO, msg);
        }
    }

    public static void logError(String msg, Exception e) {
        if (IS_PLATFORM_RUNNING) {
            Platform.getLog(CtfCoreLoggerUtil.class).log((IStatus)new Status(4, PLUGIN_ID, 0, msg, (Throwable)e));
        } else {
            LOGGER.log(Level.SEVERE, msg, e);
        }
    }

    public static void logWarning(String msg) {
        if (IS_PLATFORM_RUNNING) {
            Platform.getLog(CtfCoreLoggerUtil.class).log((IStatus)new Status(2, PLUGIN_ID, msg));
        } else {
            LOGGER.log(Level.WARNING, msg);
        }
    }
}

