/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.tree;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.common.core.format.DataSizeWithUnitFormat;
import org.eclipse.tracecompass.common.core.format.DataSpeedWithUnitFormat;
import org.eclipse.tracecompass.common.core.format.DecimalUnitFormat;
import org.eclipse.tracecompass.common.core.format.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.profiling.core.tree.DefaultDataPalette;
import org.eclipse.tracecompass.internal.analysis.profiling.core.tree.DepthGroupDescriptor;
import org.eclipse.tracecompass.internal.analysis.profiling.core.tree.WeightedTree;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.base.IDataPalette;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.tree.ITree;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.tree.IWeightedTreeSet;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;

public interface IWeightedTreeProvider<@NonNull N, E, @NonNull T extends WeightedTree<N>> {
    public static final MetricType WEIGHT_TYPE = new MetricType("Weight", DataType.NUMBER, null);

    default public @Nullable IWeightedTreeSet<N, E, T> getSelection(ITmfTimestamp start, ITmfTimestamp end) {
        return null;
    }

    public IWeightedTreeSet<N, E, T> getTreeSet();

    default public MetricType getWeightType() {
        return WEIGHT_TYPE;
    }

    default public List<MetricType> getAdditionalMetrics() {
        return Collections.emptyList();
    }

    default public Object getAdditionalMetric(T object, int metricIndex) {
        throw new UnsupportedOperationException("If the tree provider has metric, it should implement this method, or it should not be called");
    }

    default public @Nullable IStatistics<?> getStatistics(T object, int metricIndex) {
        if (metricIndex < 0) {
            if (this.getWeightType().hasStatistics()) {
                return ((WeightedTree)object).getStatistics(metricIndex);
            }
            return null;
        }
        List<MetricType> metrics = this.getAdditionalMetrics();
        if (metricIndex >= metrics.size()) {
            return null;
        }
        MetricType metricType = metrics.get(metricIndex);
        if (!metricType.hasStatistics()) {
            return null;
        }
        return ((WeightedTree)object).getStatistics(metricIndex);
    }

    default public List<String> getExtraDataSets() {
        return Collections.emptyList();
    }

    default public String toDisplayString(T tree) {
        return String.valueOf(((WeightedTree)tree).getObject());
    }

    public String getTitle();

    default public @Nullable IWeightedTreeGroupDescriptor getGroupDescriptor() {
        IWeightedTreeSet<@NonNull N, E, @NonNull T> treeSet = this.getTreeSet();
        Collection<E> elements = treeSet.getElements();
        int lvl = 0;
        for (E element : elements) {
            if (!(element instanceof ITree)) continue;
            lvl = Math.max(lvl, ITree.getDepth((ITree)element));
        }
        if (lvl == 0) {
            return null;
        }
        return DepthGroupDescriptor.createChainForDepth(lvl - 1);
    }

    default public IDataPalette getPalette() {
        return DefaultDataPalette.getInstance();
    }

    public static enum DataType {
        NUMBER((Format)new DecimalUnitFormat()),
        NANOSECONDS(SubSecondTimeWithUnitFormat.getInstance()),
        BYTES(DataSizeWithUnitFormat.getInstance()),
        BINARY_SPEED(DataSpeedWithUnitFormat.getInstance()),
        OTHER(new Format(){
            private static final long serialVersionUID = 1L;

            @Override
            public StringBuffer format(@Nullable Object obj, @Nullable StringBuffer toAppendTo, @Nullable FieldPosition pos) {
                if (toAppendTo == null) {
                    return new StringBuffer(String.valueOf(obj));
                }
                return Objects.requireNonNull(toAppendTo.append(String.valueOf(obj)));
            }

            @Override
            public @Nullable Object parseObject(@Nullable String source, @Nullable ParsePosition pos) {
                return null;
            }
        });

        private Format fFormatter;

        private DataType(Format formatter) {
            this.fFormatter = formatter;
        }

        public String format(Object object) {
            return String.valueOf(this.fFormatter.format(object));
        }
    }

    public static class MetricType {
        private final String fTitle;
        private final DataType fDataType;
        private final @Nullable Format fFormatter;
        private final boolean fHasStatistics;

        public MetricType(String title, DataType dataType, @Nullable Format format) {
            this(title, dataType, format, false);
        }

        public MetricType(String title, DataType dataType, @Nullable Format format, boolean hasStatistics) {
            this.fTitle = title;
            this.fDataType = dataType;
            this.fFormatter = format;
            this.fHasStatistics = hasStatistics;
        }

        public String getTitle() {
            return this.fTitle;
        }

        public DataType getDataType() {
            return this.fDataType;
        }

        public String format(Object obj) {
            if (this.fFormatter != null) {
                return Objects.requireNonNull(this.fFormatter.format(obj));
            }
            return this.fDataType.format(obj);
        }

        public boolean hasStatistics() {
            return this.fHasStatistics;
        }
    }
}

