/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.callgraph2;

import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AbstractCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.CalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.CalledFunctionFactory;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.CalledStringFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ModelManager;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.model.IHostModel;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CalledFunctionTest {
    private final @NonNull IHostModel fModel = ModelManager.getModelFor((String)"test");
    private CalledStringFunction fFixture = null;
    private ICalledFunction f42Fixture;
    private ICalledFunction fHiFixture;

    @Before
    public void setup() {
        CalledStringFunction fixture = CalledFunctionFactory.create((long)10L, (long)1010L, (String)"Hello", (int)0, (int)0, null, (IHostModel)this.fModel);
        Assert.assertTrue((boolean)(fixture instanceof CalledStringFunction));
        this.fFixture = fixture;
        AbstractCalledFunction fixture42 = CalledFunctionFactory.create((long)400L, (long)500L, (Object)66L, (int)0, (int)0, (ICalledFunction)this.fFixture, (IHostModel)this.fModel);
        this.f42Fixture = fixture42;
        CalledStringFunction hiFixture = CalledFunctionFactory.create((long)20L, (long)50L, (String)"Hi", (int)0, (int)0, (ICalledFunction)this.fFixture, (IHostModel)this.fModel);
        this.fHiFixture = hiFixture;
    }

    @After
    public void after() {
        ModelManager.disposeModels();
    }

    public void createValid() {
        Assert.assertNotNull((Object)CalledFunctionFactory.create((long)0L, (long)0L, (Object)0L, (int)0, (int)0, null, (IHostModel)this.fModel));
        Assert.assertNotNull((Object)CalledFunctionFactory.create((long)0L, (long)0L, (Object)0, (int)0, (int)0, null, (IHostModel)this.fModel));
        Assert.assertNotNull((Object)CalledFunctionFactory.create((long)0L, (long)0L, (String)"", (int)0, (int)0, null, (IHostModel)this.fModel));
    }

    @Test
    public void createInvalidDouble() {
        Assert.assertNotNull((Object)CalledFunctionFactory.create((long)0L, (long)0L, (Object)3.14, (int)0, (int)0, null, (IHostModel)this.fModel));
    }

    @Test(expected=IllegalArgumentException.class)
    public void createInvalidNull() {
        CalledFunctionFactory.create((long)0L, (long)0L, null, (int)0, (int)0, null, (IHostModel)this.fModel);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createInvalidTimeRange() {
        CalledFunctionFactory.create((long)10L, (long)-10L, (String)"", (int)0, (int)0, null, (IHostModel)this.fModel);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createInvalidTimeRangeStateLong() {
        CalledFunctionFactory.create((long)10L, (long)-10L, (Object)42L, (int)0, (int)0, null, (IHostModel)this.fModel);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createInvalidTimeRangeStateInteger() {
        CalledFunctionFactory.create((long)10L, (long)-10L, (Object)42, (int)0, (int)0, null, (IHostModel)this.fModel);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createInvalidTimeRangeStateString() {
        CalledFunctionFactory.create((long)10L, (long)-10L, (String)"42", (int)0, (int)0, null, (IHostModel)this.fModel);
    }

    @Test
    public void testAddChildOk1() {
        CalledStringFunction fixture = this.fFixture;
        ICalledFunction hiFixture = this.fHiFixture;
        ICalledFunction fixture42 = this.f42Fixture;
        Assert.assertNotNull((Object)fixture);
        Assert.assertNotNull((Object)hiFixture);
        Assert.assertNotNull((Object)fixture42);
        long fixtureST = fixture.getSelfTime();
        long hiFixtureST = hiFixture.getSelfTime();
        long fixture42ST = fixture42.getSelfTime();
        CalledFunction newchild = (CalledFunction)CalledFunctionFactory.create((long)100L, (long)200L, (Object)100, (int)0, (int)0, (ICalledFunction)this.fFixture, (IHostModel)this.fModel);
        Assert.assertEquals((long)(fixtureST - newchild.getLength()), (long)fixture.getSelfTime());
        Assert.assertEquals((long)hiFixtureST, (long)hiFixture.getSelfTime());
        Assert.assertEquals((long)fixture42ST, (long)fixture42.getSelfTime());
    }

    @Test
    public void testAddChildOk2() {
        CalledStringFunction fixture = this.fFixture;
        ICalledFunction hiFixture = this.fHiFixture;
        ICalledFunction fixture42 = this.f42Fixture;
        Assert.assertNotNull((Object)fixture);
        Assert.assertNotNull((Object)hiFixture);
        Assert.assertNotNull((Object)fixture42);
        long fixtureST = fixture.getSelfTime();
        long hiFixtureST = hiFixture.getSelfTime();
        long fixture42ST = fixture42.getSelfTime();
        CalledStringFunction newchild = CalledFunctionFactory.create((long)450L, (long)490L, (String)"OK", (int)0, (int)0, (ICalledFunction)this.f42Fixture, (IHostModel)this.fModel);
        Assert.assertEquals((long)fixtureST, (long)fixture.getSelfTime());
        Assert.assertEquals((long)hiFixtureST, (long)hiFixture.getSelfTime());
        Assert.assertEquals((long)(fixture42ST - newchild.getLength()), (long)fixture42.getSelfTime());
    }

    @Test
    public void testAddChildOk3() {
        CalledStringFunction fixture = this.fFixture;
        ICalledFunction hiFixture = this.fHiFixture;
        ICalledFunction fixture42 = this.f42Fixture;
        Assert.assertNotNull((Object)fixture);
        Assert.assertNotNull((Object)hiFixture);
        Assert.assertNotNull((Object)fixture42);
        long fixtureST = fixture.getSelfTime();
        long hiFixtureST = hiFixture.getSelfTime();
        long fixture42ST = fixture42.getSelfTime();
        CalledStringFunction newchild = CalledFunctionFactory.create((long)450L, (long)490L, (String)"OK", (int)0, (int)0, (ICalledFunction)this.fHiFixture, (IHostModel)this.fModel);
        Assert.assertEquals((long)fixtureST, (long)fixture.getSelfTime());
        Assert.assertEquals((long)(hiFixtureST - newchild.getLength()), (long)hiFixture.getSelfTime());
        Assert.assertEquals((long)fixture42ST, (long)fixture42.getSelfTime());
    }

    @Test
    public void testCompareTo() {
        CalledStringFunction fixture = this.fFixture;
        Assert.assertEquals((long)0L, (long)fixture.compareTo((ISegment)fixture));
        Assert.assertTrue((fixture.compareTo((ISegment)this.f42Fixture) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.f42Fixture.compareTo((ISegment)fixture) > 0 ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCompareToBad() {
        CalledStringFunction fixture = this.fFixture;
        Assert.assertTrue((fixture.compareTo(null) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)this.fFixture, (Object)this.fFixture);
        Assert.assertEquals((Object)this.fHiFixture, (Object)CalledFunctionFactory.create((long)20L, (long)50L, (String)"Hi", (int)0, (int)0, (ICalledFunction)this.fFixture, (IHostModel)this.fModel));
        Assert.assertNotEquals((Object)this.fFixture, (Object)this.f42Fixture);
        Assert.assertNotEquals((Object)this.fFixture, (Object)this.fHiFixture);
        Assert.assertNotEquals((Object)this.fFixture, null);
        Assert.assertNotEquals((Object)this.fFixture, new ArrayList());
    }

    @Test
    public void testGetEnd() {
        Assert.assertEquals((long)1010L, (long)this.fFixture.getEnd());
        Assert.assertEquals((long)50L, (long)this.fHiFixture.getEnd());
        Assert.assertEquals((long)500L, (long)this.f42Fixture.getEnd());
    }

    @Test
    public void testGetParent() {
        Assert.assertEquals(null, (Object)this.fFixture.getParent());
        Assert.assertEquals((Object)this.fFixture, (Object)this.f42Fixture.getParent());
        Assert.assertEquals((Object)this.fFixture, (Object)this.fHiFixture.getParent());
    }

    @Test
    public void testGetProcessId() {
        Assert.assertEquals((long)0L, (long)this.fFixture.getProcessId());
        Assert.assertEquals((long)0L, (long)this.fHiFixture.getProcessId());
        Assert.assertEquals((long)0L, (long)this.f42Fixture.getProcessId());
    }

    @Test
    public void testGetSelfTime() {
        Assert.assertEquals((long)870L, (long)this.fFixture.getSelfTime());
        Assert.assertEquals((long)30L, (long)this.fHiFixture.getSelfTime());
        Assert.assertEquals((long)100L, (long)this.f42Fixture.getSelfTime());
    }

    @Test
    public void testGetStart() {
        Assert.assertEquals((long)10L, (long)this.fFixture.getStart());
        Assert.assertEquals((long)20L, (long)this.fHiFixture.getStart());
        Assert.assertEquals((long)400L, (long)this.f42Fixture.getStart());
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)this.f42Fixture.hashCode(), (long)this.f42Fixture.hashCode());
        AbstractCalledFunction calledFunction = CalledFunctionFactory.create((long)400L, (long)500L, (Object)66L, (int)0, (int)0, (ICalledFunction)this.fFixture, (IHostModel)this.fModel);
        Assert.assertEquals((Object)this.f42Fixture, (Object)calledFunction);
        Assert.assertEquals((long)this.f42Fixture.hashCode(), (long)calledFunction.hashCode());
        calledFunction = CalledFunctionFactory.create((long)20L, (long)50L, (String)"Hi", (int)0, (int)0, (ICalledFunction)this.fFixture, (IHostModel)this.fModel);
        Assert.assertEquals((Object)this.fHiFixture, (Object)calledFunction);
        Assert.assertEquals((long)this.fHiFixture.hashCode(), (long)calledFunction.hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"[10, 1010] Duration: 1000, Self Time: 870", (Object)this.fFixture.toString());
        Assert.assertEquals((Object)"[400, 500] Duration: 100, Self Time: 100", (Object)this.f42Fixture.toString());
        Assert.assertEquals((Object)"[20, 50] Duration: 30, Self Time: 30", (Object)this.fHiFixture.toString());
    }
}

