/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.modelhandler;

import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.EmbeddedTypeHandler;
import org.eclipse.wst.sse.core.internal.util.Assert;

public class EmbeddedTypeRegistryReader {
    protected String ATT_CLASS = "class";
    protected String EXTENSION_POINT_ID = "embeddedTypeHandler";
    protected String PLUGIN_ID = "org.eclipse.wst.sse.core";
    protected String TAG_NAME = "embeddedTypeHandler";

    EmbeddedTypeRegistryReader() {
    }

    protected EmbeddedTypeHandler readElement(IConfigurationElement element) {
        EmbeddedTypeHandler contentTypeDescription = null;
        if (element.getName().equals(this.TAG_NAME)) {
            try {
                contentTypeDescription = (EmbeddedTypeHandler)element.createExecutableExtension(this.ATT_CLASS);
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        Assert.isNotNull(contentTypeDescription, "Error reading content type description");
        return contentTypeDescription;
    }

    void readRegistry(Set set) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint(this.PLUGIN_ID, this.EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                EmbeddedTypeHandler embeddedContentType = this.readElement(elements[i]);
                if (embeddedContentType != null) {
                    set.add(embeddedContentType);
                }
                ++i;
            }
        }
    }
}

