/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.stream;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IEventHeaderDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.CtfCoreLoggerUtil;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFJsonMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonDataStreamMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.Messages;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeSpecifierListParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.stream.StreamIdParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.trace.CTFStream;

public final class StreamDeclarationParser
extends AbstractScopedCommonTreeParser {
    private static final String IDENTIFIER_MUST_BE_A_STRING = "Left side of CTF assignment must be a string";
    private static final String PACKET_CONTEXT = "packet.context ";
    private static final String EVENT_CONTEXT = "event.context ";
    private static final String EVENT_HEADER = "event.header ";
    private static final String STREAM_ID = "stream id ";
    private static final String EXPECTS_A_STRUCT = "expects a struct";
    private static final String SCOPE_NOT_FOUND = "scope not found";
    private static final String EXPECTS_A_TYPE_SPECIFIER = "expects a type specifier";
    private static final String ALREADY_DEFINED = "already defined";
    public static final StreamDeclarationParser INSTANCE = new StreamDeclarationParser();

    private StreamDeclarationParser() {
    }

    @Override
    public CTFStream parse(ICTFMetadataNode streamDecl, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        CTFStream stream = ((Param)param).fStream;
        CTFTrace fTrace = ((Param)param).fTrace;
        if (streamDecl instanceof CTFJsonMetadataNode) {
            JsonStructureFieldMetadataNode packetContext;
            JsonStructureFieldMetadataNode eventContext;
            JsonStructureFieldMetadataNode eventHeader;
            JsonDataStreamMetadataNode decl = (JsonDataStreamMetadataNode)streamDecl;
            if (decl.getId() >= 0) {
                long streamId = decl.getId();
                stream.setId(streamId);
            }
            if ((eventHeader = decl.getEventRecordHeaderClass()) != null) {
                IDeclaration eventHeaderDecl = TypeSpecifierListParser.INSTANCE.parse(eventHeader, new TypeSpecifierListParser.Param(fTrace, null, null, scope));
                DeclarationScope eventHeaderScope = StreamDeclarationParser.lookupStructName(eventHeader, scope);
                StreamDeclarationParser.verifyEventHeaderScope(eventHeaderScope);
                StreamDeclarationParser.setEventHeader(stream, eventHeaderDecl);
            }
            if ((eventContext = decl.getEventRecordCommonContextClass()) != null) {
                IDeclaration eventContextDecl = TypeSpecifierListParser.INSTANCE.parse(eventContext, new TypeSpecifierListParser.Param(fTrace, null, null, scope));
                StreamDeclarationParser.verifyEventContext(eventContextDecl);
                stream.setEventContext((StructDeclaration)eventContextDecl);
            }
            if ((packetContext = decl.getPacketContextFieldClass()) != null) {
                IDeclaration packetContextDecl = TypeSpecifierListParser.INSTANCE.parse(packetContext, new TypeSpecifierListParser.Param(fTrace, null, null, scope));
                StreamDeclarationParser.verifyPacketContext(packetContextDecl);
                stream.setPacketContext((StructDeclaration)packetContextDecl);
            }
        } else {
            ICTFMetadataNode leftNode = streamDecl.getChild(0);
            ICTFMetadataNode rightNode = streamDecl.getChild(1);
            List<ICTFMetadataNode> leftStrings = leftNode.getChildren();
            if (!TsdlUtils.isAnyUnaryString(leftStrings.get(0))) {
                throw new ParseException(IDENTIFIER_MUST_BE_A_STRING);
            }
            String left = TsdlUtils.concatenateUnaryStrings(leftStrings);
            if (left.equals("id")) {
                if (stream.isIdSet()) {
                    throw new ParseException("stream id already defined");
                }
                long streamID = StreamIdParser.INSTANCE.parse(rightNode, null);
                stream.setId(streamID);
            } else if (left.equals("event.header")) {
                if (stream.isEventHeaderSet()) {
                    throw new ParseException("event.header already defined");
                }
                ICTFMetadataNode typeSpecifier = rightNode.getChild(0);
                if (!CTFParser.tokenNames[117].equals(typeSpecifier.getType())) {
                    throw new ParseException("event.header expects a type specifier");
                }
                IDeclaration eventHeaderDecl = TypeSpecifierListParser.INSTANCE.parse(typeSpecifier, new TypeSpecifierListParser.Param(fTrace, null, null, scope));
                DeclarationScope eventHeaderScope = StreamDeclarationParser.lookupStructName(typeSpecifier, scope);
                DeclarationScope eventScope = new DeclarationScope(scope, "event");
                StreamDeclarationParser.verifyEventHeaderScope(eventHeaderScope);
                eventHeaderScope.setName("header");
                eventScope.addChild(eventHeaderScope);
                StreamDeclarationParser.setEventHeader(stream, eventHeaderDecl);
            } else if (left.equals("event.context")) {
                if (stream.isEventContextSet()) {
                    throw new ParseException("event.context already defined");
                }
                ICTFMetadataNode typeSpecifier = rightNode.getChild(0);
                if (!CTFParser.tokenNames[117].equals(typeSpecifier.getType())) {
                    throw new ParseException("event.context expects a type specifier");
                }
                IDeclaration eventContextDecl = TypeSpecifierListParser.INSTANCE.parse(typeSpecifier, new TypeSpecifierListParser.Param(fTrace, null, null, scope));
                StreamDeclarationParser.verifyEventContext(eventContextDecl);
                stream.setEventContext((StructDeclaration)eventContextDecl);
            } else if (left.equals("packet.context")) {
                if (stream.isPacketContextSet()) {
                    throw new ParseException("packet.context already defined");
                }
                ICTFMetadataNode typeSpecifier = rightNode.getChild(0);
                if (!CTFParser.tokenNames[117].equals(typeSpecifier.getType())) {
                    throw new ParseException("packet.context expects a type specifier");
                }
                IDeclaration packetContextDecl = TypeSpecifierListParser.INSTANCE.parse(typeSpecifier, new TypeSpecifierListParser.Param(fTrace, null, null, scope));
                StreamDeclarationParser.verifyPacketContext(packetContextDecl);
                stream.setPacketContext((StructDeclaration)packetContextDecl);
            } else {
                CtfCoreLoggerUtil.logWarning(Messages.IOStructGen_UnknownStreamAttributeWarning + " " + left);
            }
        }
        return stream;
    }

    private static void verifyPacketContext(IDeclaration packetContextDecl) throws ParseException {
        if (!(packetContextDecl instanceof StructDeclaration)) {
            throw new ParseException("packet.context expects a struct");
        }
    }

    private static void verifyEventContext(IDeclaration eventContextDecl) throws ParseException {
        if (!(eventContextDecl instanceof StructDeclaration)) {
            throw new ParseException("event.context expects a struct");
        }
    }

    private static void verifyEventHeaderScope(DeclarationScope eventHeaderScope) throws ParseException {
        if (eventHeaderScope == null) {
            throw new ParseException("event.header scope not found");
        }
    }

    private static void setEventHeader(CTFStream stream, IDeclaration eventHeaderDecl) throws ParseException {
        if (eventHeaderDecl instanceof StructDeclaration) {
            stream.setEventHeader((StructDeclaration)eventHeaderDecl);
        } else if (eventHeaderDecl instanceof IEventHeaderDeclaration) {
            stream.setEventHeader((IEventHeaderDeclaration)eventHeaderDecl);
        } else {
            throw new ParseException("event.header expects a struct");
        }
    }

    private static DeclarationScope lookupStructName(ICTFMetadataNode typeSpecifier, DeclarationScope scope) {
        String name;
        ICTFMetadataNode potentialStructName;
        ICTFMetadataNode potentialStruct = typeSpecifier.getChild(0);
        DeclarationScope eventHeaderScope = null;
        if (CTFParser.tokenNames[106].equals(potentialStruct.getType()) && CTFParser.tokenNames[108].equals((potentialStructName = potentialStruct.getChild(0)).getType()) && (eventHeaderScope = scope.lookupChildRecursive(name = potentialStructName.getChild(0).getText())) == null) {
            eventHeaderScope = StreamDeclarationParser.lookupScopeRecursiveStruct(name, scope);
        }
        if (eventHeaderScope == null) {
            eventHeaderScope = scope.lookupChildRecursive("struct");
        }
        return eventHeaderScope;
    }

    private static DeclarationScope lookupScopeRecursiveStruct(String name, DeclarationScope scope) {
        if (scope == null) {
            return null;
        }
        if (scope.lookupStruct(name) != null) {
            return scope;
        }
        return StreamDeclarationParser.lookupScopeRecursiveStruct(name, scope.getParentScope());
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final CTFStream fStream;
        private final CTFTrace fTrace;
        private final DeclarationScope fDeclarationScope;

        public Param(CTFTrace trace, CTFStream stream, DeclarationScope scope) {
            this.fTrace = trace;
            this.fStream = stream;
            this.fDeclarationScope = scope;
        }
    }
}

