/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.menu;

import java.text.DecimalFormat;
import java.text.ParseException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.dialogs.ChartRangeDialog;
import org.eclipse.swtchart.extensions.dialogs.ChartRangeValues;
import org.eclipse.swtchart.extensions.menu.AbstractChartMenuEntry;
import org.eclipse.swtchart.extensions.menu.IChartMenuEntry;

public class SetRangeChartHandler
extends AbstractChartMenuEntry
implements IChartMenuEntry {
    @Override
    public String getCategory() {
        return "";
    }

    @Override
    public String getName() {
        return "Set Chart Range";
    }

    @Override
    public Image getIcon() {
        return ResourceSupport.getImage("set_range.gif");
    }

    @Override
    public void execute(Shell shell, ScrollableChart scrollableChart) {
        ChartRangeDialog chartRangeDialog = new ChartRangeDialog(shell, scrollableChart);
        chartRangeDialog.create();
        if (chartRangeDialog.open() == 0) {
            try {
                ChartRangeValues chartRangeValues = chartRangeDialog.getChartRangeValues();
                Range rangeX = this.getRange("X_AXIS", scrollableChart, chartRangeValues);
                Range rangeY = this.getRange("Y_AXIS", scrollableChart, chartRangeValues);
                if (rangeX != null && rangeY != null) {
                    scrollableChart.setRange("X_AXIS", rangeX);
                    scrollableChart.setRange("Y_AXIS", rangeY);
                    this.fireUpdateRangeSelection(scrollableChart);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    private void fireUpdateRangeSelection(ScrollableChart scrollableChart) {
        BaseChart baseChart = scrollableChart.getBaseChart();
        Event event = new Event();
        baseChart.fireUpdateCustomRangeSelectionHandlers(event);
    }

    private Range getRange(String axis, ScrollableChart scrollableChart, ChartRangeValues chartRangeValues) throws ParseException {
        double valueStop;
        double valueStart;
        DecimalFormat decimalFormat;
        int selectedAxis;
        BaseChart baseChart = scrollableChart.getBaseChart();
        if (axis.equals("X_AXIS")) {
            selectedAxis = chartRangeValues.getAxisX();
            decimalFormat = baseChart.getDecimalFormat("X_AXIS", selectedAxis);
        } else {
            selectedAxis = chartRangeValues.getAxisY();
            decimalFormat = baseChart.getDecimalFormat("Y_AXIS", selectedAxis);
        }
        if (axis.equals("X_AXIS")) {
            valueStart = decimalFormat.parse(chartRangeValues.getStartX()).doubleValue();
            valueStop = decimalFormat.parse(chartRangeValues.getStopX()).doubleValue();
        } else {
            valueStart = decimalFormat.parse(chartRangeValues.getStartY()).doubleValue();
            valueStop = decimalFormat.parse(chartRangeValues.getStopY()).doubleValue();
        }
        Range range = null;
        if (selectedAxis == 0) {
            range = new Range(valueStart, valueStop);
        } else {
            IAxisScaleConverter axisScaleConverter = baseChart.getAxisScaleConverter(axis, selectedAxis);
            if (axisScaleConverter != null) {
                valueStart = axisScaleConverter.convertToPrimaryUnit(valueStart);
                valueStop = axisScaleConverter.convertToPrimaryUnit(valueStop);
                range = new Range(valueStart, valueStop);
            }
        }
        return range;
    }
}

