/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBinaryStreamListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IBinaryStreamMonitor;
import org.eclipse.debug.core.model.IBinaryStreamsProxy;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ConsoleLineNotifier;
import org.eclipse.debug.internal.ui.views.console.ConsoleMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;

public class ProcessConsole
extends IOConsole
implements IConsole,
IDebugEventSetListener,
IPropertyChangeListener {
    private IProcess fProcess = null;
    private final List<StreamListener> fStreamListeners = new ArrayList<StreamListener>();
    private final IConsoleColorProvider fColorProvider;
    private IOConsoleInputStream fUserInput;
    private volatile InputStream fInput;
    private FileOutputStream fFileOutputStream;
    private boolean fAllocateConsole = true;
    private String fStdInFile = null;
    private volatile boolean fStreamsClosed = false;

    public ProcessConsole(IProcess process, IConsoleColorProvider colorProvider) {
        this(process, colorProvider, null);
    }

    public ProcessConsole(IProcess process, IConsoleColorProvider colorProvider, String encoding) {
        super("", "org.eclipse.debug.ui.ProcessConsoleType", null, encoding, true);
        IConsoleLineTracker[] lineTrackers;
        this.fProcess = process;
        this.fUserInput = this.getInputStream();
        ILaunchConfiguration configuration = process.getLaunch().getLaunchConfiguration();
        String file = null;
        boolean append = false;
        if (configuration != null) {
            try {
                file = configuration.getAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", null);
                this.fStdInFile = configuration.getAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_STDIN_FILE", null);
                if (file != null || this.fStdInFile != null) {
                    IStringVariableManager stringVariableManager = VariablesPlugin.getDefault().getStringVariableManager();
                    if (file != null) {
                        file = stringVariableManager.performStringSubstitution(file);
                        append = configuration.getAttribute("org.eclipse.debug.ui.ATTR_APPEND_TO_FILE", false);
                    }
                    if (this.fStdInFile != null) {
                        this.fStdInFile = stringVariableManager.performStringSubstitution(this.fStdInFile);
                    }
                }
            }
            catch (CoreException stringVariableManager) {
                // empty catch block
            }
        }
        if (file != null && configuration != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IPath path = IPath.fromOSString((String)file);
            IFile ifile = root.getFileForLocation(path);
            String message = null;
            try {
                String fileLoc = null;
                if (ifile != null) {
                    if (append && ifile.exists()) {
                        ifile.appendContents((InputStream)new ByteArrayInputStream(new byte[0]), true, true, (IProgressMonitor)new NullProgressMonitor());
                    } else {
                        if (ifile.exists()) {
                            ifile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        ifile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                File outputFile = new File(file);
                this.fFileOutputStream = new FileOutputStream(outputFile, append);
                fileLoc = outputFile.getAbsolutePath();
                message = MessageFormat.format(ConsoleMessages.ProcessConsole_1, fileLoc);
                this.addPatternMatchListener(new ConsoleLogFilePatternMatcher(fileLoc));
            }
            catch (FileNotFoundException e) {
                message = MessageFormat.format(ConsoleMessages.ProcessConsole_2, file);
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
            if (message != null) {
                try {
                    Throwable e = null;
                    Object var13_23 = null;
                    try (IOConsoleOutputStream stream = this.newOutputStream();){
                        stream.write(message);
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    DebugUIPlugin.log(e);
                }
            }
            try {
                this.fAllocateConsole = configuration.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (this.fStdInFile != null && configuration != null) {
            String message = null;
            try {
                this.fInput = new FileInputStream(new File(this.fStdInFile));
                if (this.fInput != null) {
                    this.setInputStream(this.fInput);
                }
            }
            catch (FileNotFoundException e) {
                message = MessageFormat.format(ConsoleMessages.ProcessConsole_3, this.fStdInFile);
            }
            if (message != null) {
                try {
                    Throwable e = null;
                    Object var9_13 = null;
                    try (IOConsoleOutputStream stream = this.newOutputStream();){
                        stream.write(message);
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }
        this.fColorProvider = colorProvider;
        if (this.fInput == null) {
            this.fInput = this.getInputStream();
        }
        colorProvider.connect(this.fProcess, this);
        this.setName(this.computeName());
        Color color = this.fColorProvider.getColor("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM");
        if (this.fInput instanceof IOConsoleInputStream) {
            ((IOConsoleInputStream)this.fInput).setColor(color);
        }
        if ((lineTrackers = DebugUIPlugin.getDefault().getProcessConsoleManager().getLineTrackers(process)).length > 0) {
            this.addPatternMatchListener(new ConsoleLineNotifier());
        }
    }

    protected ImageDescriptor computeImageDescriptor() {
        ILaunchConfiguration configuration = this.getProcess().getLaunch().getLaunchConfiguration();
        if (configuration != null) {
            try {
                ILaunchConfigurationType type = configuration.getType();
                return DebugPluginImages.getImageDescriptor(type.getIdentifier());
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return null;
    }

    protected String computeName() {
        String label = null;
        IProcess process = this.getProcess();
        ILaunchConfiguration config = process.getLaunch().getLaunchConfiguration();
        label = process.getAttribute(IProcess.ATTR_PROCESS_LABEL);
        if (label == null) {
            if (config == null) {
                label = process.getLabel();
            } else if (DebugUITools.isPrivate(config)) {
                label = process.getLabel();
            } else {
                int end;
                int idx;
                String type = null;
                try {
                    type = config.getType().getName();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                StringBuilder buffer = new StringBuilder();
                buffer.append(config.getName());
                if (type != null) {
                    buffer.append(" [");
                    buffer.append(type);
                    buffer.append("] ");
                }
                Date launchTime = ProcessConsole.parseTimestamp(process.getAttribute("org.eclipse.debug.core.launch.timestamp"));
                Date terminateTime = ProcessConsole.parseTimestamp(process.getAttribute("org.eclipse.debug.core.terminate.timestamp"));
                String procLabel = process.getLabel();
                if (launchTime != null && (idx = procLabel.lastIndexOf(40)) >= 0 && (end = procLabel.lastIndexOf(41)) > idx) {
                    String jdtTime = procLabel.substring(idx + 1, end);
                    try {
                        DateFormat.getDateTimeInstance(2, 2).parse(jdtTime);
                        procLabel = procLabel.substring(0, idx);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(2, 2);
                if (launchTime != null && terminateTime != null) {
                    LocalDateTime terminateDay;
                    String launchTimeStr = dateTimeFormat.format(launchTime);
                    LocalDateTime launchDate = LocalDateTime.ofInstant(launchTime.toInstant(), ZoneId.systemDefault());
                    LocalDateTime terminateDate = LocalDateTime.ofInstant(terminateTime.toInstant(), ZoneId.systemDefault());
                    LocalDateTime launchDay = launchDate.truncatedTo(ChronoUnit.DAYS);
                    String terminateTimeStr = launchDay.equals(terminateDay = terminateDate.truncatedTo(ChronoUnit.DAYS)) ? DateFormat.getTimeInstance(2).format(terminateTime) : dateTimeFormat.format(terminateTime);
                    buffer.append(MessageFormat.format(ConsoleMessages.ProcessConsole_commandLabel_withStartEnd, procLabel, launchTimeStr, terminateTimeStr));
                } else if (launchTime != null) {
                    buffer.append(MessageFormat.format(ConsoleMessages.ProcessConsole_commandLabel_withStart, procLabel, dateTimeFormat.format(launchTime)));
                } else if (terminateTime != null) {
                    buffer.append(MessageFormat.format(ConsoleMessages.ProcessConsole_commandLabel_withEnd, procLabel, dateTimeFormat.format(terminateTime)));
                }
                String pid = process.getAttribute(IProcess.ATTR_PROCESS_ID);
                if (pid != null && !pid.isBlank()) {
                    buffer.append(" [pid: ");
                    buffer.append(pid);
                    buffer.append("]");
                }
                label = buffer.toString();
            }
        }
        if (process.isTerminated()) {
            return MessageFormat.format(ConsoleMessages.ProcessConsole_0, label);
        }
        return label;
    }

    private static Date parseTimestamp(String timestamp) {
        if (timestamp == null) {
            return null;
        }
        try {
            long lTimestamp = Long.parseLong(timestamp);
            return new Date(lTimestamp);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getProperty();
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        if (property.equals("Console.wrap") || property.equals("Console.width")) {
            boolean fixedWidth = store.getBoolean("Console.wrap");
            if (fixedWidth) {
                int width = store.getInt("Console.width");
                this.setConsoleWidth(width);
            } else {
                this.setConsoleWidth(-1);
            }
        } else if (property.equals("Console.limitConsoleOutput") || property.equals("Console.highWaterMark") || property.equals("Console.lowWaterMark")) {
            boolean limitBufferSize = store.getBoolean("Console.limitConsoleOutput");
            if (limitBufferSize) {
                int lowWater;
                int highWater = store.getInt("Console.highWaterMark");
                if (highWater > (lowWater = store.getInt("Console.lowWaterMark"))) {
                    this.setWaterMarks(lowWater, highWater);
                }
            } else {
                this.setWaterMarks(-1, -1);
            }
        } else if (property.equals("Console.console_tab_width")) {
            int tabWidth = store.getInt("Console.console_tab_width");
            this.setTabWidth(tabWidth);
        } else if (property.equals("DEBUG.consoleOpenOnOut")) {
            boolean activateOnOut = store.getBoolean("DEBUG.consoleOpenOnOut");
            IOConsoleOutputStream stream = this.getStream("org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM");
            if (stream != null) {
                stream.setActivateOnWrite(activateOnOut);
            }
        } else if (property.equals("DEBUG.consoleOpenOnErr")) {
            boolean activateOnErr = store.getBoolean("DEBUG.consoleOpenOnErr");
            IOConsoleOutputStream stream = this.getStream("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM");
            if (stream != null) {
                stream.setActivateOnWrite(activateOnErr);
            }
        } else if (property.equals("org.eclipse.debug.ui.outColor")) {
            IOConsoleOutputStream stream = this.getStream("org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM");
            if (stream != null) {
                stream.setColor(this.fColorProvider.getColor("org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM"));
            }
        } else if (property.equals("org.eclipse.debug.ui.errorColor")) {
            IOConsoleOutputStream stream = this.getStream("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM");
            if (stream != null) {
                stream.setColor(this.fColorProvider.getColor("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM"));
            }
        } else if (property.equals("org.eclipse.debug.ui.inColor")) {
            if (this.fInput != null && this.fInput instanceof IOConsoleInputStream) {
                ((IOConsoleInputStream)this.fInput).setColor(this.fColorProvider.getColor("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM"));
            }
        } else if (property.equals("org.eclipse.debug.ui.consoleFont")) {
            this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
        } else if (property.equals("org.eclipse.debug.ui.consoleBackground")) {
            this.setBackground(DebugUIPlugin.getPreferenceColor("org.eclipse.debug.ui.consoleBackground"));
        } else if (property.equals("Console.interpret_control_characters")) {
            this.setHandleControlCharacters(store.getBoolean("Console.interpret_control_characters"));
        } else if (property.equals("Console.interpret_cr_as_control_characters")) {
            this.setCarriageReturnAsControlCharacter(store.getBoolean("Console.interpret_cr_as_control_characters"));
        }
    }

    @Override
    public IOConsoleOutputStream getStream(String streamIdentifier) {
        if (streamIdentifier == null) {
            return null;
        }
        for (StreamListener listener : this.fStreamListeners) {
            if (!streamIdentifier.equals(listener.fStreamId)) continue;
            return listener.fStream;
        }
        return null;
    }

    @Override
    public IProcess getProcess() {
        return this.fProcess;
    }

    protected void dispose() {
        super.dispose();
        this.fColorProvider.disconnect();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        this.closeStreams();
        this.disposeStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeStreams() {
        if (this.fStreamsClosed) {
            return;
        }
        for (StreamListener listener : this.fStreamListeners) {
            listener.closeStream();
        }
        if (this.fFileOutputStream != null) {
            FileOutputStream fileOutputStream = this.fFileOutputStream;
            synchronized (fileOutputStream) {
                try {
                    this.fFileOutputStream.flush();
                    this.fFileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        try {
            this.fInput.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.fInput != this.fUserInput) {
            try {
                this.fUserInput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fStreamsClosed = true;
    }

    private synchronized void disposeStreams() {
        for (StreamListener listener : this.fStreamListeners) {
            listener.dispose();
        }
        this.fFileOutputStream = null;
        this.fInput = null;
        this.fUserInput = null;
    }

    protected void init() {
        super.init();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        if (this.fProcess.isTerminated()) {
            this.closeStreams();
            this.resetName();
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        }
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        if (store.getBoolean("Console.wrap")) {
            this.setConsoleWidth(store.getInt("Console.width"));
        }
        this.setTabWidth(store.getInt("Console.console_tab_width"));
        if (store.getBoolean("Console.limitConsoleOutput")) {
            int highWater = store.getInt("Console.highWaterMark");
            int lowWater = store.getInt("Console.lowWaterMark");
            this.setWaterMarks(lowWater, highWater);
        }
        this.setHandleControlCharacters(store.getBoolean("Console.interpret_control_characters"));
        this.setCarriageReturnAsControlCharacter(store.getBoolean("Console.interpret_cr_as_control_characters"));
        DebugUIPlugin.getStandardDisplay().asyncExec(() -> {
            this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
            this.setBackground(DebugUIPlugin.getPreferenceColor("org.eclipse.debug.ui.consoleBackground"));
        });
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getSource().equals(this.getProcess())) {
                if (event.getKind() == 8) {
                    this.closeStreams();
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                }
                this.resetName();
            }
            ++n2;
        }
    }

    private synchronized void resetName() {
        final String newName = this.computeName();
        String name = this.getName();
        if (!name.equals(newName)) {
            UIJob job = new UIJob("Update console title"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ProcessConsole.this.setName(newName);
                    ProcessConsole.this.warnOfContentChange();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private void warnOfContentChange() {
        ConsolePlugin.getDefault().getConsoleManager().warnOfContentChange(DebugUITools.getConsole(this.fProcess));
    }

    @Override
    public void connect(IStreamsProxy streamsProxy) {
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        IStreamMonitor streamMonitor = streamsProxy.getErrorStreamMonitor();
        if (streamMonitor != null) {
            this.connect(streamMonitor, "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM", store.getBoolean("DEBUG.consoleOpenOnErr"));
        }
        if ((streamMonitor = streamsProxy.getOutputStreamMonitor()) != null) {
            this.connect(streamMonitor, "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM", store.getBoolean("DEBUG.consoleOpenOnOut"));
        }
        InputReadJob readJob = new InputReadJob(streamsProxy);
        readJob.setSystem(true);
        readJob.schedule();
    }

    @Override
    public void connect(IStreamMonitor streamMonitor, String streamIdentifier) {
        this.connect(streamMonitor, streamIdentifier, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(IStreamMonitor streamMonitor, String streamIdentifier, boolean activateOnWrite) {
        IOConsoleOutputStream stream = null;
        if (this.fAllocateConsole) {
            stream = this.newOutputStream();
            Color color = this.fColorProvider.getColor(streamIdentifier);
            stream.setColor(color);
            stream.setActivateOnWrite(activateOnWrite);
        }
        IStreamMonitor iStreamMonitor = streamMonitor;
        synchronized (iStreamMonitor) {
            StreamListener listener = new StreamListener(streamIdentifier, streamMonitor, stream);
            this.fStreamListeners.add(listener);
        }
    }

    @Override
    public void addLink(IConsoleHyperlink link, int offset, int length) {
        try {
            this.addHyperlink(link, offset, length);
        }
        catch (BadLocationException e) {
            DebugUIPlugin.log(e);
        }
    }

    @Override
    public void addLink(IHyperlink link, int offset, int length) {
        try {
            this.addHyperlink(link, offset, length);
        }
        catch (BadLocationException e) {
            DebugUIPlugin.log(e);
        }
    }

    @Override
    public IRegion getRegion(IConsoleHyperlink link) {
        return super.getRegion((IHyperlink)link);
    }

    public ImageDescriptor getImageDescriptor() {
        if (super.getImageDescriptor() == null) {
            this.setImageDescriptor(this.computeImageDescriptor());
        }
        return super.getImageDescriptor();
    }

    public String getHelpContextId() {
        return "org.eclipse.debug.ui.process_console_context";
    }

    private static class ConsoleLogFileHyperlink
    implements IHyperlink {
        String fFilePath;

        ConsoleLogFileHyperlink(String filePath) {
            this.fFilePath = filePath;
        }

        public void linkActivated() {
            Object input;
            IPath path = IPath.fromOSString((String)this.fFilePath);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile ifile = root.getFileForLocation(path);
            if (ifile == null) {
                File file = new File(this.fFilePath);
                LocalFileStorage lfs = new LocalFileStorage(file);
                input = new StorageEditorInput((IStorage)lfs, file);
            } else {
                input = new FileEditorInput(ifile);
            }
            IWorkbenchPage activePage = DebugUIPlugin.getActiveWorkbenchWindow().getActivePage();
            try {
                activePage.openEditor((IEditorInput)input, "org.eclipse.ui.DefaultTextEditor", true);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }
    }

    private class ConsoleLogFilePatternMatcher
    implements IPatternMatchListener {
        String fFilePath;

        public ConsoleLogFilePatternMatcher(String filePath) {
            this.fFilePath = filePath;
        }

        public String getPattern() {
            return Pattern.quote(this.fFilePath);
        }

        public void matchFound(PatternMatchEvent event) {
            try {
                ProcessConsole.this.addHyperlink(new ConsoleLogFileHyperlink(this.fFilePath), event.getOffset(), event.getLength());
                ProcessConsole.this.removePatternMatchListener(this);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public int getCompilerFlags() {
            return 0;
        }

        public String getLineQualifier() {
            return null;
        }

        public void connect(TextConsole console) {
        }

        public void disconnect() {
        }
    }

    private class InputReadJob
    extends Job {
        private final IStreamsProxy streamsProxy;
        private InputStream readingStream;

        InputReadJob(IStreamsProxy streamsProxy) {
            super("Process Console Input Job");
            this.streamsProxy = streamsProxy;
        }

        protected void canceling() {
            super.canceling();
            if (this.readingStream != null) {
                try {
                    this.readingStream.close();
                }
                catch (IOException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }

        public boolean belongsTo(Object family) {
            return ProcessConsole.class == family;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            IStatus iStatus;
            if (ProcessConsole.this.fInput == null || ProcessConsole.this.fStreamsClosed) {
                IStatus iStatus2;
                if (monitor.isCanceled()) {
                    iStatus2 = Status.CANCEL_STATUS;
                    return iStatus2;
                }
                iStatus2 = Status.OK_STATUS;
                return iStatus2;
            }
            if (this.streamsProxy instanceof IBinaryStreamsProxy) {
                try {
                    byte[] buffer = new byte[1024];
                    int bytesRead = 0;
                    while (bytesRead >= 0 && !monitor.isCanceled() && ProcessConsole.this.fInput != null && !ProcessConsole.this.fStreamsClosed) {
                        if (ProcessConsole.this.fInput != this.readingStream) {
                            this.readingStream = ProcessConsole.this.fInput;
                        }
                        if ((bytesRead = this.readingStream.read(buffer)) <= 0) continue;
                        ((IBinaryStreamsProxy)this.streamsProxy).write(buffer, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    DebugUIPlugin.log(e);
                }
            } else {
                Charset encoding = ProcessConsole.this.getCharset();
                this.readingStream = ProcessConsole.this.fInput;
                InputStreamReader streamReader = encoding == null ? new InputStreamReader(this.readingStream) : new InputStreamReader(this.readingStream, encoding);
                try {
                    char[] cbuf = new char[1024];
                    int charRead = 0;
                    while (charRead >= 0 && !monitor.isCanceled() && ProcessConsole.this.fInput != null && !ProcessConsole.this.fStreamsClosed) {
                        if (ProcessConsole.this.fInput != this.readingStream) {
                            this.readingStream = ProcessConsole.this.fInput;
                            InputStreamReader inputStreamReader = streamReader = encoding == null ? new InputStreamReader(this.readingStream) : new InputStreamReader(this.readingStream, encoding);
                        }
                        if ((charRead = streamReader.read(cbuf)) <= 0) continue;
                        String s = new String(cbuf, 0, charRead);
                        this.streamsProxy.write(s);
                    }
                }
                catch (IOException e) {
                    DebugUIPlugin.log(e);
                }
            }
            this.readingStream = null;
            if (monitor.isCanceled()) {
                iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            iStatus = Status.OK_STATUS;
            return iStatus;
        }
    }

    static class StorageEditorInput
    extends PlatformObject
    implements IStorageEditorInput {
        private final File fFile;
        private final IStorage fStorage;

        public StorageEditorInput(IStorage storage, File file) {
            this.fStorage = storage;
            this.fFile = file;
        }

        public IStorage getStorage() {
            return this.fStorage;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.getStorage().getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return this.getStorage().getFullPath().toOSString();
        }

        public boolean equals(Object object) {
            return object instanceof StorageEditorInput && this.getStorage().equals(((StorageEditorInput)((Object)object)).getStorage());
        }

        public int hashCode() {
            return this.getStorage().hashCode();
        }

        public boolean exists() {
            return this.fFile.exists();
        }
    }

    private class StreamListener
    implements IStreamListener,
    IBinaryStreamListener {
        private IOConsoleOutputStream fStream;
        private IStreamMonitor fStreamMonitor;
        private IBinaryStreamMonitor fBinaryStreamMonitor;
        private String fStreamId;
        private boolean fStreamClosed = false;

        public StreamListener(String streamIdentifier, IStreamMonitor monitor, IOConsoleOutputStream stream) {
            this.fStreamId = streamIdentifier;
            this.fStreamMonitor = monitor;
            this.fStream = stream;
            this.fStreamMonitor.addListener((IStreamListener)this);
            if (this.fStreamMonitor instanceof IBinaryStreamMonitor && ProcessConsole.this.fFileOutputStream != null) {
                this.fBinaryStreamMonitor = (IBinaryStreamMonitor)monitor;
                this.fBinaryStreamMonitor.addBinaryListener((IBinaryStreamListener)this);
            }
            this.flushAndDisableBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushAndDisableBuffer() {
            String contents;
            byte[] data = null;
            IStreamMonitor iStreamMonitor = this.fStreamMonitor;
            synchronized (iStreamMonitor) {
                if (this.fBinaryStreamMonitor != null) {
                    data = this.fBinaryStreamMonitor.getData();
                }
                contents = this.fStreamMonitor.getContents();
                if (this.fStreamMonitor instanceof IFlushableStreamMonitor) {
                    IFlushableStreamMonitor m = (IFlushableStreamMonitor)this.fStreamMonitor;
                    m.flushContents();
                    m.setBuffered(false);
                }
            }
            if (data != null) {
                this.streamAppended(data, this.fBinaryStreamMonitor);
            }
            this.streamAppended(contents, this.fStreamMonitor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamAppended(byte[] data, IBinaryStreamMonitor monitor) {
            if (ProcessConsole.this.fFileOutputStream != null) {
                FileOutputStream fileOutputStream = ProcessConsole.this.fFileOutputStream;
                synchronized (fileOutputStream) {
                    try {
                        ProcessConsole.this.fFileOutputStream.write(data);
                    }
                    catch (IOException e) {
                        DebugUIPlugin.log(e);
                    }
                }
            }
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            if (text == null || text.length() == 0) {
                return;
            }
            if (this.fStream != null) {
                try {
                    this.fStream.write(text);
                }
                catch (IOException e) {
                    DebugUIPlugin.log(e);
                }
            }
            if (this.fBinaryStreamMonitor == null && ProcessConsole.this.fFileOutputStream != null) {
                Charset charset = ProcessConsole.this.getCharset();
                byte[] data = charset == null ? text.getBytes() : text.getBytes(charset);
                this.streamAppended(data, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeStream() {
            if (this.fStreamMonitor == null) {
                return;
            }
            IStreamMonitor iStreamMonitor = this.fStreamMonitor;
            synchronized (iStreamMonitor) {
                this.fStreamMonitor.removeListener((IStreamListener)this);
                if (this.fBinaryStreamMonitor != null) {
                    this.fBinaryStreamMonitor.removeBinaryListener((IBinaryStreamListener)this);
                }
                this.fStreamClosed = true;
                try {
                    if (this.fStream != null) {
                        this.fStream.close();
                    }
                }
                catch (IOException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }

        public void dispose() {
            if (!this.fStreamClosed) {
                this.closeStream();
            }
            this.fStream = null;
            this.fStreamMonitor = null;
            this.fStreamId = null;
        }
    }
}

