/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class TestTraceOffsetting {
    private static final String TRACE_START = "<trace>";
    private static final String EVENT_BEGIN = "<event timestamp=\"";
    private static final String EVENT_MIDDLE = " \" name=\"event\"><field name=\"field\" value=\"";
    private static final String EVENT_END = "\" type=\"int\" /></event>";
    private static final String TRACE_END = "</trace>";
    private static final String PROJET_NAME = "TestForOffsetting";
    private static final int NUM_EVENTS = 100;
    private static SWTWorkbenchBot fBot;
    private File fLocation;

    private static String makeEvent(int ts, int val) {
        return EVENT_BEGIN + Integer.toString(ts) + EVENT_MIDDLE + Integer.toString(val) + EVENT_END + "\n";
    }

    @Before
    public void init() throws IOException {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBot Thread");
        SWTBotPreferences.TIMEOUT = 20000L;
        fBot = new SWTWorkbenchBot();
        IEclipsePreferences defaultPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.timezone", "GMT-05:00");
        TmfTimestampFormat.updateDefaultFormats();
        WaitUtils.waitForJobs();
        this.fLocation = File.createTempFile("sample", ".xml");
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedRandomAccessFile braf = new BufferedRandomAccessFile(this.fLocation, "rw");){
            braf.writeBytes(TRACE_START);
            int i = 0;
            while (i < 100) {
                braf.writeBytes(TestTraceOffsetting.makeEvent(i * 100, i % 4));
                ++i;
            }
            braf.writeBytes(TRACE_END);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @After
    public void cleanup() {
        this.fLocation.delete();
        IEclipsePreferences defaultPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.timezone", (String)TmfTimePreferences.getDefaultPreferenceMap().get("org.eclipse.linuxtools.tmf.core.prefs.time.format.timezone"));
        TmfTimestampFormat.updateDefaultFormats();
    }

    @Test
    public void testOffsetting() {
        MacOsVersion macOsVersion = MacOsVersion.getMacOsVersion();
        boolean macBugPresent = macOsVersion != null && macOsVersion.compareTo(new MacOsVersion(10, 11, 1)) >= 0;
        Assume.assumeTrue((!macBugPresent ? 1 : 0) != 0);
        SWTBotUtils.createProject(PROJET_NAME);
        SWTBotTreeItem traceFolderItem = SWTBotUtils.selectTracesFolder(fBot, PROJET_NAME);
        SWTBotUtils.openTrace(PROJET_NAME, this.fLocation.getAbsolutePath(), "org.eclipse.linuxtools.tmf.core.tests.xmlstub");
        SWTBotEditor editor = fBot.editorByTitle(this.fLocation.getName());
        SWTBotTable eventsTableBot = editor.bot().table();
        String timestamp = eventsTableBot.cell(1, 1);
        Assert.assertEquals((Object)"19:00:00.000 000 000", (Object)timestamp);
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, traceFolderItem, this.fLocation.getName());
        traceItem.select();
        traceItem.contextMenu("Apply Time Offset...").click();
        WaitUtils.waitForJobs();
        SWTBotShell shell = fBot.shell("Apply time offset");
        shell.setFocus();
        SWTBotTreeItem[] allItems = fBot.tree().getAllItems();
        SWTBotTreeItem swtBotTreeItem = allItems[0];
        swtBotTreeItem.select();
        swtBotTreeItem.click(1);
        SWTBotText text = shell.bot().text(1);
        text.pressShortcut(new KeyStroke[]{KeyStroke.getInstance((int)57)});
        text.pressShortcut(new KeyStroke[]{KeyStroke.getInstance((int)57)});
        text.pressShortcut(new KeyStroke[]{KeyStroke.getInstance((int)10)});
        WaitUtils.waitForJobs();
        fBot.button("OK").click();
        fBot.waitWhile(ConditionHelpers.isEditorOpened(fBot, this.fLocation.getName()));
        SWTBotUtils.openTrace(PROJET_NAME, this.fLocation.getAbsolutePath(), "org.eclipse.linuxtools.tmf.core.tests.xmlstub");
        editor = fBot.editorByTitle(this.fLocation.getName());
        eventsTableBot = editor.bot().table();
        timestamp = eventsTableBot.cell(1, 1);
        Assert.assertEquals((Object)"19:01:39.000 000 000", (Object)timestamp);
        SWTBotUtils.deleteProject(PROJET_NAME, fBot);
    }

    private static class MacOsVersion
    implements Comparable<MacOsVersion> {
        private static final Pattern MAC_OS_VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");
        private int fMajorVersion;
        private int fMinorVersion;
        private int fBugFixVersion;
        private static MacOsVersion fRunningMacOsVersion;

        private MacOsVersion(int version, int majorVersion, int patchVersion) {
            this.fMajorVersion = version;
            this.fMinorVersion = majorVersion;
            this.fBugFixVersion = patchVersion;
        }

        private int getMajorVersion() {
            return this.fMajorVersion;
        }

        private int getMinorVersion() {
            return this.fMinorVersion;
        }

        private int getBugFixVersion() {
            return this.fBugFixVersion;
        }

        private static MacOsVersion getMacOsVersion() {
            if (fRunningMacOsVersion != null) {
                return fRunningMacOsVersion;
            }
            if (!SWTUtils.isMac()) {
                return null;
            }
            String osVersion = System.getProperty("os.version");
            if (osVersion == null) {
                return null;
            }
            Matcher matcher = MAC_OS_VERSION_PATTERN.matcher(osVersion);
            if (matcher.matches()) {
                try {
                    fRunningMacOsVersion = new MacOsVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
                    return fRunningMacOsVersion;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public int compareTo(MacOsVersion o) {
            int compareTo = Integer.compare(this.fMajorVersion, o.getMajorVersion());
            if (compareTo != 0) {
                return compareTo;
            }
            compareTo = Integer.compare(this.fMinorVersion, o.getMinorVersion());
            if (compareTo != 0) {
                return compareTo;
            }
            return Integer.compare(this.fBugFixVersion, o.getBugFixVersion());
        }
    }
}

